/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.core;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.hao0.common.json.Jsons;
import me.hao0.common.util.Preconditions;
import me.hao0.common.util.Strings;
import me.hao0.wechat.core.AsyncFunction;
import me.hao0.wechat.core.Callback;
import me.hao0.wechat.core.Component;
import me.hao0.wechat.model.base.AuthAccessToken;
import me.hao0.wechat.model.user.Group;
import me.hao0.wechat.model.user.User;
import me.hao0.wechat.model.user.UserInfo;
import me.hao0.wechat.model.user.UserList;

public final class Users
extends Component {
    private static final String CREATE_GROUP = "https://api.weixin.qq.com/cgi-bin/groups/create?access_token=";
    private static final String GET_GROUP = "https://api.weixin.qq.com/cgi-bin/groups/get?access_token=";
    private static final String DELETE_GROUP = "https://api.weixin.qq.com/cgi-bin/groups/delete?access_token=";
    private static final String UPDATE_GROUP = "https://api.weixin.qq.com/cgi-bin/groups/update?access_token=";
    private static final String GROUP_OF_USER = "https://api.weixin.qq.com/cgi-bin/groups/getid?access_token=";
    private static final String MOVE_USER_GROUP = "https://api.weixin.qq.com/cgi-bin/groups/members/update?access_token=";
    private static final String GET_USER_INFO = "https://api.weixin.qq.com/cgi-bin/user/info?lang=zh_CN&access_token=";
    private static final String GET_USER_INFO_AUTHED = "https://api.weixin.qq.com/sns/userinfo?lang=zh_CN&access_token=";
    private static final String GET_USERS_INFO = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=";
    private static final String REMARK_USER = "https://api.weixin.qq.com/cgi-bin/user/info/updateremark?access_token=";
    private static final JavaType ARRAY_LIST_GROUP_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{Group.class});

    Users() {
    }

    public Integer createGroup(String name) {
        return this.createGroup(this.loadAccessToken(), name);
    }

    public void createGroup(String name, Callback<Integer> cb) {
        this.createGroup(this.loadAccessToken(), name, cb);
    }

    public void createGroup(final String accessToken, final String name, Callback<Integer> cb) {
        this.doAsync(new AsyncFunction<Integer>(cb){

            @Override
            public Integer execute() {
                return Users.this.createGroup(accessToken, name);
            }
        });
    }

    public Integer createGroup(String accessToken, String name) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)name, (String)"name");
        String url = CREATE_GROUP + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        Group g = new Group();
        g.setName(name);
        params.put("group", g);
        Map<String, Object> resp = this.doPost(url, params);
        return (Integer)((Map)resp.get("group")).get("id");
    }

    public List<Group> getGroup() {
        return this.getGroup(this.loadAccessToken());
    }

    public void getGroup(final String accessToken, Callback<List<Group>> cb) {
        this.doAsync(new AsyncFunction<List<Group>>(cb){

            @Override
            public List<Group> execute() {
                return Users.this.getGroup(accessToken);
            }
        });
    }

    public List<Group> getGroup(String accessToken) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        String url = GET_GROUP + accessToken;
        Map<String, Object> resp = this.doGet(url);
        return (List)Jsons.EXCLUDE_DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp.get("groups")), ARRAY_LIST_GROUP_TYPE);
    }

    public Boolean deleteGroup(Integer id) {
        return this.deleteGroup(this.loadAccessToken(), id);
    }

    public void deleteGroup(Integer id, Callback<Boolean> cb) {
        this.deleteGroup(this.loadAccessToken(), id, cb);
    }

    public void deleteGroup(final String accessToken, final Integer id, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return Users.this.deleteGroup(accessToken, id);
            }
        });
    }

    public Boolean deleteGroup(String accessToken, Integer id) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkArgument((id != null && id > 0 ? 1 : 0) != 0, (Object)"id must > 0");
        String url = DELETE_GROUP + accessToken;
        Group g = new Group();
        g.setId(id);
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("group", g);
        this.doPost(url, params);
        return Boolean.TRUE;
    }

    public Boolean updateGroup(Integer id, String newName) {
        return this.updateGroup(this.loadAccessToken(), id, newName);
    }

    public void updateGroup(Integer id, String newName, Callback<Boolean> cb) {
        this.updateGroup(this.loadAccessToken(), id, newName, cb);
    }

    public void updateGroup(final String accessToken, final Integer id, final String newName, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return Users.this.updateGroup(accessToken, id, newName);
            }
        });
    }

    public Boolean updateGroup(String accessToken, Integer id, String newName) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkArgument((id != null && id > 0 ? 1 : 0) != 0, (Object)"id must > 0");
        Preconditions.checkNotNullAndEmpty((String)newName, (String)"group name");
        String url = UPDATE_GROUP + accessToken;
        Group g = new Group();
        g.setId(id);
        g.setName(newName);
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("group", g);
        this.doPost(url, params);
        return Boolean.TRUE;
    }

    public Integer getUserGroup(String openId) {
        return this.getUserGroup(this.loadAccessToken(), openId);
    }

    public void getUserGroup(String openId, Callback<Integer> cb) {
        this.getUserGroup(this.loadAccessToken(), openId, cb);
    }

    public void getUserGroup(final String accessToken, final String openId, Callback<Integer> cb) {
        this.doAsync(new AsyncFunction<Integer>(cb){

            @Override
            public Integer execute() {
                return Users.this.getUserGroup(accessToken, openId);
            }
        });
    }

    public Integer getUserGroup(String accessToken, String openId) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)openId, (String)"openId");
        String url = GROUP_OF_USER + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("openid", openId);
        Map<String, Object> resp = this.doPost(url, params);
        return (Integer)resp.get("groupid");
    }

    public Boolean mvUserGroup(String openId, Integer groupId) {
        return this.mvUserGroup(this.loadAccessToken(), openId, groupId);
    }

    public void mvUserGroup(String openId, Integer groupId, Callback<Boolean> cb) {
        this.mvUserGroup(this.loadAccessToken(), openId, groupId, cb);
    }

    public void mvUserGroup(final String accessToken, final String openId, final Integer groupId, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return Users.this.mvUserGroup(accessToken, openId, groupId);
            }
        });
    }

    public Boolean mvUserGroup(String accessToken, String openId, Integer groupId) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)openId, (String)"openId");
        Preconditions.checkArgument((groupId != null && groupId > 0 ? 1 : 0) != 0, (Object)"groupId must > 0");
        String url = MOVE_USER_GROUP + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("openid", openId);
        params.put("to_groupid", groupId);
        this.doPost(url, params);
        return Boolean.TRUE;
    }

    public User getUser(String openId) {
        return this.getUser(this.loadAccessToken(), openId);
    }

    public void getUser(String openId, Callback<User> cb) {
        this.getUser(this.loadAccessToken(), openId, cb);
    }

    public void getUser(final String accessToken, final String openId, Callback<User> cb) {
        this.doAsync(new AsyncFunction<User>(cb){

            @Override
            public User execute() {
                return Users.this.getUser(accessToken, openId);
            }
        });
    }

    public User getUser(String accessToken, String openId) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)openId, (String)"openId");
        String url = GET_USER_INFO + accessToken + "&openid=" + openId;
        Map<String, Object> resp = this.doGet(url);
        return (User)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp), User.class);
    }

    public UserInfo getUserInfo(AuthAccessToken authAccessToken) {
        String url = GET_USER_INFO_AUTHED + authAccessToken.getAccessToken() + "&openid=" + authAccessToken.getOpenId();
        Map<String, Object> resp = this.doGet(url);
        return (UserInfo)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp), UserInfo.class);
    }

    public UserList getUsers(String nextOpenId) {
        return this.getUsers(this.loadAccessToken(), nextOpenId);
    }

    public void getUsers(String nextOpenId, Callback<UserList> cb) {
        this.getUsers(this.loadAccessToken(), nextOpenId, cb);
    }

    public void getUsers(final String accessToken, final String nextOpenId, Callback<UserList> cb) {
        this.doAsync(new AsyncFunction<UserList>(cb){

            @Override
            public UserList execute() throws Exception {
                return Users.this.getUsers(accessToken, nextOpenId);
            }
        });
    }

    public UserList getUsers(String accessToken, String nextOpenId) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        String url = GET_USERS_INFO + accessToken;
        if (!Strings.isNullOrEmpty((String)nextOpenId).booleanValue()) {
            url = url + "&next_openid=" + nextOpenId;
        }
        Map<String, Object> resp = this.doGet(url);
        return (UserList)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp), UserList.class);
    }

    public Boolean remarkUser(String openId, String remark) {
        return this.remarkUser(this.loadAccessToken(), openId, remark);
    }

    public void remarkUser(String openId, String remark, Callback<Boolean> cb) {
        this.remarkUser(this.loadAccessToken(), openId, remark, cb);
    }

    public void remarkUser(final String accessToken, final String openId, final String remark, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return Users.this.remarkUser(accessToken, openId, remark);
            }
        });
    }

    public Boolean remarkUser(String accessToken, String openId, String remark) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)openId, (String)"openId");
        Preconditions.checkNotNullAndEmpty((String)remark, (String)"remark");
        String url = REMARK_USER + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("openid", openId);
        params.put("remark", remark);
        this.doPost(url, params);
        return Boolean.TRUE;
    }
}

