/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.core;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.hao0.common.http.Http;
import me.hao0.common.json.Jsons;
import me.hao0.common.model.Page;
import me.hao0.common.util.Preconditions;
import me.hao0.wechat.core.AsyncFunction;
import me.hao0.wechat.core.Callback;
import me.hao0.wechat.core.Component;
import me.hao0.wechat.exception.WechatException;
import me.hao0.wechat.model.material.CommonMaterial;
import me.hao0.wechat.model.material.MaterialCount;
import me.hao0.wechat.model.material.MaterialType;
import me.hao0.wechat.model.material.MaterialUploadType;
import me.hao0.wechat.model.material.NewsContentItem;
import me.hao0.wechat.model.material.NewsMaterial;
import me.hao0.wechat.model.material.PermMaterial;
import me.hao0.wechat.model.material.TempMaterial;

public final class Materials
extends Component {
    private static final String COUNT = "https://api.weixin.qq.com/cgi-bin/material/get_materialcount?access_token=";
    private static final String GETS = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=";
    private static final String DELETE = "https://api.weixin.qq.com/cgi-bin/material/del_material?access_token=";
    private static final String UPLOAD_TEMP = "https://api.weixin.qq.com/cgi-bin/media/upload?access_token=";
    private static final String DOWNLOAD_TEMP = "https://api.weixin.qq.com/cgi-bin/media/get?access_token=";
    private static final String ADD_NEWS = "https://api.weixin.qq.com/cgi-bin/material/add_news?access_token=";
    private static final String UPDATE_NEWS = "https://api.weixin.qq.com/cgi-bin/material/update_news?access_token=";
    private static final String UPLOAD_NEWS_IMAGE = "https://api.weixin.qq.com/cgi-bin/media/uploadimg?access_token=";
    private static final String UPLOAD_PERM = "https://api.weixin.qq.com/cgi-bin/material/add_material?access_token=";
    private static final JavaType ARRAY_LIST_COMMON_MATERIAL_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{CommonMaterial.class});
    private static final JavaType ARRAY_LIST_NEWS_MATERIAL_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{NewsMaterial.class});

    Materials() {
    }

    public MaterialCount count() {
        return this.count(this.loadAccessToken());
    }

    public void count(Callback<MaterialCount> cb) {
        this.count(this.loadAccessToken(), cb);
    }

    public void count(final String accessToken, Callback<MaterialCount> cb) {
        this.doAsync(new AsyncFunction<MaterialCount>(cb){

            @Override
            public MaterialCount execute() {
                return Materials.this.count(accessToken);
            }
        });
    }

    public MaterialCount count(String accessToken) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        String url = COUNT + accessToken;
        Map<String, Object> resp = this.doGet(url);
        return (MaterialCount)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp), MaterialCount.class);
    }

    public <T> Page<T> gets(MaterialType type, Integer offset, Integer count) {
        return this.gets(this.loadAccessToken(), type, offset, count);
    }

    public <T> void gets(MaterialType type, Integer offset, Integer count, Callback<Page<T>> cb) {
        this.gets(this.loadAccessToken(), type, offset, count, cb);
    }

    public <T> void gets(final String accessToken, final MaterialType type, final Integer offset, final Integer count, Callback<Page<T>> cb) {
        this.doAsync(new AsyncFunction<Page<T>>(cb){

            @Override
            public Page<T> execute() {
                return Materials.this.gets(accessToken, type, offset, count);
            }
        });
    }

    public <T> Page<T> gets(String accessToken, MaterialType type, Integer offset, Integer count) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"material type can't be null");
        String url = GETS + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put("type", type.value());
        params.put("offset", offset == null ? 0 : offset);
        params.put("count", count == null ? 10 : count);
        Map<String, Object> resp = this.doPost(url, params);
        return this.renderMaterialPage(type, resp);
    }

    private <T> Page<T> renderMaterialPage(MaterialType type, Map<String, Object> resp) {
        Integer itemCount = (Integer)resp.get("item_count");
        if (itemCount == null || itemCount <= 0) {
            return Page.empty();
        }
        Integer itemTotal = (Integer)resp.get("total_count");
        JavaType materialType = MaterialType.NEWS == type ? ARRAY_LIST_NEWS_MATERIAL_TYPE : ARRAY_LIST_COMMON_MATERIAL_TYPE;
        List materials = (List)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp.get("item")), materialType);
        return new Page(Long.valueOf(itemTotal.intValue()), materials);
    }

    public Boolean delete(String mediaId) {
        return this.delete(this.loadAccessToken(), mediaId);
    }

    public void delete(String mediaId, Callback<Boolean> cb) {
        this.delete(this.loadAccessToken(), mediaId, cb);
    }

    public void delete(final String accessToken, final String mediaId, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return Materials.this.delete(accessToken, mediaId);
            }
        });
    }

    public Boolean delete(String accessToken, String mediaId) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)mediaId, (String)"mediaId");
        String url = DELETE + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("media_id", mediaId);
        this.doPost(url, params);
        return Boolean.TRUE;
    }

    public TempMaterial uploadTemp(MaterialUploadType type, String fileName, byte[] fileData) {
        return this.uploadTemp(this.loadAccessToken(), type, fileName, new ByteArrayInputStream(fileData));
    }

    public TempMaterial uploadTemp(String accessToken, MaterialUploadType type, String fileName, byte[] fileData) {
        return this.uploadTemp(accessToken, type, fileName, new ByteArrayInputStream(fileData));
    }

    public TempMaterial uploadTemp(MaterialUploadType type, File media) {
        return this.uploadTemp(this.loadAccessToken(), type, media);
    }

    public TempMaterial uploadTemp(String accessToken, MaterialUploadType type, File media) {
        try {
            return this.uploadTemp(accessToken, type, media.getName(), new FileInputStream(media));
        }
        catch (FileNotFoundException e) {
            throw new WechatException(e);
        }
    }

    public void uploadTemp(MaterialUploadType type, File media, Callback<TempMaterial> cb) {
        try {
            this.uploadTemp(this.loadAccessToken(), type, media.getName(), new FileInputStream(media), cb);
        }
        catch (FileNotFoundException e) {
            throw new WechatException(e);
        }
    }

    public void uploadTemp(String accessToken, MaterialUploadType type, File media, Callback<TempMaterial> cb) {
        try {
            this.uploadTemp(accessToken, type, media.getName(), new FileInputStream(media), cb);
        }
        catch (FileNotFoundException e) {
            throw new WechatException(e);
        }
    }

    public TempMaterial uploadTemp(MaterialUploadType type, String fileName, InputStream input) {
        return this.uploadTemp(this.loadAccessToken(), type, fileName, input);
    }

    public void uploadTemp(MaterialUploadType type, String fileName, InputStream input, Callback<TempMaterial> cb) {
        this.uploadTemp(this.loadAccessToken(), type, fileName, input, cb);
    }

    public void uploadTemp(final String accessToken, final MaterialUploadType type, final String fileName, final InputStream input, Callback<TempMaterial> cb) {
        this.doAsync(new AsyncFunction<TempMaterial>(cb){

            @Override
            public TempMaterial execute() {
                return Materials.this.uploadTemp(accessToken, type, fileName, input);
            }
        });
    }

    public TempMaterial uploadTemp(String accessToken, MaterialUploadType type, String fileName, InputStream input) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"material upload type can't be null");
        Preconditions.checkNotNullAndEmpty((String)fileName, (String)"fileName");
        Preconditions.checkNotNull((Object)input, (Object)"input can't be null");
        String url = UPLOAD_TEMP + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("type", type.value());
        Map<String, Object> resp = this.doUpload(url, "media", fileName, input, params);
        return (TempMaterial)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp), TempMaterial.class);
    }

    public byte[] downloadTemp(String mediaId) {
        return this.downloadTemp(this.loadAccessToken(), mediaId);
    }

    public void downloadTemp(String mediaId, Callback<byte[]> cb) {
        this.downloadTemp(this.loadAccessToken(), mediaId, cb);
    }

    public void downloadTemp(final String accessToken, final String mediaId, Callback<byte[]> cb) {
        this.doAsync(new AsyncFunction<byte[]>(cb){

            @Override
            public byte[] execute() {
                return Materials.this.downloadTemp(accessToken, mediaId);
            }
        });
    }

    public byte[] downloadTemp(String accessToken, String mediaId) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)mediaId, (String)"mediaId");
        String url = DOWNLOAD_TEMP + accessToken + "&media_id=" + mediaId;
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        Http.download((String)url, (OutputStream)output);
        return output.toByteArray();
    }

    public String uploadPermNews(List<NewsContentItem> items) {
        return this.uploadPermNews(this.loadAccessToken(), items);
    }

    public void uploadPermNews(List<NewsContentItem> items, Callback<String> cb) {
        this.uploadPermNews(this.loadAccessToken(), items, cb);
    }

    public void uploadPermNews(final String accessToken, final List<NewsContentItem> items, Callback<String> cb) {
        this.doAsync(new AsyncFunction<String>(cb){

            @Override
            public String execute() {
                return Materials.this.uploadPermNews(accessToken, items);
            }
        });
    }

    public String uploadPermNews(String accessToken, List<NewsContentItem> items) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty(items, (String)"items");
        String url = ADD_NEWS + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("articles", items);
        Map<String, Object> resp = this.doPost(url, params);
        return (String)resp.get("media_id");
    }

    public void updatePermNews(String mediaId, Integer itemIndex, NewsContentItem newItem, Callback<Boolean> cb) {
        this.updatePermNews(this.loadAccessToken(), mediaId, itemIndex, newItem, cb);
    }

    public void updatePermNews(final String accessToken, final String mediaId, final Integer itemIndex, final NewsContentItem newItem, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return Materials.this.updatePermNews(accessToken, mediaId, itemIndex, newItem);
            }
        });
    }

    public Boolean updatePermNews(String accessToken, String mediaId, Integer itemIndex, NewsContentItem newItem) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)mediaId, (String)"mediaId");
        Preconditions.checkArgument((itemIndex != null && itemIndex > 0 ? 1 : 0) != 0, (Object)"itemIndex can't be null and must > 0");
        Preconditions.checkNotNull((Object)newItem, (Object)"newItem can't be null");
        String url = UPDATE_NEWS + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put("media_id", mediaId);
        params.put("index", itemIndex);
        params.put("articles", newItem);
        this.doPost(url, params);
        return Boolean.TRUE;
    }

    public String uploadPermNewsImage(String accessToken, File image) {
        try {
            return this.uploadPermNewsImage(accessToken, image.getName(), new FileInputStream(image));
        }
        catch (FileNotFoundException e) {
            throw new WechatException(e);
        }
    }

    public void uploadPermNewsImage(File image, Callback<String> cb) {
        this.uploadPermNewsImage(this.loadAccessToken(), image, cb);
    }

    public void uploadPermNewsImage(String accessToken, File image, Callback<String> cb) {
        try {
            this.uploadPermNewsImage(accessToken, image.getName(), new FileInputStream(image), cb);
        }
        catch (FileNotFoundException e) {
            throw new WechatException(e);
        }
    }

    public String uploadPermNewsImage(String accessToken, String fileName, byte[] data) {
        return this.uploadPermNewsImage(accessToken, fileName, new ByteArrayInputStream(data));
    }

    public void uploadPermNewsImage(String fileName, byte[] data, Callback<String> cb) {
        this.uploadPermNewsImage(this.loadAccessToken(), fileName, new ByteArrayInputStream(data), cb);
    }

    public void uploadPermNewsImage(String accessToken, String fileName, byte[] data, Callback<String> cb) {
        this.uploadPermNewsImage(accessToken, fileName, new ByteArrayInputStream(data), cb);
    }

    public void uploadPermNewsImage(String fileName, InputStream in, Callback<String> cb) {
        this.uploadPermNewsImage(this.loadAccessToken(), fileName, in, cb);
    }

    public void uploadPermNewsImage(final String accessToken, final String fileName, final InputStream in, Callback<String> cb) {
        this.doAsync(new AsyncFunction<String>(cb){

            @Override
            public String execute() throws FileNotFoundException {
                return Materials.this.uploadPermNewsImage(accessToken, fileName, in);
            }
        });
    }

    public String uploadPermNewsImage(String accessToken, String fileName, InputStream in) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)fileName, (String)"fileName");
        Preconditions.checkNotNull((Object)in, (Object)"input can't be null");
        String url = UPLOAD_NEWS_IMAGE + accessToken;
        Map<String, Object> resp = this.doUpload(url, "media", fileName, in, Collections.emptyMap());
        return (String)resp.get("url");
    }

    public PermMaterial uploadPerm(String accessToken, MaterialUploadType type, File file) {
        try {
            return this.uploadPerm(accessToken, type, file.getName(), new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new WechatException(e);
        }
    }

    public PermMaterial uploadPerm(String accessToken, MaterialUploadType type, String fileName, byte[] data) {
        return this.uploadPerm(accessToken, type, fileName, new ByteArrayInputStream(data));
    }

    public void uploadPerm(String accessToken, MaterialUploadType type, String fileName, byte[] data, Callback<PermMaterial> cb) {
        this.uploadPerm(accessToken, type, fileName, new ByteArrayInputStream(data), cb);
    }

    public void uploadPerm(MaterialUploadType type, String fileName, byte[] data, Callback<PermMaterial> cb) {
        this.uploadPerm(this.loadAccessToken(), type, fileName, new ByteArrayInputStream(data), cb);
    }

    public PermMaterial uploadPerm(MaterialUploadType type, String fileName, byte[] data) {
        return this.uploadPerm(this.loadAccessToken(), type, fileName, new ByteArrayInputStream(data));
    }

    public void uploadPerm(MaterialUploadType type, File file, Callback<PermMaterial> cb) {
        this.uploadPerm(this.loadAccessToken(), type, file, cb);
    }

    public void uploadPerm(String accessToken, MaterialUploadType type, File file, Callback<PermMaterial> cb) {
        try {
            this.uploadPerm(accessToken, type, file.getName(), new FileInputStream(file), cb);
        }
        catch (FileNotFoundException e) {
            throw new WechatException(e);
        }
    }

    public void uploadPerm(MaterialUploadType type, String fileName, InputStream input, Callback<PermMaterial> cb) {
        this.uploadPerm(this.loadAccessToken(), type, fileName, input, cb);
    }

    public void uploadPerm(final String accessToken, final MaterialUploadType type, final String fileName, final InputStream input, Callback<PermMaterial> cb) {
        this.doAsync(new AsyncFunction<PermMaterial>(cb){

            @Override
            public PermMaterial execute() throws Exception {
                return Materials.this.uploadPerm(accessToken, type, fileName, input);
            }
        });
    }

    public PermMaterial uploadPerm(String accessToken, MaterialUploadType type, String fileName, InputStream input) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"material upload type can't be null");
        Preconditions.checkNotNullAndEmpty((String)fileName, (String)"fileName");
        Preconditions.checkNotNull((Object)input, (Object)"input can't be null");
        if (MaterialUploadType.VIDEO == type) {
            throw new IllegalArgumentException("type must be image, voice, or thumb, you should use uploadPermVideo method.");
        }
        String url = UPLOAD_PERM + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("type", type.value());
        Map<String, Object> resp = this.doUpload(url, "media", fileName, input, params);
        return (PermMaterial)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp), PermMaterial.class);
    }

    public PermMaterial uploadPermVideo(String accessToken, File video, String title, String desc) {
        try {
            return this.uploadPermVideo(accessToken, video.getName(), new FileInputStream(video), title, desc);
        }
        catch (FileNotFoundException e) {
            throw new WechatException(e);
        }
    }

    public PermMaterial uploadPermVideo(File video, String title, String desc) {
        return this.uploadPermVideo(this.loadAccessToken(), video, title, desc);
    }

    public PermMaterial uploadPermVideo(String accessToken, String fileName, byte[] data, String title, String desc) {
        return this.uploadPermVideo(accessToken, fileName, new ByteArrayInputStream(data), title, desc);
    }

    public PermMaterial uploadPermVideo(String fileName, byte[] data, String title, String desc) {
        return this.uploadPermVideo(this.loadAccessToken(), fileName, new ByteArrayInputStream(data), title, desc);
    }

    public void uploadPermVideo(String accessToken, String fileName, byte[] data, String title, String desc, Callback<PermMaterial> cb) {
        this.uploadPermVideo(accessToken, fileName, new ByteArrayInputStream(data), title, desc, cb);
    }

    public void uploadPermVideo(String fileName, byte[] data, String title, String desc, Callback<PermMaterial> cb) {
        this.uploadPermVideo(this.loadAccessToken(), fileName, new ByteArrayInputStream(data), title, desc, cb);
    }

    public void uploadPermVideo(File video, String title, String desc, Callback<PermMaterial> cb) {
        this.uploadPermVideo(this.loadAccessToken(), video, title, desc, cb);
    }

    public void uploadPermVideo(String accessToken, File video, String title, String desc, Callback<PermMaterial> cb) {
        try {
            this.uploadPermVideo(accessToken, video.getName(), new FileInputStream(video), title, desc, cb);
        }
        catch (FileNotFoundException e) {
            throw new WechatException(e);
        }
    }

    public void uploadPermVideo(String fileName, InputStream input, String title, String desc, Callback<PermMaterial> cb) {
        this.uploadPermVideo(this.loadAccessToken(), fileName, input, title, desc, cb);
    }

    public void uploadPermVideo(final String accessToken, final String fileName, final InputStream input, final String title, final String desc, Callback<PermMaterial> cb) {
        this.doAsync(new AsyncFunction<PermMaterial>(cb){

            @Override
            public PermMaterial execute() throws Exception {
                return Materials.this.uploadPermVideo(accessToken, fileName, input, title, desc);
            }
        });
    }

    public PermMaterial uploadPermVideo(String accessToken, String fileName, InputStream input, String title, String desc) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)fileName, (String)"fileName");
        Preconditions.checkNotNull((Object)input, (Object)"input can't be null");
        Preconditions.checkNotNullAndEmpty((String)title, (String)"title");
        Preconditions.checkNotNullAndEmpty((String)desc, (String)"desc");
        String url = UPLOAD_PERM + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("type", MaterialUploadType.VIDEO.value());
        HashMap description = Maps.newHashMapWithExpectedSize((int)2);
        description.put("title", title);
        description.put("introduction", desc);
        params.put("description", Jsons.DEFAULT.toJson((Object)description));
        Map<String, Object> resp = this.doUpload(url, "media", fileName, input, params);
        return (PermMaterial)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp), PermMaterial.class);
    }
}

