/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.core;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.util.Map;
import me.hao0.common.util.Preconditions;
import me.hao0.wechat.core.AsyncFunction;
import me.hao0.wechat.core.Callback;
import me.hao0.wechat.core.Component;
import me.hao0.wechat.model.js.Config;
import me.hao0.wechat.model.js.Ticket;
import me.hao0.wechat.model.js.TicketType;

public final class JsSdks
extends Component {
    private static final String TICKET_GET = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=";

    JsSdks() {
    }

    public void getTicket(TicketType type, Callback<Ticket> cb) {
        this.getTicket(this.loadAccessToken(), type, cb);
    }

    public Ticket getTicket(TicketType type) {
        return this.getTicket(this.loadAccessToken(), type);
    }

    public void getTicket(final String accessToken, final TicketType type, Callback<Ticket> cb) {
        this.doAsync(new AsyncFunction<Ticket>(cb){

            @Override
            public Ticket execute() {
                return JsSdks.this.getTicket(accessToken, type);
            }
        });
    }

    public Ticket getTicket(String accessToken, TicketType type) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"ticket type can't be null");
        String url = TICKET_GET + accessToken + "&type=" + type.type();
        Map<String, Object> resp = this.doGet(url);
        Ticket t = new Ticket();
        t.setTicket((String)resp.get("ticket"));
        Integer expire = (Integer)resp.get("expires_in");
        t.setExpire(expire);
        t.setExpireAt(System.currentTimeMillis() + (long)(expire * 1000));
        t.setType(type);
        return t;
    }

    public Config getConfig(String nonStr, String url) {
        return this.getConfig(this.wechat.loadTicket(TicketType.JSAPI), nonStr, url);
    }

    public Config getConfig(String jsApiTicket, String nonStr, String url) {
        return this.getConfig(jsApiTicket, nonStr, System.currentTimeMillis() / 1000L, url);
    }

    public Config getConfig(String nonStr, Long timestamp, String url) {
        return this.getConfig(this.wechat.loadTicket(TicketType.JSAPI), nonStr, timestamp, url);
    }

    public Config getConfig(String jsApiTicket, String nonStr, Long timestamp, String url) {
        Preconditions.checkNotNullAndEmpty((String)jsApiTicket, (String)"jsApiTicket");
        Preconditions.checkNotNullAndEmpty((String)nonStr, (String)"nonStr");
        Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp can't be null");
        String signStr = "jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s";
        signStr = String.format(signStr, jsApiTicket, nonStr, timestamp, url);
        String sign = Hashing.sha1().hashString((CharSequence)signStr, Charsets.UTF_8).toString().toLowerCase();
        return new Config(this.wechat.getAppId(), timestamp, nonStr, sign);
    }
}

