/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.core;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.hao0.common.json.Jsons;
import me.hao0.common.util.Preconditions;
import me.hao0.wechat.core.AsyncFunction;
import me.hao0.wechat.core.Callback;
import me.hao0.wechat.core.Component;
import me.hao0.wechat.model.data.article.ArticleDailySummary;
import me.hao0.wechat.model.data.article.ArticleShare;
import me.hao0.wechat.model.data.article.ArticleShareHour;
import me.hao0.wechat.model.data.article.ArticleSummary;
import me.hao0.wechat.model.data.article.ArticleSummaryHour;
import me.hao0.wechat.model.data.article.ArticleTotal;
import me.hao0.wechat.model.data.interfaces.InterfaceSummary;
import me.hao0.wechat.model.data.interfaces.InterfaceSummaryHour;
import me.hao0.wechat.model.data.msg.MsgSendDist;
import me.hao0.wechat.model.data.msg.MsgSendSummary;
import me.hao0.wechat.model.data.msg.MsgSendSummaryHour;
import me.hao0.wechat.model.data.user.UserCumulate;
import me.hao0.wechat.model.data.user.UserSummary;

public final class Datas
extends Component {
    private static final String USER_SUMMARY = "https://api.weixin.qq.com/datacube/getusersummary?access_token=";
    private static final String USER_CUMULATE = "https://api.weixin.qq.com/datacube/getusercumulate?access_token=";
    private static final String ARTICLE_DAILY_SUMMARY = "https://api.weixin.qq.com/datacube/getarticlesummary?access_token=";
    private static final String ARTICLE_TOTAL = "https://api.weixin.qq.com/datacube/getarticletotal?access_token=";
    private static final String ARTICLE_SUMMARY = "https://api.weixin.qq.com/datacube/getuserread?access_token=";
    private static final String ARTICLE_SUMMARY_HOUR = "https://api.weixin.qq.com/datacube/getuserreadhour?access_token=";
    private static final String ARTICLE_SHARE = "https://api.weixin.qq.com/datacube/getusershare?access_token=";
    private static final String ARTICLE_SHARE_HOUR = "https://api.weixin.qq.com/datacube/getusersharehour?access_token=";
    private static final String INTERFACE_SUMMARY = "https://api.weixin.qq.com/datacube/getinterfacesummary?access_token=";
    private static final String INTERFACE_SUMMARY_HOUR = "https://api.weixin.qq.com/datacube/getinterfacesummaryhour?access_token=";
    private static final String MSG_SEND_SUMMARY = "https://api.weixin.qq.com/datacube/getupstreammsg?access_token=";
    private static final String MSG_SEND_SUMMARY_HOUR = "https://api.weixin.qq.com/datacube/getupstreammsghour?access_token=";
    private static final String MSG_SEND_SUMMARY_WEEK = "https://api.weixin.qq.com/datacube/getupstreammsgweek?access_token=";
    private static final String MSG_SEND_SUMMARY_MONTH = "https://api.weixin.qq.com/datacube/getupstreammsgmonth?access_token=";
    private static final String MSG_SEND_DIST = "https://api.weixin.qq.com/datacube/getupstreammsgdist?access_token=";
    private static final String MSG_SEND_SUMMARY_DIST_WEEK = "https://api.weixin.qq.com/datacube/getupstreammsgdistweek?access_token=";
    private static final String MSG_SEND_SUMMARY_DIST_MONTH = "https://api.weixin.qq.com/datacube/getupstreammsgdistmonth?access_token=";
    private static final JavaType USER_SUMMARY_LIST_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{UserSummary.class});
    private static final JavaType USER_CUMULATE_LIST_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{UserCumulate.class});
    private static final JavaType ARTICLE_DAILY_SUMMARY_LIST_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{ArticleDailySummary.class});
    private static final JavaType ARTICLE_TOTAL_LIST_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{ArticleTotal.class});
    private static final JavaType ARTICLE_SUMMARY_LIST_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{ArticleSummary.class});
    private static final JavaType ARTICLE_SUMMARY_HOUR_LIST_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{ArticleSummaryHour.class});
    private static final JavaType ARTICLE_SHARE_LIST_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{ArticleShare.class});
    private static final JavaType ARTICLE_SHARE_HOUR_LIST_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{ArticleShareHour.class});
    private static final JavaType INTERFACE_SUMMARY_LIST_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{InterfaceSummary.class});
    private static final JavaType INTERFACE_SUMMARY_HOUR_LIST_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{InterfaceSummaryHour.class});
    private static final JavaType MSG_SEND_SUMMARY_LIST_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{MsgSendSummary.class});
    private static final JavaType MSG_SEND_SUMMARY_HOUR_LIST_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{MsgSendSummaryHour.class});
    private static final JavaType MSG_SEND_DIST_LIST_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{MsgSendDist.class});

    Datas() {
    }

    public List<UserSummary> userSummary(String startDate, String endDate) {
        return this.userSummary(this.loadAccessToken(), startDate, endDate);
    }

    public void userSummary(String startDate, String endDate, Callback<List<UserSummary>> cb) {
        this.userSummary(this.loadAccessToken(), startDate, endDate, cb);
    }

    public void userSummary(final String accessToken, final String startDate, final String endDate, Callback<List<UserSummary>> cb) {
        this.doAsync(new AsyncFunction<List<UserSummary>>(cb){

            @Override
            public List<UserSummary> execute() throws Exception {
                return Datas.this.userSummary(accessToken, startDate, endDate);
            }
        });
    }

    public List<UserSummary> userSummary(String accessToken, String startDate, String endDate) {
        return this.doSummary(USER_SUMMARY + accessToken, startDate, endDate, USER_SUMMARY_LIST_TYPE);
    }

    public List<UserCumulate> userCumulate(String startDate, String endDate) {
        return this.userCumulate(this.loadAccessToken(), startDate, endDate);
    }

    public void userCumulate(String startDate, String endDate, Callback<List<UserCumulate>> cb) {
        this.userCumulate(this.loadAccessToken(), startDate, endDate, cb);
    }

    public void userCumulate(final String accessToken, final String startDate, final String endDate, Callback<List<UserCumulate>> cb) {
        this.doAsync(new AsyncFunction<List<UserCumulate>>(cb){

            @Override
            public List<UserCumulate> execute() throws Exception {
                return Datas.this.userCumulate(accessToken, startDate, endDate);
            }
        });
    }

    public List<UserCumulate> userCumulate(String accessToken, String startDate, String endDate) {
        return this.doSummary(USER_CUMULATE + accessToken, startDate, endDate, USER_CUMULATE_LIST_TYPE);
    }

    public List<ArticleDailySummary> articleDailySummary(String date) {
        return this.articleDailySummary(this.loadAccessToken(), date);
    }

    public void articleDailySummary(final String accessToken, final String date, Callback<List<ArticleDailySummary>> cb) {
        this.doAsync(new AsyncFunction<List<ArticleDailySummary>>(cb){

            @Override
            public List<ArticleDailySummary> execute() throws Exception {
                return Datas.this.articleDailySummary(accessToken, date);
            }
        });
    }

    public void articleDailySummary(String date, Callback<List<ArticleDailySummary>> cb) {
        this.articleDailySummary(this.loadAccessToken(), date, cb);
    }

    public List<ArticleDailySummary> articleDailySummary(String accessToken, String date) {
        return this.doSummary(ARTICLE_DAILY_SUMMARY + accessToken, date, date, ARTICLE_DAILY_SUMMARY_LIST_TYPE);
    }

    public List<ArticleTotal> articleTotal(String date) {
        return this.articleTotal(this.loadAccessToken(), date);
    }

    public void articleTotal(String date, Callback<List<ArticleTotal>> cb) {
        this.articleTotal(this.loadAccessToken(), date, cb);
    }

    public void articleTotal(final String accessToken, final String date, Callback<List<ArticleTotal>> cb) {
        this.doAsync(new AsyncFunction<List<ArticleTotal>>(cb){

            @Override
            public List<ArticleTotal> execute() throws Exception {
                return Datas.this.articleTotal(accessToken, date);
            }
        });
    }

    public List<ArticleTotal> articleTotal(String accessToken, String date) {
        return this.doSummary(ARTICLE_TOTAL + accessToken, date, date, ARTICLE_TOTAL_LIST_TYPE);
    }

    public void articleSummary(String startDate, String endDate, Callback<List<ArticleSummary>> cb) {
        this.articleSummary(this.loadAccessToken(), startDate, endDate, cb);
    }

    public void articleSummary(final String accessToken, final String startDate, final String endDate, Callback<List<ArticleSummary>> cb) {
        this.doAsync(new AsyncFunction<List<ArticleSummary>>(cb){

            @Override
            public List<ArticleSummary> execute() throws Exception {
                return Datas.this.articleSummary(accessToken, startDate, endDate);
            }
        });
    }

    public List<ArticleSummary> articleSummary(String startDate, String endDate) {
        return this.articleSummary(this.loadAccessToken(), startDate, endDate);
    }

    public List<ArticleSummary> articleSummary(String accessToken, String startDate, String endDate) {
        return this.doSummary(ARTICLE_SUMMARY + accessToken, startDate, endDate, ARTICLE_SUMMARY_LIST_TYPE);
    }

    public void articleSummaryHourly(String date, Callback<List<ArticleSummaryHour>> cb) {
        this.articleSummaryHourly(this.loadAccessToken(), date, cb);
    }

    public void articleSummaryHourly(final String accessToken, final String date, Callback<List<ArticleSummaryHour>> cb) {
        this.doAsync(new AsyncFunction<List<ArticleSummaryHour>>(cb){

            @Override
            public List<ArticleSummaryHour> execute() throws Exception {
                return Datas.this.articleSummaryHourly(accessToken, date);
            }
        });
    }

    public List<ArticleSummaryHour> articleSummaryHourly(String date) {
        return this.articleSummaryHourly(this.loadAccessToken(), date);
    }

    public List<ArticleSummaryHour> articleSummaryHourly(String accessToken, String date) {
        return this.doSummary(ARTICLE_SUMMARY_HOUR + accessToken, date, date, ARTICLE_SUMMARY_HOUR_LIST_TYPE);
    }

    public void articleShare(String startDate, String endDate, Callback<List<ArticleShare>> cb) {
        this.articleShare(this.loadAccessToken(), startDate, endDate, cb);
    }

    public void articleShare(final String accessToken, final String startDate, final String endDate, Callback<List<ArticleShare>> cb) {
        this.doAsync(new AsyncFunction<List<ArticleShare>>(cb){

            @Override
            public List<ArticleShare> execute() throws Exception {
                return Datas.this.articleShare(accessToken, startDate, endDate);
            }
        });
    }

    public List<ArticleShare> articleShare(String startDate, String endDate) {
        return this.articleShare(this.loadAccessToken(), startDate, endDate);
    }

    public List<ArticleShare> articleShare(String accessToken, String startDate, String endDate) {
        return this.doSummary(ARTICLE_SHARE + accessToken, startDate, endDate, ARTICLE_SHARE_LIST_TYPE);
    }

    public void articleShareByHourly(String date, Callback<List<ArticleShareHour>> cb) {
        this.articleShareByHourly(this.loadAccessToken(), date, cb);
    }

    public void articleShareByHourly(final String accessToken, final String date, Callback<List<ArticleShareHour>> cb) {
        this.doAsync(new AsyncFunction<List<ArticleShareHour>>(cb){

            @Override
            public List<ArticleShareHour> execute() throws Exception {
                return Datas.this.articleShareByHourly(accessToken, date);
            }
        });
    }

    public List<ArticleShareHour> articleShareByHourly(String date) {
        return this.articleShareByHourly(this.loadAccessToken(), date);
    }

    public List<ArticleShareHour> articleShareByHourly(String accessToken, String date) {
        return this.doSummary(ARTICLE_SHARE_HOUR + accessToken, date, date, ARTICLE_SHARE_HOUR_LIST_TYPE);
    }

    public void interfaceSummary(String startDate, String endDate, Callback<List<InterfaceSummary>> cb) {
        this.interfaceSummary(this.loadAccessToken(), startDate, endDate, cb);
    }

    public void interfaceSummary(final String accessToken, final String startDate, final String endDate, Callback<List<InterfaceSummary>> cb) {
        this.doAsync(new AsyncFunction<List<InterfaceSummary>>(cb){

            @Override
            public List<InterfaceSummary> execute() throws Exception {
                return Datas.this.interfaceSummary(accessToken, startDate, endDate);
            }
        });
    }

    public List<InterfaceSummary> interfaceSummary(String startDate, String endDate) {
        return this.interfaceSummary(this.loadAccessToken(), startDate, endDate);
    }

    public List<InterfaceSummary> interfaceSummary(String accessToken, String startDate, String endDate) {
        return this.doSummary(INTERFACE_SUMMARY + accessToken, startDate, endDate, INTERFACE_SUMMARY_LIST_TYPE);
    }

    public void interfaceSummaryHourly(String date, Callback<List<InterfaceSummaryHour>> cb) {
        this.interfaceSummaryHourly(this.loadAccessToken(), date, cb);
    }

    public void interfaceSummaryHourly(final String accessToken, final String date, Callback<List<InterfaceSummaryHour>> cb) {
        this.doAsync(new AsyncFunction<List<InterfaceSummaryHour>>(cb){

            @Override
            public List<InterfaceSummaryHour> execute() throws Exception {
                return Datas.this.interfaceSummaryHourly(accessToken, date);
            }
        });
    }

    public List<InterfaceSummaryHour> interfaceSummaryHourly(String date) {
        return this.interfaceSummaryHourly(this.loadAccessToken(), date);
    }

    public List<InterfaceSummaryHour> interfaceSummaryHourly(String accessToken, String date) {
        return this.doSummary(INTERFACE_SUMMARY_HOUR + accessToken, date, date, INTERFACE_SUMMARY_HOUR_LIST_TYPE);
    }

    public void msgSendSummary(String startDate, String endDate, Callback<List<MsgSendSummary>> cb) {
        this.msgSendSummary(this.loadAccessToken(), startDate, endDate, cb);
    }

    public void msgSendSummary(final String accessToken, final String startDate, final String endDate, Callback<List<MsgSendSummary>> cb) {
        this.doAsync(new AsyncFunction<List<MsgSendSummary>>(cb){

            @Override
            public List<MsgSendSummary> execute() throws Exception {
                return Datas.this.msgSendSummary(accessToken, startDate, endDate);
            }
        });
    }

    public List<MsgSendSummary> msgSendSummary(String startDate, String endDate) {
        return this.msgSendSummary(this.loadAccessToken(), startDate, endDate);
    }

    public List<MsgSendSummary> msgSendSummary(String accessToken, String startDate, String endDate) {
        return this.doSummary(MSG_SEND_SUMMARY + accessToken, startDate, endDate, MSG_SEND_SUMMARY_LIST_TYPE);
    }

    public void msgSendSummaryHourly(String date, Callback<List<MsgSendSummaryHour>> cb) {
        this.msgSendSummaryHourly(this.loadAccessToken(), date, cb);
    }

    public void msgSendSummaryHourly(final String accessToken, final String date, Callback<List<MsgSendSummaryHour>> cb) {
        this.doAsync(new AsyncFunction<List<MsgSendSummaryHour>>(cb){

            @Override
            public List<MsgSendSummaryHour> execute() throws Exception {
                return Datas.this.msgSendSummaryHourly(accessToken, date);
            }
        });
    }

    public List<MsgSendSummaryHour> msgSendSummaryHourly(String date) {
        return this.msgSendSummaryHourly(this.loadAccessToken(), date);
    }

    public List<MsgSendSummaryHour> msgSendSummaryHourly(String accessToken, String date) {
        return this.doSummary(MSG_SEND_SUMMARY_HOUR + accessToken, date, date, MSG_SEND_SUMMARY_HOUR_LIST_TYPE);
    }

    public void msgSendSummaryWeekly(String startDate, String endDate, Callback<List<MsgSendSummary>> cb) {
        this.msgSendSummaryWeekly(this.loadAccessToken(), startDate, endDate, cb);
    }

    public void msgSendSummaryWeekly(final String accessToken, final String startDate, final String endDate, Callback<List<MsgSendSummary>> cb) {
        this.doAsync(new AsyncFunction<List<MsgSendSummary>>(cb){

            @Override
            public List<MsgSendSummary> execute() throws Exception {
                return Datas.this.msgSendSummary(accessToken, startDate, endDate);
            }
        });
    }

    public List<MsgSendSummary> msgSendSummaryWeekly(String startDate, String endDate) {
        return this.msgSendSummaryWeekly(this.loadAccessToken(), startDate, endDate);
    }

    public List<MsgSendSummary> msgSendSummaryWeekly(String accessToken, String startDate, String endDate) {
        return this.doSummary(MSG_SEND_SUMMARY_WEEK + accessToken, startDate, endDate, MSG_SEND_SUMMARY_LIST_TYPE);
    }

    public void msgSendSummaryMonthly(String startDate, String endDate, Callback<List<MsgSendSummary>> cb) {
        this.msgSendSummaryMonthly(this.loadAccessToken(), startDate, endDate, cb);
    }

    public void msgSendSummaryMonthly(final String accessToken, final String startDate, final String endDate, Callback<List<MsgSendSummary>> cb) {
        this.doAsync(new AsyncFunction<List<MsgSendSummary>>(cb){

            @Override
            public List<MsgSendSummary> execute() throws Exception {
                return Datas.this.msgSendSummaryMonthly(accessToken, startDate, endDate);
            }
        });
    }

    public List<MsgSendSummary> msgSendSummaryMonthly(String startDate, String endDate) {
        return this.msgSendSummaryMonthly(this.loadAccessToken(), startDate, endDate);
    }

    public List<MsgSendSummary> msgSendSummaryMonthly(String accessToken, String startDate, String endDate) {
        return this.doSummary(MSG_SEND_SUMMARY_MONTH + accessToken, startDate, endDate, MSG_SEND_SUMMARY_LIST_TYPE);
    }

    public void msgSendDist(final String accessToken, final String startDate, final String endDate, Callback<List<MsgSendDist>> cb) {
        this.doAsync(new AsyncFunction<List<MsgSendDist>>(cb){

            @Override
            public List<MsgSendDist> execute() throws Exception {
                return Datas.this.msgSendDist(accessToken, startDate, endDate);
            }
        });
    }

    public void msgSendDist(String startDate, String endDate, Callback<List<MsgSendDist>> cb) {
        this.msgSendDist(this.loadAccessToken(), startDate, endDate, cb);
    }

    public List<MsgSendDist> msgSendDist(String startDate, String endDate) {
        return this.msgSendDist(this.loadAccessToken(), startDate, endDate);
    }

    public List<MsgSendDist> msgSendDist(String accessToken, String startDate, String endDate) {
        return this.doSummary(MSG_SEND_DIST + accessToken, startDate, endDate, MSG_SEND_DIST_LIST_TYPE);
    }

    public List<MsgSendDist> msgSendDistWeekly(String startDate, String endDate) {
        return this.msgSendDistWeekly(this.loadAccessToken(), startDate, endDate);
    }

    public void msgSendDistWeekly(String startDate, String endDate, Callback<List<MsgSendDist>> cb) {
        this.msgSendDistWeekly(this.loadAccessToken(), startDate, endDate, cb);
    }

    public void msgSendDistWeekly(final String accessToken, final String startDate, final String endDate, Callback<List<MsgSendDist>> cb) {
        this.doAsync(new AsyncFunction<List<MsgSendDist>>(cb){

            @Override
            public List<MsgSendDist> execute() throws Exception {
                return Datas.this.msgSendDistWeekly(accessToken, startDate, endDate);
            }
        });
    }

    public List<MsgSendDist> msgSendDistWeekly(String accessToken, String startDate, String endDate) {
        return this.doSummary(MSG_SEND_SUMMARY_DIST_WEEK + accessToken, startDate, endDate, MSG_SEND_DIST_LIST_TYPE);
    }

    public List<MsgSendDist> msgSendDistMonthly(String startDate, String endDate) {
        return this.msgSendDistMonthly(this.loadAccessToken(), startDate, endDate);
    }

    public void msgSendDistMonthly(String startDate, String endDate, Callback<List<MsgSendDist>> cb) {
        this.msgSendDistMonthly(this.loadAccessToken(), startDate, endDate, cb);
    }

    public void msgSendDistMonthly(final String accessToken, final String startDate, final String endDate, Callback<List<MsgSendDist>> cb) {
        this.doAsync(new AsyncFunction<List<MsgSendDist>>(cb){

            @Override
            public List<MsgSendDist> execute() throws Exception {
                return Datas.this.msgSendDistMonthly(accessToken, startDate, endDate);
            }
        });
    }

    public List<MsgSendDist> msgSendDistMonthly(String accessToken, String startDate, String endDate) {
        return this.doSummary(MSG_SEND_SUMMARY_DIST_MONTH + accessToken, startDate, endDate, MSG_SEND_DIST_LIST_TYPE);
    }

    private <T> List<T> doSummary(String url, String startDate, String endDate, JavaType type) {
        Preconditions.checkNotNullAndEmpty((String)startDate, (String)"startDate");
        Preconditions.checkNotNullAndEmpty((String)endDate, (String)"endDate");
        Map<String, Object> params = this.buildDateRange(startDate, endDate);
        Map<String, Object> resp = this.doPost(url, params);
        return (List)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp.get("list")), type);
    }

    private Map<String, Object> buildDateRange(String start, String end) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("begin_date", start);
        params.put("end_date", end);
        return params;
    }
}

