/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.core;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.hao0.common.util.Preconditions;
import me.hao0.wechat.core.AsyncFunction;
import me.hao0.wechat.core.Callback;
import me.hao0.wechat.core.Component;
import me.hao0.wechat.exception.WechatException;
import me.hao0.wechat.model.customer.CsSession;
import me.hao0.wechat.model.customer.MsgRecord;
import me.hao0.wechat.model.customer.UserSession;
import me.hao0.wechat.model.customer.WaitingSession;

public final class CustomerServices
extends Component {
    private static final String CREATE_ACCOUNT = "https://api.weixin.qq.com/customservice/kfaccount/add?access_token=";
    private static final String UPDATE_ACCOUNT = "https://api.weixin.qq.com/customservice/kfaccount/update?access_token=";
    private static final String UPLOAD_HEAD = "https://api.weixin.qq.com/customservice/kfaccount/uploadheadimg?access_token=";
    private static final String DELETE_ACCOUNT = "https://api.weixin.qq.com/customservice/kfaccount/del?access_token=";
    private static final String RECORD = "https://api.weixin.qq.com/customservice/msgrecord/getrecord?access_token=";
    private static final String CREATE_SESSION = "https://api.weixin.qq.com/customservice/kfsession/create?access_token=";
    private static final String CLOSE_SESSION = "https://api.weixin.qq.com/customservice/kfsession/close?access_token=";
    private static final String USER_SESSION_STATUS = "https://api.weixin.qq.com/customservice/kfsession/getsession?access_token=";
    private static final String CS_SESSION_STATUS = "https://api.weixin.qq.com/customservice/kfsession/getsessionlist?access_token=";
    private static final String WAITING_SESSION = "https://api.weixin.qq.com/customservice/kfsession/getwaitcase?access_token=";

    CustomerServices() {
    }

    public Boolean createAccount(String account, String nickName, String password) {
        return this.createAccount(this.loadAccessToken(), account, nickName, password);
    }

    public void createAccount(String account, String nickName, String password, Callback<Boolean> cb) {
        this.createAccount(this.loadAccessToken(), account, nickName, password, cb);
    }

    public void createAccount(final String accessToken, final String account, final String nickName, final String password, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return CustomerServices.this.closeSession(accessToken, account, nickName, password);
            }
        });
    }

    public Boolean createAccount(String accessToken, String account, String nickName, String password) {
        String url = CREATE_ACCOUNT + accessToken;
        return this.createOrUpdateAccount(account, nickName, password, url);
    }

    public Boolean updateAccount(String account, String nickName, String password) {
        return this.updateAccount(this.loadAccessToken(), account, nickName, password);
    }

    public void updateAccount(String account, String nickName, String password, Callback<Boolean> cb) {
        this.updateAccount(this.loadAccessToken(), account, nickName, password, cb);
    }

    public void updateAccount(final String accessToken, final String account, final String nickName, final String password, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return CustomerServices.this.updateAccount(accessToken, account, nickName, password);
            }
        });
    }

    public Boolean updateAccount(String accessToken, String account, String nickName, String password) {
        String url = UPDATE_ACCOUNT + accessToken;
        return this.createOrUpdateAccount(account, nickName, password, url);
    }

    private Boolean createOrUpdateAccount(String account, String nickName, String password, String url) {
        Preconditions.checkNotNullAndEmpty((String)account, (String)"account");
        Preconditions.checkNotNullAndEmpty((String)nickName, (String)"nickName");
        Preconditions.checkNotNullAndEmpty((String)password, (String)"password");
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put("kf_account", account);
        params.put("nickname", nickName);
        params.put("password", Hashing.md5().hashString((CharSequence)password, Charsets.UTF_8).toString());
        this.doPost(url, params);
        return Boolean.TRUE;
    }

    public Boolean uploadHead(String kfAccount, String fileName, byte[] data) {
        return this.uploadHead(this.loadAccessToken(), kfAccount, fileName, new ByteArrayInputStream(data));
    }

    public Boolean uploadHead(String accessToken, String kfAccount, String fileName, byte[] data) {
        return this.uploadHead(accessToken, kfAccount, fileName, new ByteArrayInputStream(data));
    }

    public void uploadHead(String kfAccount, String fileName, byte[] data, Callback<Boolean> cb) {
        this.uploadHead(this.loadAccessToken(), kfAccount, fileName, new ByteArrayInputStream(data), cb);
    }

    public void uploadHead(String accessToken, String kfAccount, String fileName, byte[] data, Callback<Boolean> cb) {
        this.uploadHead(accessToken, kfAccount, fileName, new ByteArrayInputStream(data), cb);
    }

    public Boolean uploadHead(String kfAccount, File image) {
        return this.uploadHead(this.loadAccessToken(), kfAccount, image);
    }

    public Boolean uploadHead(String accessToken, String kfAccount, File image) {
        try {
            return this.uploadHead(accessToken, kfAccount, image.getName(), new FileInputStream(image));
        }
        catch (FileNotFoundException e) {
            throw new WechatException(e);
        }
    }

    public void uploadHead(String accessToken, String kfAccount, File image, Callback<Boolean> cb) {
        try {
            this.uploadHead(accessToken, kfAccount, image.getName(), new FileInputStream(image), cb);
        }
        catch (FileNotFoundException e) {
            throw new WechatException(e);
        }
    }

    public Boolean uploadHead(String kfAccount, String fileName, InputStream input) {
        return this.uploadHead(this.loadAccessToken(), kfAccount, fileName, input);
    }

    public void uploadHead(final String accessToken, final String kfAccount, final String fileName, final InputStream input, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() throws Exception {
                return CustomerServices.this.uploadHead(accessToken, kfAccount, fileName, input);
            }
        });
    }

    public Boolean uploadHead(String accessToken, String kfAccount, String fileName, InputStream input) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)kfAccount, (String)"kfAccount");
        Preconditions.checkNotNullAndEmpty((String)fileName, (String)"fileName");
        Preconditions.checkNotNull((Object)input, (Object)"input can't be null");
        String url = UPLOAD_HEAD + accessToken + "&kf_account=" + kfAccount;
        this.doUpload(url, "media", fileName, input);
        return Boolean.TRUE;
    }

    public void deleteAccount(String kfAccount, Callback<Boolean> cb) {
        this.deleteAccount(this.loadAccessToken(), kfAccount, cb);
    }

    public Boolean deleteAccount(String kfAccount) {
        return this.deleteAccount(this.loadAccessToken(), kfAccount);
    }

    public void deleteAccount(final String accessToken, final String kfAccount, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return CustomerServices.this.deleteAccount(accessToken, kfAccount);
            }
        });
    }

    public Boolean deleteAccount(String accessToken, String kfAccount) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)kfAccount, (String)"kfAccount");
        String url = DELETE_ACCOUNT + accessToken + "&kf_account=" + kfAccount;
        this.doGet(url);
        return Boolean.TRUE;
    }

    public List<MsgRecord> getMsgRecords(Integer pageNo, Integer pageSize, Date startTime, Date endTime) {
        return this.getMsgRecords(this.loadAccessToken(), pageNo, pageSize, startTime, endTime);
    }

    public void getMsgRecords(Integer pageNo, Integer pageSize, Date startTime, Date endTime, Callback<List<MsgRecord>> cb) {
        this.getMsgRecords(this.loadAccessToken(), pageNo, pageSize, startTime, endTime, cb);
    }

    public void getMsgRecords(final String accessToken, final Integer pageNo, final Integer pageSize, final Date startTime, final Date endTime, Callback<List<MsgRecord>> cb) {
        this.doAsync(new AsyncFunction<List<MsgRecord>>(cb){

            @Override
            public List<MsgRecord> execute() {
                return CustomerServices.this.getMsgRecords(accessToken, pageNo, pageSize, startTime, endTime);
            }
        });
    }

    public List<MsgRecord> getMsgRecords(String accessToken, Integer pageNo, Integer pageSize, Date startTime, Date endTime) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        String url = RECORD + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put("pageindex", pageNo == null ? 1 : pageNo);
        params.put("pagesize", pageSize == null ? 10 : pageSize);
        params.put("starttime", startTime == null ? System.currentTimeMillis() : startTime.getTime());
        params.put("endtime", endTime == null ? System.currentTimeMillis() : endTime.getTime());
        Map<String, Object> resp = this.doPost(url, params);
        List records = (List)resp.get("recordlist");
        if (records.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MsgRecord> msgs = new ArrayList<MsgRecord>();
        for (Map record : records) {
            msgs.add(this.renderMsgRecord(record));
        }
        return msgs;
    }

    private MsgRecord renderMsgRecord(Map<String, Object> record) {
        MsgRecord msg = new MsgRecord();
        msg.setOpenid((String)record.get("openid"));
        msg.setOpercode((String)record.get("opercode"));
        msg.setText((String)record.get("text"));
        msg.setTime(new Date((long)((Integer)record.get("time")).intValue() * 1000L));
        msg.setWorker((String)record.get("worker"));
        return msg;
    }

    public Boolean createSession(String openId, String kfAccount, String text) {
        return this.createSession(this.loadAccessToken(), openId, kfAccount, text);
    }

    public void createSession(String openId, String kfAccount, String text, Callback<Boolean> cb) {
        this.createSession(this.loadAccessToken(), openId, kfAccount, text, cb);
    }

    public void createSession(final String accessToken, final String openId, final String kfAccount, final String text, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return CustomerServices.this.createSession(accessToken, openId, kfAccount, text);
            }
        });
    }

    public Boolean createSession(String accessToken, String openId, String kfAccount, String text) {
        return this.createOrCloseSession(openId, kfAccount, text, CREATE_SESSION + accessToken);
    }

    public Boolean closeSession(String openId, String kfAccount, String text) {
        return this.closeSession(this.loadAccessToken(), openId, kfAccount, text);
    }

    public void closeSession(String openId, String kfAccount, String text, Callback<Boolean> cb) {
        this.closeSession(this.loadAccessToken(), openId, kfAccount, text, cb);
    }

    public void closeSession(final String accessToken, final String openId, final String kfAccount, final String text, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return CustomerServices.this.closeSession(accessToken, openId, kfAccount, text);
            }
        });
    }

    public Boolean closeSession(String accessToken, String openId, String kfAccount, String text) {
        return this.createOrCloseSession(openId, kfAccount, text, CLOSE_SESSION + accessToken);
    }

    private Boolean createOrCloseSession(String openId, String kfAccount, String text, String url) {
        Preconditions.checkNotNullAndEmpty((String)openId, (String)"openId");
        Preconditions.checkNotNullAndEmpty((String)kfAccount, (String)"kfAccount");
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put("openid", openId);
        params.put("kf_account", kfAccount);
        params.put("text", text);
        this.doPost(url, params);
        return Boolean.TRUE;
    }

    public UserSession getUserSession(String openId) {
        return this.getUserSession(this.loadAccessToken(), openId);
    }

    public void getUserSession(final String accessToken, final String openId, Callback<UserSession> cb) {
        this.doAsync(new AsyncFunction<UserSession>(cb){

            @Override
            public UserSession execute() {
                return CustomerServices.this.getUserSession(accessToken, openId);
            }
        });
    }

    public void getUserSession(String openId, Callback<UserSession> cb) {
        this.getUserSession(this.loadAccessToken(), openId, cb);
    }

    public UserSession getUserSession(String accessToken, String openId) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)openId, (String)"openId");
        String url = USER_SESSION_STATUS + accessToken + "&openid=" + openId;
        Map<String, Object> resp = this.doGet(url);
        UserSession status = new UserSession();
        status.setKfAccount(String.valueOf(resp.get("kf_account")));
        status.setCreateTime(new Date((long)((Integer)resp.get("createtime")).intValue() * 1000L));
        return status;
    }

    public List<CsSession> getCsSessions(String kfAccount) {
        return this.getCsSessions(this.loadAccessToken(), kfAccount);
    }

    public void getCsSessions(String kfAccount, Callback<List<CsSession>> cb) {
        this.getCsSessions(this.loadAccessToken(), kfAccount, cb);
    }

    public void getCsSessions(final String accessToken, final String kfAccount, Callback<List<CsSession>> cb) {
        this.doAsync(new AsyncFunction<List<CsSession>>(cb){

            @Override
            public List<CsSession> execute() {
                return CustomerServices.this.getCsSessions(accessToken, kfAccount);
            }
        });
    }

    public List<CsSession> getCsSessions(String accessToken, String kfAccount) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)kfAccount, (String)"kfAccount");
        String url = CS_SESSION_STATUS + accessToken + "&kf_account=" + kfAccount;
        Map<String, Object> resp = this.doGet(url);
        List sessions = (List)resp.get("sessionlist");
        if (sessions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CsSession> ss = new ArrayList<CsSession>();
        for (Map session : sessions) {
            ss.add(this.renderCsSession(session));
        }
        return ss;
    }

    private CsSession renderCsSession(Map<String, Object> session) {
        CsSession s = new CsSession();
        s.setOpenId((String)session.get("openid"));
        s.setCreateTime(new Date((long)((Integer)session.get("createtime")).intValue() * 1000L));
        return s;
    }

    public List<WaitingSession> getWaitingSessions() {
        return this.getWaitingSessions(this.loadAccessToken());
    }

    public void getWaitingSessions(Callback<List<WaitingSession>> cb) {
        this.getWaitingSessions(this.loadAccessToken(), cb);
    }

    public void getWaitingSessions(final String accessToken, Callback<List<WaitingSession>> cb) {
        this.doAsync(new AsyncFunction<List<WaitingSession>>(cb){

            @Override
            public List<WaitingSession> execute() {
                return CustomerServices.this.getWaitingSessions(accessToken);
            }
        });
    }

    public List<WaitingSession> getWaitingSessions(String accessToken) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        String url = WAITING_SESSION + accessToken;
        Map<String, Object> resp = this.doGet(url);
        List sessions = (List)resp.get("waitcaselist");
        if (sessions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<WaitingSession> ss = new ArrayList<WaitingSession>();
        for (Map session : sessions) {
            ss.add(this.renderWaitingSession(session));
        }
        return ss;
    }

    private WaitingSession renderWaitingSession(Map<String, Object> session) {
        WaitingSession s = new WaitingSession();
        s.setOpenId((String)session.get("openid"));
        s.setKfAccount((String)session.get("kf_account"));
        s.setCreateTime(new Date((long)((Integer)session.get("createtime")).intValue() * 1000L));
        return s;
    }
}

