/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483648)
public class ParameterDataTypeReader
implements ParameterBuilderPlugin {
    private final TypeNameExtractor nameExtractor;
    private final TypeResolver resolver;

    @Autowired
    public ParameterDataTypeReader(TypeNameExtractor nameExtractor, TypeResolver resolver) {
        this.nameExtractor = nameExtractor;
        this.resolver = resolver;
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ParameterContext context) {
        ResolvedMethodParameter methodParameter = context.resolvedMethodParameter();
        ResolvedType parameterType = methodParameter.getResolvedParameterType();
        parameterType = context.alternateFor(parameterType);
        Annotation[] methodAnnotations = methodParameter.getMethodParameter().getParameterAnnotations();
        ModelRef modelRef = null;
        for (Annotation annotation : methodAnnotations) {
            if (annotation instanceof PathVariable && this.treatAsAString(parameterType)) {
                parameterType = this.resolver.resolve(String.class, new Type[0]);
                modelRef = new ModelRef("string");
                continue;
            }
            if (annotation instanceof RequestParam && Maps.isMapType((ResolvedType)parameterType)) {
                modelRef = new ModelRef("", (ModelReference)new ModelRef("string"), true);
                continue;
            }
            if (!(annotation instanceof RequestParam) || !this.treatRequestParamAsString(parameterType)) continue;
            parameterType = this.resolver.resolve(String.class, new Type[0]);
            modelRef = new ModelRef("string");
        }
        ModelContext modelContext = ModelContext.inputParam((Type)parameterType, (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getGenericNamingStrategy(), (ImmutableSet)context.getIgnorableParameterTypes());
        context.parameterBuilder().type(parameterType).modelRef((ModelReference)Optional.fromNullable(modelRef).or(ResolvedTypes.modelRefFactory((ModelContext)modelContext, (TypeNameExtractor)this.nameExtractor).apply((Object)parameterType)));
    }

    private boolean treatRequestParamAsString(ResolvedType parameterType) {
        return this.treatAsAString(parameterType) && !Collections.isContainerType((ResolvedType)parameterType) || Collections.isContainerType((ResolvedType)parameterType) && this.treatAsAString(Collections.collectionElementType((ResolvedType)parameterType));
    }

    private boolean treatAsAString(ResolvedType parameterType) {
        return !Types.isBaseType((String)Types.typeNameFor((Type)parameterType.getErasedType())) && !parameterType.getErasedType().isEnum();
    }
}

