/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public class GenericMapOutput<K, V>
extends CommandOutput<K, V, Map<K, Object>> {
    private K key;

    public GenericMapOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.key == null) {
            this.key = bytes == null ? null : this.codec.decodeKey(bytes);
            return;
        }
        Object value = bytes == null ? null : (Object)this.codec.decodeValue(bytes);
        ((Map)this.output).put(this.key, value);
        this.key = null;
    }

    @Override
    public void setBigNumber(ByteBuffer bytes) {
        this.set(bytes);
    }

    @Override
    public void set(long integer) {
        if (this.key == null) {
            this.key = integer;
            return;
        }
        Long value = integer;
        ((Map)this.output).put(this.key, value);
        this.key = null;
    }

    @Override
    public void set(double number) {
        if (this.key == null) {
            this.key = number;
            return;
        }
        Double value = number;
        ((Map)this.output).put(this.key, value);
        this.key = null;
    }

    @Override
    public void multi(int count) {
        if (this.output == null) {
            this.output = new LinkedHashMap(count / 2, 1.0f);
        }
    }
}

