/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.models.partitions;

import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Partitions
implements Collection<RedisClusterNode> {
    private static final RedisClusterNode[] EMPTY = new RedisClusterNode[16384];
    private final List<RedisClusterNode> partitions = new ArrayList<RedisClusterNode>();
    private volatile RedisClusterNode[] slotCache = EMPTY;
    private volatile Collection<RedisClusterNode> nodeReadView = Collections.emptyList();

    public Partitions clone() {
        ArrayList<RedisClusterNode> readView = new ArrayList<RedisClusterNode>(this.nodeReadView);
        Partitions copy = new Partitions();
        for (RedisClusterNode node : readView) {
            copy.addPartition(node.clone());
        }
        copy.updateCache();
        return copy;
    }

    public RedisClusterNode getPartitionBySlot(int slot) {
        return this.slotCache[slot];
    }

    public RedisClusterNode getPartitionByNodeId(String nodeId) {
        for (RedisClusterNode partition : this.nodeReadView) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return partition;
        }
        return null;
    }

    public RedisClusterNode getPartition(String host, int port) {
        for (RedisClusterNode partition : this.nodeReadView) {
            RedisURI uri = partition.getUri();
            if (Partitions.matches(uri, host, port)) {
                return partition;
            }
            for (RedisURI redisURI : partition.getAliases()) {
                if (!Partitions.matches(redisURI, host, port)) continue;
                return partition;
            }
        }
        return null;
    }

    private static boolean matches(RedisURI uri, String host, int port) {
        return uri.getPort() == port && host.equals(uri.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCache() {
        List<RedisClusterNode> list = this.partitions;
        synchronized (list) {
            if (this.partitions.isEmpty()) {
                this.slotCache = EMPTY;
                this.nodeReadView = Collections.emptyList();
                return;
            }
            RedisClusterNode[] slotCache = new RedisClusterNode[16384];
            ArrayList<RedisClusterNode> readView = new ArrayList<RedisClusterNode>(this.partitions.size());
            for (RedisClusterNode partition : this.partitions) {
                readView.add(partition);
                partition.forEachSlot(i -> {
                    slotCache[i] = partition;
                });
            }
            this.slotCache = slotCache;
            this.nodeReadView = Collections.unmodifiableCollection(readView);
        }
    }

    @Override
    public Iterator<RedisClusterNode> iterator() {
        return this.nodeReadView.iterator();
    }

    public List<RedisClusterNode> getPartitions() {
        return this.partitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartition(RedisClusterNode partition) {
        LettuceAssert.notNull((Object)partition, "Partition must not be null");
        List<RedisClusterNode> list = this.partitions;
        synchronized (list) {
            this.slotCache = EMPTY;
            this.partitions.add(partition);
        }
    }

    @Override
    public int size() {
        return this.nodeReadView.size();
    }

    public RedisClusterNode getPartition(int index) {
        return this.partitions.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(List<RedisClusterNode> partitions) {
        LettuceAssert.noNullElements(partitions, "Partitions must not contain null elements");
        List<RedisClusterNode> list = this.partitions;
        synchronized (list) {
            this.partitions.clear();
            this.partitions.addAll(partitions);
            this.updateCache();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.nodeReadView.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.nodeReadView.contains(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends RedisClusterNode> c) {
        LettuceAssert.noNullElements(c, "Partitions must not contain null elements");
        List<RedisClusterNode> list = this.partitions;
        synchronized (list) {
            boolean b = this.partitions.addAll(c);
            this.updateCache();
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        List<RedisClusterNode> list = this.partitions;
        synchronized (list) {
            boolean b = this.getPartitions().removeAll(c);
            this.updateCache();
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        List<RedisClusterNode> list = this.partitions;
        synchronized (list) {
            boolean b = this.getPartitions().retainAll(c);
            this.updateCache();
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<RedisClusterNode> list = this.partitions;
        synchronized (list) {
            this.getPartitions().clear();
            this.updateCache();
        }
    }

    @Override
    public Object[] toArray() {
        return this.nodeReadView.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.nodeReadView.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(RedisClusterNode redisClusterNode) {
        List<RedisClusterNode> list = this.partitions;
        synchronized (list) {
            LettuceAssert.notNull((Object)redisClusterNode, "RedisClusterNode must not be null");
            boolean add = this.getPartitions().add(redisClusterNode);
            this.updateCache();
            return add;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        List<RedisClusterNode> list = this.partitions;
        synchronized (list) {
            boolean remove = this.getPartitions().remove(o);
            this.updateCache();
            return remove;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.nodeReadView.containsAll(c);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" ").append(this.partitions);
        return sb.toString();
    }
}

