/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.masterslave.MasterSlaveUtils;
import io.lettuce.core.masterslave.Requests;
import io.lettuce.core.masterslave.TimedAsyncCommand;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import java.util.Map;
import java.util.TreeMap;

class Connections {
    private final Map<RedisURI, StatefulRedisConnection<String, String>> connections = new TreeMap<RedisURI, StatefulRedisConnection<String, String>>(MasterSlaveUtils.RedisURIComparator.INSTANCE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(RedisURI redisURI, StatefulRedisConnection<String, String> connection) {
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            this.connections.put(redisURI, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            return this.connections.isEmpty();
        }
    }

    public Requests requestPing() {
        Requests requests = new Requests();
        for (Map.Entry<RedisURI, StatefulRedisConnection<String, String>> entry : this.connections.entrySet()) {
            CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.ASCII).add(CommandKeyword.NODES);
            Command command = new Command(CommandType.PING, new StatusOutput<String, String>(StringCodec.ASCII), args);
            TimedAsyncCommand<String, String, String> timedCommand = new TimedAsyncCommand<String, String, String>(command);
            entry.getValue().dispatch(timedCommand);
            requests.addRequest(entry.getKey(), timedCommand);
        }
        return requests;
    }

    public void close() {
        for (StatefulRedisConnection<String, String> connection : this.connections.values()) {
            connection.close();
        }
    }
}

