/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class LombokUtils {
    public static final String LOMBOK_INTERN_FIELD_MARKER = "$";
    public static final Pattern NON_NULL_PATTERN = Pattern.compile("^(?:nonnull)$", 2);
    public static final Pattern NULLABLE_PATTERN = Pattern.compile("^(?:nullable|checkfornull)$", 2);

    public static String toGetterName(CharSequence charSequence, boolean bl) {
        String string;
        String string2 = string = bl ? "is" : "get";
        if (charSequence.length() == 0) {
            return string;
        }
        if (bl && ((Object)charSequence).toString().startsWith("is") && charSequence.length() > 2 && !Character.isLowerCase(charSequence.charAt(2))) {
            return ((Object)charSequence).toString();
        }
        return LombokUtils.buildName(string, ((Object)charSequence).toString());
    }

    public static String toSetterName(CharSequence charSequence, boolean bl) {
        if (charSequence.length() == 0) {
            return "set";
        }
        if (bl && ((Object)charSequence).toString().startsWith("is") && charSequence.length() > 2 && !Character.isLowerCase(charSequence.charAt(2))) {
            return "set" + ((Object)charSequence).toString().substring(2);
        }
        return LombokUtils.buildName("set", ((Object)charSequence).toString());
    }

    private static String buildName(String string, String string2) {
        if (string2.length() == 0) {
            return string;
        }
        char c = string2.charAt(0);
        if (Character.isLowerCase(c)) {
            boolean bl = string2.length() > 2 && (Character.isTitleCase(string2.charAt(1)) || Character.isUpperCase(string2.charAt(1)));
            string2 = String.format("%s%s", Character.valueOf(bl ? Character.toUpperCase(c) : Character.toTitleCase(c)), string2.subSequence(1, string2.length()));
        }
        return String.format("%s%s", string, string2);
    }

    public static List<String> toAllGetterNames(CharSequence charSequence, boolean bl) {
        if (!bl) {
            return Collections.singletonList(LombokUtils.toGetterName(charSequence, false));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(((Object)charSequence).toString());
        if (((Object)charSequence).toString().startsWith("is") && charSequence.length() > 2 && !Character.isLowerCase(charSequence.charAt(2))) {
            arrayList.add(((Object)charSequence).toString().substring(2));
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : arrayList) {
            if (string.length() > 0 && Character.isLowerCase(string.charAt(0))) {
                string = Character.toTitleCase(string.charAt(0)) + string.substring(1);
            }
            hashSet.add("is" + string);
            hashSet.add("get" + string);
        }
        return new ArrayList<String>(hashSet);
    }

    public static List<String> toAllSetterNames(CharSequence charSequence, boolean bl) {
        if (!bl) {
            return Collections.singletonList(LombokUtils.toSetterName(charSequence, false));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(((Object)charSequence).toString());
        if (((Object)charSequence).toString().startsWith("is") && charSequence.length() > 2 && !Character.isLowerCase(charSequence.charAt(2))) {
            arrayList.add(((Object)charSequence).toString().substring(2));
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : arrayList) {
            if (string.length() > 0 && Character.isLowerCase(string.charAt(0))) {
                string = Character.toTitleCase(string.charAt(0)) + string.substring(1);
            }
            hashSet.add("set" + string);
        }
        return new ArrayList<String>(hashSet);
    }
}

