/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.util;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.BuildNumber;
import de.plushnikov.intellij.lombok.util.IntelliJVersionRangeUtil;
import de.plushnikov.intellij.lombok.util.PsiPrimitiveTypeUtil;
import de.plushnikov.intellij.lombok.util.PsiPrimitiveTypeUtil10Impl;
import de.plushnikov.intellij.lombok.util.PsiPrimitiveTypeUtil11Impl;
import de.plushnikov.intellij.lombok.util.PsiPrimitiveTypeUtil9Impl;

public class PsiPrimitiveTypeFactory {
    private static PsiPrimitiveTypeUtil ourInstance;

    private PsiPrimitiveTypeFactory() {
    }

    public static PsiPrimitiveTypeUtil getInstance() {
        if (null == ourInstance) {
            ourInstance = PsiPrimitiveTypeFactory.createUtil();
        }
        return ourInstance;
    }

    private static PsiPrimitiveTypeUtil createUtil() {
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        switch (IntelliJVersionRangeUtil.getIntelliJVersion(buildNumber)) {
            case INTELLIJ_8: {
                throw new RuntimeException(String.format("This version (%s) of IntelliJ is not supported!", buildNumber.asString()));
            }
            case INTELLIJ_9: {
                return new PsiPrimitiveTypeUtil9Impl();
            }
            case INTELLIJ_10: 
            case INTELLIJ_10_5: {
                return new PsiPrimitiveTypeUtil10Impl();
            }
        }
        return new PsiPrimitiveTypeUtil11Impl();
    }
}

