/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import de.plushnikov.intellij.lombok.psi.LombokLightMethod;
import de.plushnikov.intellij.lombok.psi.LombokPsiElementFactory;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiMethodUtil {
    @NotNull
    public static PsiMethod createMethod(@NotNull PsiClass psiClass, @NotNull String string, @NotNull PsiElement psiElement) {
        PsiManager psiManager = psiClass.getContainingFile().getManager();
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
        PsiMethod psiMethod = psiElementFactory.createMethodFromText(string, (PsiElement)psiClass);
        LombokLightMethod lombokLightMethod = LombokPsiElementFactory.getInstance().createLightMethod(psiManager, psiMethod, psiClass);
        lombokLightMethod.withNavigationElement(psiElement);
        return lombokLightMethod;
    }

    public static boolean hasMethodByName(@NotNull PsiMethod[] psiMethodArray, @NotNull String string) {
        boolean bl = false;
        for (PsiMethod psiMethod : psiMethodArray) {
            if (!psiMethod.getName().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean hasMethodByName(@NotNull PsiMethod[] psiMethodArray, String ... stringArray) {
        boolean bl = false;
        for (String string : stringArray) {
            if (!PsiMethodUtil.hasMethodByName(psiMethodArray, string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean hasMethodByName(@NotNull PsiMethod[] psiMethodArray, @NotNull Collection<String> collection) {
        boolean bl = false;
        for (String string : collection) {
            if (!PsiMethodUtil.hasMethodByName(psiMethodArray, string)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

