/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.util;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import de.plushnikov.intellij.lombok.util.PsiPrimitiveTypeFactory;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementUtil {
    public static boolean methodMatches(@NotNull PsiMethod psiMethod, @NonNls @Nullable String string, @Nullable PsiType psiType, @NonNls @Nullable String string2, @Nullable List<PsiType> list) {
        PsiParameterList psiParameterList;
        String string3 = psiMethod.getName();
        if (string2 != null && !string2.equals(string3)) {
            return false;
        }
        if (list != null) {
            psiParameterList = psiMethod.getParameterList();
            if (psiParameterList.getParametersCount() != list.size()) {
                return false;
            }
            PsiType psiType2 = PsiPrimitiveTypeFactory.getInstance().getNullType();
            PsiParameter[] psiParameterArray = psiParameterList.getParameters();
            for (int i = 0; i < psiParameterArray.length; ++i) {
                PsiParameter psiParameter = psiParameterArray[i];
                PsiType psiType3 = psiParameter.getType();
                PsiType psiType4 = list.get(i);
                if (psiType2.equals(psiType4) || psiType4 == null || PsiElementUtil.typesAreEquivalent(psiType3, psiType4)) continue;
                return false;
            }
        }
        if (psiType != null && !PsiElementUtil.typesAreEquivalent(psiType, (PsiType)(psiParameterList = psiMethod.getReturnType()))) {
            return false;
        }
        if (string != null) {
            psiParameterList = psiMethod.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)psiParameterList, (String)string);
        }
        return true;
    }

    public static boolean methodMatches(@NotNull PsiMethod psiMethod, @Nullable PsiType psiType, @NonNls @Nullable String string, @Nullable PsiParameterList psiParameterList) {
        PsiParameterList psiParameterList2;
        String string2 = psiMethod.getName();
        if (string != null && !string.equals(string2)) {
            return false;
        }
        if (psiParameterList != null) {
            psiParameterList2 = psiMethod.getParameterList();
            if (psiParameterList2.getParametersCount() != psiParameterList.getParametersCount()) {
                return false;
            }
            PsiParameter[] psiParameterArray = psiParameterList2.getParameters();
            PsiParameter[] psiParameterArray2 = psiParameterList.getParameters();
            PsiType psiType2 = PsiPrimitiveTypeFactory.getInstance().getNullType();
            for (int i = 0; i < psiParameterArray.length; ++i) {
                PsiType psiType3 = psiParameterArray[i].getType();
                PsiType psiType4 = psiParameterArray2[i].getType();
                if (psiType2.equals(psiType4) || PsiElementUtil.typesAreEquivalent(psiType3, psiType4)) continue;
                return false;
            }
        }
        return psiType == null || PsiElementUtil.typesAreEquivalent(psiType, (PsiType)(psiParameterList2 = psiMethod.getReturnType()));
    }

    public static boolean typesAreEquivalent(@Nullable PsiType psiType, @Nullable PsiType psiType2) {
        if (psiType == null) {
            return psiType2 == null;
        }
        if (psiType2 == null) {
            return false;
        }
        String string = psiType.getCanonicalText();
        String string2 = psiType2.getCanonicalText();
        return string.equals(string2);
    }

    public static boolean methodMatches(@NotNull Pair<PsiMethod, PsiSubstitutor> pair, @NotNull Pair<PsiMethod, PsiSubstitutor> pair2) {
        PsiMethod psiMethod = (PsiMethod)pair.getFirst();
        PsiMethod psiMethod2 = (PsiMethod)pair2.getFirst();
        if (!psiMethod.getName().equals(psiMethod2.getName())) {
            return false;
        }
        PsiParameterList psiParameterList = psiMethod.getParameterList();
        PsiParameterList psiParameterList2 = psiMethod2.getParameterList();
        if (psiParameterList.getParametersCount() != psiParameterList2.getParametersCount()) {
            return false;
        }
        PsiParameter[] psiParameterArray = psiParameterList.getParameters();
        PsiParameter[] psiParameterArray2 = psiParameterList2.getParameters();
        PsiSubstitutor psiSubstitutor = (PsiSubstitutor)pair.getSecond();
        PsiSubstitutor psiSubstitutor2 = (PsiSubstitutor)pair2.getSecond();
        PsiType psiType = PsiPrimitiveTypeFactory.getInstance().getNullType();
        for (int i = 0; i < psiParameterArray.length; ++i) {
            PsiType psiType2 = psiSubstitutor.substitute(psiParameterArray[i].getType());
            PsiType psiType3 = psiSubstitutor2.substitute(psiParameterArray2[i].getType());
            if (psiType.equals(psiType2) || PsiElementUtil.typesAreEquivalent(psiType2, psiType3)) continue;
            return false;
        }
        return true;
    }
}

