/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class PsiClassUtil {
    @NotNull
    public static PsiMethod[] collectClassMethodsIntern(@NotNull PsiClass psiClass) {
        ArrayList<PsiMethod> arrayList = new ArrayList<PsiMethod>();
        for (PsiElement psiElement : psiClass.getChildren()) {
            if (!(psiElement instanceof PsiMethod)) continue;
            arrayList.add((PsiMethod)psiElement);
        }
        return arrayList.toArray(new PsiMethod[arrayList.size()]);
    }

    @NotNull
    public static PsiMethod[] collectClassConstructorIntern(@NotNull PsiClass psiClass) {
        PsiMethod[] psiMethodArray = PsiClassUtil.collectClassMethodsIntern(psiClass);
        ArrayList<PsiMethod> arrayList = new ArrayList<PsiMethod>(3);
        for (PsiMethod psiMethod : psiMethodArray) {
            if (!psiMethod.isConstructor()) continue;
            arrayList.add(psiMethod);
        }
        return arrayList.toArray(new PsiMethod[arrayList.size()]);
    }

    @NotNull
    public static PsiMethod[] collectClassStaticMethodsIntern(@NotNull PsiClass psiClass) {
        PsiMethod[] psiMethodArray = PsiClassUtil.collectClassMethodsIntern(psiClass);
        ArrayList<PsiMethod> arrayList = new ArrayList<PsiMethod>(5);
        for (PsiMethod psiMethod : psiMethodArray) {
            if (!psiMethod.hasModifierProperty("static")) continue;
            arrayList.add(psiMethod);
        }
        return arrayList.toArray(new PsiMethod[arrayList.size()]);
    }

    @NotNull
    public static PsiField[] collectClassFieldsIntern(@NotNull PsiClass psiClass) {
        ArrayList<PsiField> arrayList = new ArrayList<PsiField>();
        for (PsiElement psiElement : psiClass.getChildren()) {
            if (!(psiElement instanceof PsiField)) continue;
            arrayList.add((PsiField)psiElement);
        }
        return arrayList.toArray(new PsiField[arrayList.size()]);
    }

    public static PsiClassType getClassType(@NotNull PsiClass psiClass) {
        return JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass);
    }

    public static boolean hasSuperClass(@Nonnull PsiClass psiClass) {
        PsiClass psiClass2 = psiClass.getSuperClass();
        return null != psiClass2 && !"java.lang.Object".equals(psiClass2.getQualifiedName());
    }

    public static boolean hasMultiArgumentConstructor(@Nonnull PsiClass psiClass) {
        PsiMethod[] psiMethodArray;
        boolean bl = false;
        for (PsiMethod psiMethod : psiMethodArray = PsiClassUtil.collectClassConstructorIntern(psiClass)) {
            if (psiMethod.getParameterList().getParametersCount() <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

