/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAnnotationUtil {
    public static boolean isNotAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, Class<? extends Annotation> ... classArray) {
        return !PsiAnnotationUtil.isAnnotatedWith(psiModifierListOwner, classArray);
    }

    public static boolean isNotAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull Class<? extends Annotation> clazz) {
        return !PsiAnnotationUtil.isAnnotatedWith(psiModifierListOwner, clazz);
    }

    public static boolean isAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, Class<? extends Annotation> ... psiModifierList) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Class<? extends Annotation> clazz : psiModifierList) {
            hashSet.add(clazz.getName());
        }
        PsiModifierList psiModifierList2 = psiModifierListOwner.getModifierList();
        if (psiModifierList2 != null) {
            for (PsiAnnotation psiAnnotation : psiModifierList2.getAnnotations()) {
                if (!hashSet.contains(psiAnnotation.getQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull Class<? extends Annotation> clazz) {
        PsiModifierList psiModifierList = psiModifierListOwner.getModifierList();
        if (psiModifierList != null) {
            for (PsiAnnotation psiAnnotation : psiModifierList.getAnnotations()) {
                if (!clazz.getName().equals(psiAnnotation.getQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull Pattern pattern) {
        PsiModifierList psiModifierList = psiModifierListOwner.getModifierList();
        if (psiModifierList != null) {
            for (PsiAnnotation psiAnnotation : psiModifierList.getAnnotations()) {
                String string = PsiAnnotationUtil.getSimpleNameOf(psiAnnotation);
                if (!pattern.matcher(string).matches()) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getSimpleNameOf(@NotNull PsiAnnotation psiAnnotation) {
        return ClassUtil.extractClassName((String)StringUtil.notNullize((String)psiAnnotation.getQualifiedName()));
    }

    @NotNull
    public static List<PsiAnnotation> findAnnotations(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull Pattern pattern) {
        ArrayList<PsiAnnotation> arrayList = new ArrayList<PsiAnnotation>();
        PsiModifierList psiModifierList = psiModifierListOwner.getModifierList();
        if (psiModifierList != null) {
            for (PsiAnnotation psiAnnotation : psiModifierList.getAnnotations()) {
                String string = PsiAnnotationUtil.getSimpleNameOf(psiAnnotation);
                if (!pattern.matcher(string).matches()) continue;
                arrayList.add(psiAnnotation);
            }
        }
        return arrayList;
    }

    @Nullable
    public static <T> T getAnnotationValue(@NotNull PsiAnnotation psiAnnotation, Class<T> clazz) {
        return PsiAnnotationUtil.getAnnotationValue(psiAnnotation, "value", clazz);
    }

    @NotNull
    public static <T> Collection<T> getAnnotationValues(@NotNull PsiAnnotation psiAnnotation, @NotNull String string, @NotNull Class<T> clazz) {
        T t;
        List list = Collections.emptyList();
        PsiAnnotationMemberValue psiAnnotationMemberValue = psiAnnotation.findAttributeValue(string);
        if (psiAnnotationMemberValue instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = ((PsiArrayInitializerMemberValue)psiAnnotationMemberValue).getInitializers();
            list = new ArrayList(psiAnnotationMemberValueArray.length);
            for (PsiAnnotationMemberValue psiAnnotationMemberValue2 : psiAnnotationMemberValueArray) {
                T t2 = PsiAnnotationUtil.resolveElementValue((PsiElement)psiAnnotationMemberValue2, clazz);
                if (null == t2) continue;
                list.add(t2);
            }
        } else if (null != psiAnnotationMemberValue && null != (t = PsiAnnotationUtil.resolveElementValue((PsiElement)psiAnnotationMemberValue, clazz))) {
            list = Collections.singletonList(t);
        }
        return list;
    }

    @Nullable
    public static <T> T getAnnotationValue(@NotNull PsiAnnotation psiAnnotation, @NotNull String string, @NotNull Class<T> clazz) {
        T t = null;
        PsiAnnotationMemberValue psiAnnotationMemberValue = psiAnnotation.findAttributeValue(string);
        if (null != psiAnnotationMemberValue) {
            t = PsiAnnotationUtil.resolveElementValue((PsiElement)psiAnnotationMemberValue, clazz);
        }
        return t;
    }

    @Nullable
    private static <T> T resolveElementValue(@NotNull PsiElement psiElement, @NotNull Class<T> clazz) {
        Object object = null;
        if (psiElement instanceof PsiReferenceExpression) {
            PsiVariable psiVariable;
            Object object2;
            PsiElement psiElement2 = ((PsiReferenceExpression)psiElement).resolve();
            if (psiElement2 instanceof PsiEnumConstant) {
                PsiEnumConstant psiEnumConstant = (PsiEnumConstant)psiElement2;
                if (clazz.isAssignableFrom(String.class)) {
                    object = psiEnumConstant.getName();
                }
            } else if (psiElement2 instanceof PsiVariable && null != (object2 = (psiVariable = (PsiVariable)psiElement2).computeConstantValue()) && clazz.isAssignableFrom(object2.getClass())) {
                object = object2;
            }
        } else if (psiElement instanceof PsiLiteralExpression) {
            Object object3 = ((PsiLiteralExpression)psiElement).getValue();
            if (null != object3 && clazz.isAssignableFrom(object3.getClass())) {
                object = object3;
            }
        } else if (psiElement instanceof PsiClassObjectAccessExpression) {
            PsiTypeElement psiTypeElement = ((PsiClassObjectAccessExpression)psiElement).getOperand();
            if (clazz.isAssignableFrom(PsiType.class)) {
                object = psiTypeElement.getType();
            }
        }
        return (T)object;
    }

    @Nullable
    public static <T> T getDeclaredAnnotationValue(@NotNull PsiAnnotation psiAnnotation, @NotNull String string, @NotNull Class<T> clazz) {
        T t = null;
        PsiAnnotationMemberValue psiAnnotationMemberValue = psiAnnotation.findDeclaredAttributeValue(string);
        if (null != psiAnnotationMemberValue) {
            t = PsiAnnotationUtil.resolveElementValue((PsiElement)psiAnnotationMemberValue, clazz);
        }
        return t;
    }

    @NotNull
    public static Collection<String> collectAnnotationsToCopy(@NotNull PsiField psiField, Pattern ... patternArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PsiModifierList psiModifierList = psiField.getModifierList();
        if (null != psiModifierList) {
            for (PsiAnnotation psiAnnotation : psiModifierList.getAnnotations()) {
                String string = PsiAnnotationUtil.getSimpleNameOf(psiAnnotation);
                for (Pattern pattern : patternArray) {
                    if (!pattern.matcher(string).matches()) continue;
                    arrayList.add(psiAnnotation.getQualifiedName());
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String buildAnnotationsString(@NotNull Collection<String> collection) {
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            for (String string : collection) {
                stringBuilder.append('@').append(string).append(' ');
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }
}

