/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.util;

import com.intellij.psi.PsiAnnotation;
import de.plushnikov.intellij.lombok.util.PsiAnnotationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokProcessorUtil {
    @Nullable
    public static String getMethodModifier(@NotNull PsiAnnotation psiAnnotation) {
        return LombokProcessorUtil.convertAccessLevelToJavaModifier(LombokProcessorUtil.getAnnotationValue(psiAnnotation, "value"));
    }

    @Nullable
    public static String getAccessVisibity(@NotNull PsiAnnotation psiAnnotation) {
        return LombokProcessorUtil.convertAccessLevelToJavaString(LombokProcessorUtil.getAnnotationValue(psiAnnotation, "access"));
    }

    private static String getAnnotationValue(PsiAnnotation psiAnnotation, String string) {
        return PsiAnnotationUtil.getAnnotationValue(psiAnnotation, string, String.class);
    }

    @Nullable
    public static String convertAccessLevelToJavaString(String string) {
        if (null == string || string.isEmpty() || string.equals("PUBLIC")) {
            return "public";
        }
        if (string.equals("MODULE")) {
            return "";
        }
        if (string.equals("PROTECTED")) {
            return "protected";
        }
        if (string.equals("PACKAGE")) {
            return "";
        }
        if (string.equals("PRIVATE")) {
            return "private";
        }
        if (string.equals("NONE")) {
            return null;
        }
        return null;
    }

    @Nullable
    private static String convertAccessLevelToJavaModifier(String string) {
        if (null == string || string.isEmpty() || string.equals("PUBLIC")) {
            return "public";
        }
        if (string.equals("MODULE")) {
            return "packageLocal";
        }
        if (string.equals("PROTECTED")) {
            return "protected";
        }
        if (string.equals("PACKAGE")) {
            return "packageLocal";
        }
        if (string.equals("PRIVATE")) {
            return "private";
        }
        if (string.equals("NONE")) {
            return null;
        }
        return null;
    }
}

