/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ModifierFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.lombok.quickfix.ChangeAnnotationParameterQuickFix;
import de.plushnikov.intellij.lombok.quickfix.CreateFieldQuickFix;
import de.plushnikov.intellij.lombok.quickfix.LombokAnnotationQuickFix10Impl;
import de.plushnikov.intellij.lombok.quickfix.LombokAnnotationQuickFix11Impl;
import de.plushnikov.intellij.lombok.quickfix.LombokAnnotationQuickFix9Impl;
import de.plushnikov.intellij.lombok.util.IntelliJVersionRangeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiQuickFixFactory {
    public static LocalQuickFix createAddAnnotationQuickFix(@NotNull PsiClass psiClass, @NotNull String string, @Nullable String string2) {
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
        PsiAnnotation psiAnnotation = psiElementFactory.createAnnotationFromText("@" + string + "(" + StringUtil.notNullize((String)string2) + ")", (PsiElement)psiClass);
        PsiNameValuePair[] psiNameValuePairArray = psiAnnotation.getParameterList().getAttributes();
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        switch (IntelliJVersionRangeUtil.getIntelliJVersion(buildNumber)) {
            case INTELLIJ_8: {
                throw new RuntimeException(String.format("This version (%s) of IntelliJ is not supported!", buildNumber.asString()));
            }
            case INTELLIJ_9: {
                return new LombokAnnotationQuickFix9Impl(string, (PsiModifierListOwner)psiClass, psiNameValuePairArray, new String[0]);
            }
            case INTELLIJ_10: 
            case INTELLIJ_10_5: {
                return new LombokAnnotationQuickFix10Impl(string, (PsiModifierListOwner)psiClass, psiNameValuePairArray, new String[0]);
            }
        }
        return new LombokAnnotationQuickFix11Impl(string, (PsiModifierListOwner)psiClass, psiNameValuePairArray, new String[0]);
    }

    public static LocalQuickFix createModifierListFix(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull String string, boolean bl, boolean bl2) {
        return new ModifierFix(psiModifierListOwner, string, bl, bl2);
    }

    public static LocalQuickFix createNewFieldFix(@NotNull PsiClass psiClass, @NotNull String string, @NotNull PsiType psiType, @Nullable String string2, String ... stringArray) {
        return new CreateFieldQuickFix(psiClass, string, psiType, string2, stringArray);
    }

    public static LocalQuickFix createChangeAnnotationParameterFix(@NotNull PsiAnnotation psiAnnotation, @NotNull String string, @Nullable String string2) {
        return new ChangeAnnotationParameterQuickFix(psiAnnotation, string, string2);
    }
}

