/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFieldQuickFix
implements IntentionAction,
LocalQuickFix {
    private final PsiClass myClass;
    private final String myName;
    private final PsiType myType;
    private final String myInitializerText;
    private final Collection<String> myModifiers;

    public CreateFieldQuickFix(@NotNull PsiClass psiClass, @NotNull String string, @NotNull PsiType psiType, @Nullable String string2, String ... stringArray) {
        this.myClass = psiClass;
        this.myName = string;
        this.myType = psiType;
        this.myInitializerText = string2;
        this.myModifiers = Arrays.asList(stringArray);
    }

    @NotNull
    public String getText() {
        return String.format("Create new field '%s'", this.myName);
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        this.applyFixInner(project);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) {
        this.applyFixInner(project);
    }

    private void applyFixInner(Project project) {
        final PsiFile psiFile = this.myClass.getContainingFile();
        final Editor editor = CodeInsightUtil.positionCursor((Project)project, (PsiFile)psiFile, (PsiElement)this.myClass.getLBrace());
        if (editor != null) {
            new WriteCommandAction(project, new PsiFile[]{psiFile}){

                protected void run(Result result) throws Throwable {
                    String string;
                    Object object;
                    PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)CreateFieldQuickFix.this.myClass.getProject()).getElementFactory();
                    PsiField psiField = psiElementFactory.createField(CreateFieldQuickFix.this.myName, CreateFieldQuickFix.this.myType);
                    PsiModifierList psiModifierList = psiField.getModifierList();
                    if (null != psiModifierList) {
                        object = CreateFieldQuickFix.this.myModifiers.iterator();
                        while (object.hasNext()) {
                            string = (String)object.next();
                            psiModifierList.setModifierProperty(string, true);
                        }
                    }
                    if (null != CreateFieldQuickFix.this.myInitializerText) {
                        object = psiElementFactory.createExpressionFromText(CreateFieldQuickFix.this.myInitializerText, (PsiElement)psiField);
                        psiField.setInitializer((PsiExpression)object);
                    }
                    if (!(object = GenerateMembersUtil.insertMembersAtOffset((PsiFile)CreateFieldQuickFix.this.myClass.getContainingFile(), (int)editor.getCaretModel().getOffset(), Collections.singletonList(new PsiGenerationInfo((PsiMember)psiField)))).isEmpty()) {
                        string = (PsiField)((PsiGenerationInfo)object.iterator().next()).getPsiMember();
                        editor.getCaretModel().moveToOffset(string.getTextRange().getEndOffset());
                    }
                    UndoUtil.markPsiFileForUndo((PsiFile)psiFile);
                }

                protected boolean isGlobalUndoAction() {
                    return true;
                }
            }.execute();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

