/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeAnnotationParameterQuickFix
implements IntentionAction,
LocalQuickFix {
    private final PsiAnnotation myAnnotation;
    private final String myName;
    private final String myNewValue;

    public ChangeAnnotationParameterQuickFix(@NotNull PsiAnnotation psiAnnotation, @NotNull String string) {
        this(psiAnnotation, string, null);
    }

    public ChangeAnnotationParameterQuickFix(@NotNull PsiAnnotation psiAnnotation, @NotNull String string, @Nullable String string2) {
        this.myAnnotation = psiAnnotation;
        this.myName = string;
        this.myNewValue = string2;
    }

    @NotNull
    public String getText() {
        if (null == this.myNewValue) {
            return String.format("Remove annotation parameter '%s'", this.myName);
        }
        return String.format("Set annotation parameter '%s = %s'", this.myName, this.myNewValue);
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        this.applyFixInner(project);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) {
        this.applyFixInner(project);
    }

    private void applyFixInner(Project project) {
        final PsiFile psiFile = this.myAnnotation.getContainingFile();
        Editor editor = CodeInsightUtil.positionCursor((Project)project, (PsiFile)psiFile, (PsiElement)this.myAnnotation);
        if (editor != null) {
            new WriteCommandAction(project, new PsiFile[]{psiFile}){

                protected void run(Result result) throws Throwable {
                    PsiNameValuePair psiNameValuePair = ChangeAnnotationParameterQuickFix.this.selectAnnotationAttribute();
                    if (null != psiNameValuePair) {
                        psiNameValuePair.delete();
                    }
                    if (null != ChangeAnnotationParameterQuickFix.this.myNewValue) {
                        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)ChangeAnnotationParameterQuickFix.this.myAnnotation.getProject()).getElementFactory();
                        PsiAnnotation psiAnnotation = psiElementFactory.createAnnotationFromText("@" + ChangeAnnotationParameterQuickFix.this.myAnnotation.getQualifiedName() + "(" + ChangeAnnotationParameterQuickFix.this.myName + "=" + ChangeAnnotationParameterQuickFix.this.myNewValue + ")", ChangeAnnotationParameterQuickFix.this.myAnnotation.getContext());
                        PsiNameValuePair[] psiNameValuePairArray = psiAnnotation.getParameterList().getAttributes();
                        ChangeAnnotationParameterQuickFix.this.myAnnotation.setDeclaredAttributeValue(psiNameValuePairArray[0].getName(), psiNameValuePairArray[0].getValue());
                    }
                    UndoUtil.markPsiFileForUndo((PsiFile)psiFile);
                }

                protected boolean isGlobalUndoAction() {
                    return true;
                }
            }.execute();
        }
    }

    private PsiNameValuePair selectAnnotationAttribute() {
        PsiNameValuePair[] psiNameValuePairArray;
        PsiNameValuePair psiNameValuePair = null;
        for (PsiNameValuePair psiNameValuePair2 : psiNameValuePairArray = this.myAnnotation.getParameterList().getAttributes()) {
            String string = psiNameValuePair2.getName();
            if (!this.equals(this.myName, string) && (string != null || !this.myName.equals("value"))) continue;
            psiNameValuePair = psiNameValuePair2;
            break;
        }
        return psiNameValuePair;
    }

    private boolean equals(CharSequence charSequence, CharSequence charSequence2) {
        return charSequence == null ? charSequence2 == null : charSequence.equals(charSequence2);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

