/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.psi;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.lombok.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.lombok.psi.LombokLightFieldBuilder9Impl;
import de.plushnikov.intellij.lombok.psi.LombokLightMethod;
import de.plushnikov.intellij.lombok.psi.LombokLightMethod10Impl;
import de.plushnikov.intellij.lombok.psi.LombokLightMethod11Impl;
import de.plushnikov.intellij.lombok.psi.LombokLightMethod9Impl;
import de.plushnikov.intellij.lombok.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.lombok.psi.LombokLightMethodBuilder9Impl;
import de.plushnikov.intellij.lombok.util.IntelliJVersionRangeUtil;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;

public abstract class LombokPsiElementFactory {
    private static final Logger LOG = Logger.getInstance((String)LombokPsiElementFactory.class.getName());
    private static LombokPsiElementFactory ourInstance;

    private LombokPsiElementFactory() {
    }

    public static LombokPsiElementFactory getInstance() {
        if (null == ourInstance) {
            LombokPsiElementFactory.initOurInstance();
        }
        return ourInstance;
    }

    private static void initOurInstance() {
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        switch (IntelliJVersionRangeUtil.getIntelliJVersion(buildNumber)) {
            case INTELLIJ_8: {
                throw new RuntimeException(String.format("This version (%s) of IntelliJ is not supported!", buildNumber.asString()));
            }
            case INTELLIJ_9: {
                ourInstance = new LombokPsiElementFactory9();
                break;
            }
            case INTELLIJ_10: 
            case INTELLIJ_10_5: {
                ourInstance = new LombokPsiElementFactory10();
                break;
            }
            default: {
                ourInstance = new LombokPsiElementFactory11();
            }
        }
    }

    public abstract LombokLightFieldBuilder createLightField(@NotNull PsiManager var1, @NotNull String var2, @NotNull PsiType var3);

    public abstract LombokLightMethodBuilder createLightMethod(@NotNull PsiManager var1, @NotNull String var2);

    public abstract LombokLightMethod createLightMethod(PsiManager var1, PsiMethod var2, PsiClass var3);

    static class LombokPsiElementFactory11
    extends LombokPsiElementFactory {
        LombokPsiElementFactory11() {
        }

        @Override
        public LombokLightFieldBuilder createLightField(@NotNull PsiManager psiManager, @NotNull String string, @NotNull PsiType psiType) {
            LombokLightFieldBuilder lombokLightFieldBuilder = null;
            try {
                Class<?> clazz = Class.forName("de.plushnikov.intellij.lombok.psi.LombokLightFieldBuilder11Impl");
                Constructor<?> constructor = clazz.getConstructor(PsiManager.class, String.class, PsiType.class);
                lombokLightFieldBuilder = (LombokLightFieldBuilder)constructor.newInstance(psiManager, string, psiType);
            }
            catch (Exception exception) {
                LOG.error("Class LombokLightFieldBuilder10Impl can not be created", (Throwable)exception);
            }
            return lombokLightFieldBuilder;
        }

        @Override
        public LombokLightMethodBuilder createLightMethod(@NotNull PsiManager psiManager, @NotNull String string) {
            LombokLightMethodBuilder lombokLightMethodBuilder = null;
            try {
                Class<?> clazz = Class.forName("de.plushnikov.intellij.lombok.psi.LombokLightMethodBuilder11Impl");
                Constructor<?> constructor = clazz.getConstructor(PsiManager.class, String.class);
                lombokLightMethodBuilder = (LombokLightMethodBuilder)constructor.newInstance(psiManager, string);
            }
            catch (Exception exception) {
                LOG.error("Class LombokLightFieldBuilder10Impl can not be created", (Throwable)exception);
            }
            return lombokLightMethodBuilder;
        }

        @Override
        public LombokLightMethod createLightMethod(PsiManager psiManager, PsiMethod psiMethod, PsiClass psiClass) {
            return new LombokLightMethod11Impl(psiManager, psiMethod, psiClass);
        }
    }

    static class LombokPsiElementFactory10
    extends LombokPsiElementFactory {
        LombokPsiElementFactory10() {
        }

        @Override
        public LombokLightFieldBuilder createLightField(@NotNull PsiManager psiManager, @NotNull String string, @NotNull PsiType psiType) {
            LombokLightFieldBuilder lombokLightFieldBuilder = null;
            try {
                Class<?> clazz = Class.forName("de.plushnikov.intellij.lombok.psi.LombokLightFieldBuilder10Impl");
                Constructor<?> constructor = clazz.getConstructor(PsiManager.class, String.class, PsiType.class);
                lombokLightFieldBuilder = (LombokLightFieldBuilder)constructor.newInstance(psiManager, string, psiType);
            }
            catch (Exception exception) {
                LOG.error("Class LombokLightFieldBuilder10Impl can not be created", (Throwable)exception);
            }
            return lombokLightFieldBuilder;
        }

        @Override
        public LombokLightMethodBuilder createLightMethod(@NotNull PsiManager psiManager, @NotNull String string) {
            LombokLightMethodBuilder lombokLightMethodBuilder = null;
            try {
                Class<?> clazz = Class.forName("de.plushnikov.intellij.lombok.psi.LombokLightMethodBuilder10Impl");
                Constructor<?> constructor = clazz.getConstructor(PsiManager.class, String.class);
                lombokLightMethodBuilder = (LombokLightMethodBuilder)constructor.newInstance(psiManager, string);
            }
            catch (Exception exception) {
                LOG.error("Class LombokLightFieldBuilder10Impl can not be created", (Throwable)exception);
            }
            return lombokLightMethodBuilder;
        }

        @Override
        public LombokLightMethod createLightMethod(PsiManager psiManager, PsiMethod psiMethod, PsiClass psiClass) {
            return new LombokLightMethod10Impl(psiManager, psiMethod, psiClass);
        }
    }

    static class LombokPsiElementFactory9
    extends LombokPsiElementFactory {
        LombokPsiElementFactory9() {
        }

        @Override
        public LombokLightFieldBuilder createLightField(@NotNull PsiManager psiManager, @NotNull String string, @NotNull PsiType psiType) {
            return new LombokLightFieldBuilder9Impl(psiManager, string, psiType);
        }

        @Override
        public LombokLightMethodBuilder createLightMethod(@NotNull PsiManager psiManager, @NotNull String string) {
            return new LombokLightMethodBuilder9Impl(psiManager, string);
        }

        @Override
        public LombokLightMethod createLightMethod(PsiManager psiManager, PsiMethod psiMethod, PsiClass psiClass) {
            return new LombokLightMethod9Impl(psiManager, psiMethod, psiClass);
        }
    }
}

