/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.extension;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.BuildNumber;
import de.plushnikov.intellij.lombok.extension.ExtensionRegister;
import de.plushnikov.intellij.lombok.extension.ExtensionRegister10Impl;
import de.plushnikov.intellij.lombok.extension.ExtensionRegister11Impl;
import de.plushnikov.intellij.lombok.extension.ExtensionRegister9Impl;
import de.plushnikov.intellij.lombok.util.IntelliJVersionRangeUtil;

public class LombokExtensionRegisterFactory {
    private static ExtensionRegister ourInstance;

    private LombokExtensionRegisterFactory() {
    }

    public static ExtensionRegister getInstance() {
        if (null == ourInstance) {
            ourInstance = LombokExtensionRegisterFactory.createExtensionRegister();
        }
        return ourInstance;
    }

    private static ExtensionRegister createExtensionRegister() {
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        switch (IntelliJVersionRangeUtil.getIntelliJVersion(buildNumber)) {
            case INTELLIJ_8: {
                throw new RuntimeException(String.format("This version (%s) of IntelliJ is not supported!", buildNumber.asString()));
            }
            case INTELLIJ_9: {
                return new ExtensionRegister9Impl();
            }
            case INTELLIJ_10: 
            case INTELLIJ_10_5: {
                return new ExtensionRegister10Impl();
            }
        }
        return new ExtensionRegister11Impl();
    }
}

