/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.quickfix;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import de.plushnikov.intellij.lombok.quickfix.LombokQuickFix;
import org.jetbrains.annotations.NotNull;

public class LombokAnnotationQuickFix9Impl
extends AddAnnotationFix
implements LombokQuickFix {
    private static final Logger LOG = Logger.getInstance((String)("#" + LombokAnnotationQuickFix9Impl.class.getName()));
    private final String myAnnotation;
    private final PsiModifierListOwner myModifierListOwner;
    private final PsiNameValuePair[] myPairs;

    public LombokAnnotationQuickFix9Impl(@NotNull String string, @NotNull PsiModifierListOwner psiModifierListOwner, @NotNull PsiNameValuePair[] psiNameValuePairArray, String ... stringArray) {
        super(string, psiModifierListOwner, stringArray);
        this.myAnnotation = string;
        this.myModifierListOwner = psiModifierListOwner;
        this.myPairs = psiNameValuePairArray;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        PsiModifierList psiModifierList = this.myModifierListOwner.getModifierList();
        LOG.assertTrue(psiModifierList != null);
        if (psiModifierList.findAnnotation(this.myAnnotation) != null) {
            return;
        }
        PsiFile psiFile2 = this.myModifierListOwner.getContainingFile();
        if (!CodeInsightUtilBase.preparePsiElementForWrite((PsiElement)psiFile2)) {
            return;
        }
        for (String string : this.getAnnotationsToRemove()) {
            PsiAnnotation psiAnnotation2 = AnnotationUtil.findAnnotation((PsiModifierListOwner)this.myModifierListOwner, (String[])new String[]{string});
            if (psiAnnotation2 == null) continue;
            psiAnnotation2.delete();
        }
        PsiAnnotation psiAnnotation = psiModifierList.addAnnotation(this.myAnnotation);
        for (PsiNameValuePair psiNameValuePair : this.myPairs) {
            psiAnnotation.setDeclaredAttributeValue(psiNameValuePair.getName(), psiNameValuePair.getValue());
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)psiAnnotation);
        if (psiFile2 != psiFile) {
            UndoUtil.markPsiFileForUndo((PsiFile)psiFile);
        }
    }
}

