/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightParameterListBuilder;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import de.plushnikov.intellij.lombok.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.lombok.psi.LombokLightModifierList10Impl;
import de.plushnikov.intellij.lombok.psi.LombokLightParameter10Impl;
import de.plushnikov.intellij.lombok.psi.LombokLightReferenceListBuilder10Impl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokLightMethodBuilder10Impl
extends LightMethodBuilder
implements LombokLightMethodBuilder {
    private final LombokLightReferenceListBuilder10Impl myThrowsList;
    private final LightIdentifier myNameIdentifier;
    private ASTNode myASTNode;

    public LombokLightMethodBuilder10Impl(@NotNull PsiManager psiManager, @NotNull String string) {
        super(psiManager, StdLanguages.JAVA, string, (PsiParameterList)new LightParameterListBuilder(psiManager, StdLanguages.JAVA), (PsiModifierList)new LombokLightModifierList10Impl(psiManager, StdLanguages.JAVA, new String[0]));
        this.myThrowsList = new LombokLightReferenceListBuilder10Impl(psiManager, PsiReferenceList.Role.THROWS_LIST);
        this.myNameIdentifier = new LightIdentifier(psiManager, string);
    }

    public LombokLightMethodBuilder withNavigationElement(PsiElement psiElement) {
        this.setNavigationElement(psiElement);
        return this;
    }

    public LombokLightMethodBuilder withModifier(@Modifier @NotNull @NonNls String string) {
        this.addModifier(string);
        return this;
    }

    public LombokLightMethodBuilder withMethodReturnType(PsiType psiType) {
        this.setReturnType(psiType);
        return this;
    }

    public LombokLightMethodBuilder withParameter(@NotNull String string, @NotNull PsiType psiType) {
        this.addParameter((PsiParameter)new LombokLightParameter10Impl(string, psiType, (PsiElement)this, StdLanguages.JAVA));
        return this;
    }

    public LombokLightMethodBuilder withException(@NotNull PsiClassType psiClassType) {
        this.myThrowsList.addReference(psiClassType);
        return this;
    }

    public LombokLightMethodBuilder withException(@NotNull String string) {
        this.myThrowsList.addReference(string);
        return this;
    }

    public LombokLightMethodBuilder withContainingClass(@NotNull PsiClass psiClass) {
        this.setContainingClass(psiClass);
        return this;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        return this.myThrowsList;
    }

    public PsiIdentifier getNameIdentifier() {
        return this.myNameIdentifier;
    }

    public PsiElement getParent() {
        PsiElement psiElement = super.getParent();
        psiElement = null != psiElement ? psiElement : this.getContainingClass();
        return psiElement;
    }

    @Nullable
    public PsiFile getContainingFile() {
        PsiClass psiClass = this.getContainingClass();
        return psiClass != null ? psiClass.getContainingFile() : null;
    }

    public String getText() {
        ASTNode aSTNode = this.getNode();
        if (null != aSTNode) {
            return aSTNode.getText();
        }
        return "";
    }

    public ASTNode getNode() {
        if (null == this.myASTNode) {
            this.myASTNode = this.rebuildMethodFromString().getNode();
        }
        return this.myASTNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiMethod rebuildMethodFromString() {
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            stringBuilder.append(this.getAllModifierProperties((LightModifierList)this.getModifierList()));
            PsiType psiType = this.getReturnType();
            if (null != psiType) {
                stringBuilder.append(psiType.getCanonicalText()).append(' ');
            }
            stringBuilder.append(this.getName());
            stringBuilder.append('(');
            if (this.getParameterList().getParametersCount() > 0) {
                for (PsiParameter psiParameter : this.getParameterList().getParameters()) {
                    stringBuilder.append(psiParameter.getType().getCanonicalText()).append(' ').append(psiParameter.getName()).append(',');
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            stringBuilder.append(')');
            stringBuilder.append('{').append("  ").append('}');
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.getManager().getProject()).getElementFactory();
            PsiMethod psiMethod = psiElementFactory.createMethodFromText(stringBuilder.toString(), (PsiElement)this.getContainingClass());
            return psiMethod;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAllModifierProperties(LightModifierList lightModifierList) {
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            for (String string : lightModifierList.getModifiers()) {
                if ("packageLocal".equals(string)) continue;
                stringBuilder.append(string).append(' ');
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }

    public PsiElement copy() {
        return this.rebuildMethodFromString();
    }

    public String toString() {
        return "LombokLightMethodBuilder: " + this.getName();
    }

    public PsiElement replace(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        PsiClass psiClass = this.getContainingClass();
        if (null != psiClass) {
            CheckUtil.checkWritable((PsiElement)psiClass);
            return psiClass.add(psiElement);
        }
        return null;
    }

    public void delete() throws IncorrectOperationException {
    }

    public void checkDelete() throws IncorrectOperationException {
    }
}

