/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.card.client.model.enums;

import cn.hutool.core.util.ObjectUtil;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum CardOperateTypeEnum {
    CREATE("JK", "\u5efa\u5361", "01", new String[0]),
    CLAIM("LY", "\u9886\u7528", "02", new String[]{"01"}),
    RETREAT("TL", "\u9000\u9886", "03", new String[]{"01", "07", "08", "09", "10"}),
    EXCHANGE_IN("HK", "\u6362\u5361(\u5165\u5361)", "04", new String[]{"03"}),
    EXCHANGE_OUT("HK", "\u6362\u5361(\u51fa\u5361)", "041", new String[]{"01"}),
    MER_DID_IN("BC", "\u5e76\u62c6(\u8f6c\u5165)", "05", new String[]{"03"}),
    MER_DID_OUT("BC", "\u5e76\u62c6(\u8f6c\u51fa)", "051", new String[]{"01"}),
    MODIFY("ND", "\u6709\u6548\u671f\u4fee\u6539", "06", new String[]{"00", "01", "03", "05"}),
    INVALID("ZF", "\u9000\u9886\u4f5c\u5e9f", "07", new String[]{"02"}),
    MAGNETIC("BC", "\u8865\u78c1", "08", new String[]{"1"}),
    REPORTLOSS("GS", "\u6302\u5931", "09", new String[]{"03"}),
    RECOVER("HF", "\u6302\u5931\u6062\u590d", "10", new String[]{"04"}),
    ALLOCATE("DB", "\u8c03\u62e8", "11", new String[]{"01"}),
    COUNT_CHECK("PD", "\u76d8\u70b9\u524d\u5904\u7406", "12", new String[0]),
    COUNT_INPUT_CHECK("PDL", "\u76d8\u70b9\u5f55\u5165", "13", new String[]{"01", "07", "08", "09"}),
    MANUAL_INVALID("ZF", "\u624b\u52a8\u4f5c\u5e9f", "14", new String[]{"00", "01", "02", "03", "07", "08", "09"}),
    SALE("FS", "\u53d1\u552e", "s", new String[]{"01"}),
    RETURN("TS", "\u9000\u552e", "r", new String[]{"03"}),
    RETURN_CARD("TK", "\u6743\u9650\u9000\u5361", "rc", new String[]{"03"}),
    CHARGE("CZ", "\u5145\u503c", "c", new String[]{"01"}),
    COUNT_DEFICIT("PK", "\u76d8\u4e8f\u4f5c\u5e9f", "15", new String[0]),
    COUNT_OVERFLOW("PY", "\u76d8\u76c8\u5165\u5e93", "16", new String[0]),
    VALID("YX", "\u6709\u6548\u5361", "16", new String[]{"01", "03"}),
    COUPON_EXCHANGE_MERGE("BCQ", "\u5e76\u62c6\u5238", "17", new String[0]),
    COUPON_EXCHANGE_SPLIT("BCY", "\u5e76\u62c6\u4f59\u989d", "19", new String[0]),
    CHECK("CK", "\u9a8c\u5361", "18", new String[0]),
    UPDATE_CARD_SATUS("GZT", "\u4fee\u6539\u5361\u72b6\u6001", "20", new String[0]),
    PROFIT_LOSS("SY", "\u635f\u6ea2\u72b6\u6001", "21", new String[0]),
    COUPON_CHANGE("CQC", "\u9000\u5238/\u6362\u5238", "22", new String[0]),
    COUPON_DATE("QTZ", "\u5238\u6709\u6548\u671f\u53d8\u66f4", "23", new String[0]),
    SEND_COUPON("ZQ", "\u8d60\u5238", "24", new String[0]),
    BING_MEMBER("BM", "\u7ed1\u5b9a\u4f1a\u5458", "25", new String[0]),
    SALE_SEND_COUPON("FQ", "\u53d1\u552e\u8d60\u5238", "s2", new String[0]),
    SALE_MAEK_COUPON("FBQ", "\u53d1\u552e\u8865\u8d60\u5238", "s4", new String[0]),
    RETURN_COUPON("TQ", "\u9000\u552e\u9000\u5238/\u6362\u5238", "r7", new String[0]),
    AllOCATE_OUT("DC", "\u8c03\u51fa", "26", new String[0]),
    AllOCATE_IN("DR", "\u8c03\u5165", "27", new String[0]),
    CLAIM_OUT("LC", "\u9886\u51fa", "28", new String[0]),
    CLAIM_IN("LR", "\u9886\u5165", "29", new String[0]),
    ADJUST_WAY("ZFTZ", "\u652f\u4ed8\u65b9\u5f0f\u8c03\u6574", "30", new String[0]);

    private String prefix;
    private String name;
    private String value;
    private String[] states;

    private CardOperateTypeEnum(String prefix, String name, String value, String[] states) {
        this.prefix = prefix;
        this.name = name;
        this.value = value;
        this.states = states;
    }

    public static String getOperateNameByPrefix(String prefix) {
        String name = "";
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            ExceptionHandler.publish((String)"", (String)"\u524d\u7f00\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (CardOperateTypeEnum p : CardOperateTypeEnum.values()) {
            if (!prefix.equals(p.getPrefix())) continue;
            name = p.getName();
        }
        if (StringUtil.isEmpty((String)name)) {
            ExceptionHandler.publish((String)"", (String)"\u8f93\u5165\u53c2\u6570\u6709\u8bef\uff0c\u83b7\u53d6\u4e0d\u5230\u64cd\u4f5c\u7c7b\u578b");
        }
        return name;
    }

    public static String getOperateNameByValue(String value) {
        for (CardOperateTypeEnum p : CardOperateTypeEnum.values()) {
            if (!p.getValue().equals(value)) continue;
            return p.getName();
        }
        return value;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String[] getStates() {
        return this.states;
    }

    public static CardOperateTypeEnum getEnumByName(String name) {
        return Arrays.stream(CardOperateTypeEnum.values()).filter(enums -> enums.getName().equals(name)).findFirst().orElse(null);
    }

    public static List<String> getStateListByEnum(CardOperateTypeEnum cardOperateTypeEnum) {
        ArrayList stateList = Lists.newArrayList();
        if (ObjectUtil.isEmpty((Object)((Object)cardOperateTypeEnum))) {
            return stateList;
        }
        for (String state : cardOperateTypeEnum.getStates()) {
            if (!ObjectUtil.isNotEmpty((Object)state)) continue;
            stateList.add(state);
        }
        return stateList;
    }
}

