/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.impl.mina.server;

import com.xxl.rpc.remoting.net.Server;
import com.xxl.rpc.remoting.net.impl.mina.codec.MinaDecoder;
import com.xxl.rpc.remoting.net.impl.mina.codec.MinaEncoder;
import com.xxl.rpc.remoting.net.impl.mina.server.MinaServerHandler;
import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class MinaServer
extends Server {
    private Thread thread;

    @Override
    public void start(final XxlRpcProviderFactory xxlRpcProviderFactory) throws Exception {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NioSocketAcceptor acceptor = new NioSocketAcceptor();
                try {
                    acceptor.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)Executors.newCachedThreadPool()));
                    acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter(new ProtocolCodecFactory(){

                        public ProtocolEncoder getEncoder(IoSession session) throws Exception {
                            return new MinaEncoder(XxlRpcResponse.class, xxlRpcProviderFactory.getSerializer());
                        }

                        public ProtocolDecoder getDecoder(IoSession session) throws Exception {
                            return new MinaDecoder(XxlRpcRequest.class, xxlRpcProviderFactory.getSerializer());
                        }
                    }));
                    acceptor.setHandler((IoHandler)new MinaServerHandler(xxlRpcProviderFactory));
                    SocketSessionConfig config = acceptor.getSessionConfig();
                    config.setReuseAddress(true);
                    config.setTcpNoDelay(true);
                    config.setSoLinger(0);
                    config.setReadBufferSize(2048);
                    config.setIdleTime(IdleStatus.BOTH_IDLE, 10);
                    acceptor.bind((SocketAddress)new InetSocketAddress(xxlRpcProviderFactory.getPort()));
                    logger.info(">>>>>>>>>>> xxl-rpc remoting server start success, nettype = {}, port = {}", (Object)MinaServer.class.getName(), (Object)xxlRpcProviderFactory.getPort());
                    MinaServer.this.onStarted();
                }
                catch (Exception e) {
                    logger.error(">>>>>>>>>>> xxl-rpc remoting server start error.", (Throwable)e);
                }
                finally {
                    if (acceptor != null && acceptor.isActive()) {
                        acceptor.unbind();
                        acceptor.dispose();
                    }
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void stop() throws Exception {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
        this.onStoped();
        logger.info(">>>>>>>>>>> xxl-rpc remoting server destroy success.");
    }
}

