/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.config;

import com.wmeimob.fastboot.core.orm.Mapper;
import java.util.Properties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tk.mybatis.spring.mapper.MapperScannerConfigurer;

@Configuration
public class MyBatisMapperScannerConfig {
    private static final String[] BASE_PACKAGE = new String[]{"com.**.mapper", "org.**.mapper", "cn.**.mapper", "net.**.mapper", "me.**.mapper", "com.**.dao", "cn.**.dao", "org.**.dao", "net.**.dao", "me.**.dao", "com.**.repository", "cn.**.repository", "org.**.repository", "net.**.repository", "me.**.repository"};

    private static String getBasePackage() {
        StringBuilder basePackageStr = new StringBuilder();
        for (String s : BASE_PACKAGE) {
            basePackageStr.append(s).append(",");
        }
        return basePackageStr.toString();
    }

    @Bean
    public static MapperScannerConfigurer mapperScannerConfigurer() {
        MapperScannerConfigurer mapperScannerConfigurer = new MapperScannerConfigurer();
        mapperScannerConfigurer.setSqlSessionFactoryBeanName("sqlSessionFactory");
        mapperScannerConfigurer.setBasePackage(MyBatisMapperScannerConfig.getBasePackage());
        Properties properties = new Properties();
        properties.setProperty("mappers", Mapper.class.getName());
        properties.setProperty("notEmpty", "false");
        properties.setProperty("IDENTITY", "MYSQL");
        mapperScannerConfigurer.setProperties(properties);
        return mapperScannerConfigurer;
    }
}

