/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.temp.controller;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.temp.service.RefundOrderServiceImpl;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.ShippingFeeBatchRequestVO;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/refundOrder"})
public class RefundOrderController {
    private static final Logger log = LoggerFactory.getLogger(RefundOrderController.class);
    @Autowired
    private RefundOrderServiceImpl refundOrderService;
    @Resource
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    @PostMapping(value={"/refundShippingFeeOne"})
    public Object refundShippingFee(String orderNo) {
        log.info("RefundOrderController # refundShippingFee");
        return this.refundOrderService.refundShippingFeeOption(orderNo);
    }

    @PostMapping(value={"/refundShippingFeeBatch"})
    public Object refundShippingFeeBatch(@RequestBody ShippingFeeBatchRequestVO shippingFeeBatchRequestVO) {
        log.info("refundShippingFeeBatch # refundShippingFeeBatch :{}", (Object)JSON.toJSONString((Object)shippingFeeBatchRequestVO));
        this.scheduledThreadPoolExecutor.execute(() -> {
            log.info("refundShippingFeeBatch\u4f7f\u7528\u7ebf\u7a0b\u6c60");
            this.refundOrderService.refundShippingFeeOptionBatch(shippingFeeBatchRequestVO);
        });
        return ResponseUtil.getSuccessData(null);
    }

    @PostMapping(value={"/refundShippingFeeRetry"})
    public Object refundShippingFeeRetry(String orderNo) {
        log.info("RefundOrderController # refundShippingFeeRetry");
        return this.refundOrderService.refundShippingFeeOptionRetry(orderNo);
    }
}

