/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.open.service.MiniprogramService;
import com.wmeimob.fastboot.starter.wechat.mapper.WechatMpMapper;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.wechat.service.WechatMpService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.WechatMp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class WechatMpServiceImpl
implements WechatMpService {
    private static final Logger log = LoggerFactory.getLogger(WechatMpServiceImpl.class);
    private static final String QUERY_WECHAT_MP_BY_APPID_LOCK_PREFIX = "query_exists:";
    @Resource
    private WechatMpMapper wechatMpMapper;
    @Resource
    private MiniprogramService miniprogramService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public Integer queryPrimaryKey(WechatMp wechatMp) {
        Assert.notNull((Object)wechatMp.getAppid(), (String)"wechat appid is not allowed a null value ");
        WechatMp queryParam = new WechatMp();
        queryParam.setComponentAppid(wechatMp.getComponentAppid());
        queryParam.setAppid(wechatMp.getAppid());
        List wechatMps = this.wechatMpMapper.select((Object)queryParam);
        if (wechatMps.size() > 1) {
            log.error("Query wechat info count by appid {} , the count should be one ,but found {}", (Object)wechatMp.getAppid(), (Object)wechatMps.size());
            throw new CustomException("An error occurred when query wechat info from db.");
        }
        return wechatMps.size() == 1 ? ((WechatMp)wechatMps.get(0)).getId() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={RuntimeException.class})
    public WechatMp save(WechatMp wechatMp) {
        this.checkParam(wechatMp);
        String synStr = QUERY_WECHAT_MP_BY_APPID_LOCK_PREFIX + wechatMp.getAppid() + wechatMp.getComponentAppid();
        String string = synStr.intern();
        synchronized (string) {
            Integer pk = this.queryPrimaryKey(wechatMp);
            Date now = new Date();
            wechatMp.setUpdatedAt(now);
            if (pk != null) {
                wechatMp.setId(pk);
                int result = this.wechatMpMapper.updateByPrimaryKeySelective((Object)wechatMp);
                if (result > 0) {
                    this.stringRedisTemplate.delete((Object)("mps:" + pk));
                    this.stringRedisTemplate.delete((Object)("opens:authorizer_appids:" + wechatMp.getAppid() + ":refresh_token"));
                    return wechatMp;
                }
                return null;
            }
            wechatMp.setCreatedAt(now);
            this.wechatMpMapper.insertSelective((Object)wechatMp);
            return wechatMp;
        }
    }

    public WechatMp queryByAppid(String appid) {
        WechatMp wechatMp = new WechatMp();
        wechatMp.setAppid(appid);
        return (WechatMp)this.wechatMpMapper.selectOne((Object)wechatMp);
    }

    private void checkParam(WechatMp wechatMp) {
        InputValidator.checkLengthRange((Object)wechatMp.getAppid(), (int)6, (int)32, (String)"appid");
        InputValidator.checkLengthRange((Object)wechatMp.getNickName(), (int)2, (int)32, (String)"\u5c0f\u7a0b\u5e8f\u540d\u79f0");
        InputValidator.checkLengthRange((Object)wechatMp.getHeadImg(), (int)6, (int)2048, (String)"\u5c0f\u7a0b\u5e8f\u5934\u50cf");
        InputValidator.checkLengthRange((Object)wechatMp.getQrcodeUrl(), (int)6, (int)2048, (String)"\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801");
        InputValidator.checkEmpty((Object)wechatMp.getVerifyTypeInfo(), (String)"\u8ba4\u8bc1\u72b6\u6001[verifyTypeInfo]");
        InputValidator.checkEmpty((Object)wechatMp.getAuthorizerRefreshToken(), (String)"\u6388\u6743\u5237\u65b0token");
        InputValidator.checkLengthRange((Object)wechatMp.getPrincipalName(), (int)2, (int)64, (String)"\u4e3b\u4f53\u540d\u79f0");
        InputValidator.checkLengthRange((Object)wechatMp.getGhid(), (int)2, (int)32, (String)"\u539f\u59cbID[ghid]");
        InputValidator.checkEmpty((Object)wechatMp.getBusinessInfo(), (String)"\u4e1a\u52a1\u72b6\u6001[businessInfo]");
        InputValidator.checkEmpty((Object)wechatMp.getBusinessInfo().getInteger("open_pay"), (String)"\u5fae\u4fe1\u652f\u4ed8\u5f00\u901a\u72b6\u6001");
        InputValidator.checkEmpty((Object)wechatMp.getSignature(), (String)"\u8d26\u53f7\u4ecb\u7ecd");
        InputValidator.checkEmpty((Object)wechatMp.getComponentAppid(), (String)"\u7b2c\u4e09\u65b9\u5e73\u53f0appid");
    }

    public List<WechatMp> getMps(Integer uid) {
        return this.wechatMpMapper.selectAll();
    }
}

