/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.HotGoods;
import com.wmeimob.fastboot.bizvane.enums.ModuleType;
import com.wmeimob.fastboot.bizvane.mapper.HotGoodsMapper;
import com.wmeimob.fastboot.bizvane.service.HotGoodsService;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(rollbackFor={Exception.class})
public class HotGoodsServiceImpl
implements HotGoodsService {
    @Autowired
    private HotGoodsMapper hotGoodsMapper;

    public void add(Integer merchantId, Integer moduleType, Integer dataId, String[] goodsNo) {
        InputValidator.checkEmpty((Object)moduleType, (String)"\u53c2\u6570");
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        InputValidator.checkEmpty((Object)goodsNo, (String)"\u53c2\u6570");
        if (ModuleType.SUBJECT_SETTINGS.getValue().equals(moduleType)) {
            InputValidator.checkEmpty((Object)dataId, (String)"\u53c2\u6570");
        }
        List<String> strings = Arrays.asList(goodsNo);
        ArrayList hotGoods = new ArrayList();
        strings.forEach(x -> {
            HotGoods goods = new HotGoods();
            goods.setGoodsNo(x);
            goods.setDataId(dataId);
            goods.setMerchantId(merchantId);
            goods.setModuleType(moduleType);
            goods.setGmtCreate(new Date());
            hotGoods.add(goods);
        });
        Example example = new Example(HotGoods.class);
        if (moduleType == 1) {
            example.createCriteria().andEqualTo("moduleType", (Object)moduleType).andEqualTo("merchantId", (Object)merchantId);
        } else {
            example.createCriteria().andEqualTo("moduleType", (Object)moduleType).andEqualTo("merchantId", (Object)merchantId).andEqualTo("dataId", (Object)dataId);
        }
        this.hotGoodsMapper.deleteByExample((Object)example);
        this.hotGoodsMapper.insertList(hotGoods);
    }

    public List<HotGoods> getHotGoods(Integer merchantId, Integer moduleType, Integer dataId) {
        InputValidator.checkEmpty((Object)moduleType, (String)"\u53c2\u6570");
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        if (ModuleType.SUBJECT_SETTINGS.getValue().equals(moduleType)) {
            InputValidator.checkEmpty((Object)dataId, (String)"\u53c2\u6570");
        }
        HotGoods hotGoods = new HotGoods();
        hotGoods.setMerchantId(merchantId);
        hotGoods.setDataId(dataId);
        hotGoods.setModuleType(moduleType);
        return this.hotGoodsMapper.select((Object)hotGoods);
    }
}

