/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.Activity;
import com.wmeimob.fastboot.bizvane.entity.ActivityRule;
import com.wmeimob.fastboot.bizvane.entity.ActivityRuleCombination;
import com.wmeimob.fastboot.bizvane.entity.ActivityRuleGift;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.enums.ActivitySanEnum;
import com.wmeimob.fastboot.bizvane.mapper.ActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleCombinationMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.service.ActivitySanService;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class ActivitySanServiceImpl
implements ActivitySanService {
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ActivityRuleMapper activityRuleMapper;
    @Autowired
    private ActivityRuleGiftMapper activityRuleGiftMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private ActivityRuleCombinationMapper activityRuleCombinationMapper;

    public List<Activity> getActivitySanList(String type, Integer merchantId) {
        Example example = new Example(Activity.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("type", (Object)type);
        List list = this.activityMapper.selectByExample((Object)example);
        if (list.size() > 0) {
            for (Activity activity : list) {
                Example ruleExample = new Example(ActivityRule.class);
                ruleExample.createCriteria().andEqualTo("activityId", (Object)activity.getId());
                List ruleList = this.activityRuleMapper.selectByExample((Object)ruleExample);
                activity.setActivityRuleList(ruleList);
                if ("3".equals(type)) continue;
                for (ActivityRule rule : ruleList) {
                    if (activity.getType().equals(ActivitySanEnum.FULL_GIFT.getCode())) {
                        Example giftExample = new Example(ActivityRuleGift.class);
                        giftExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
                        List gifts = this.activityRuleGiftMapper.selectByExample((Object)giftExample);
                        for (ActivityRuleGift ruleGift : gifts) {
                            Example goodExample = new Example(Goods.class);
                            Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)ruleGift.getGoodsId());
                            ruleGift.setGoodsName(goods != null ? goods.getGoodsName() : null);
                        }
                        rule.setActivityRuleGiftList(gifts);
                        continue;
                    }
                    if (!activity.getType().equals(ActivitySanEnum.COMBINATION.getCode())) continue;
                    Example comExample = new Example(ActivityRuleCombination.class);
                    comExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
                    List combinations = this.activityRuleCombinationMapper.selectByExample((Object)comExample);
                    rule.setCombinations(combinations);
                }
            }
        }
        return list;
    }

    @Transactional
    public void addActivitySan(Activity activity) {
        Example example = new Example(Activity.class);
        example.createCriteria().andEqualTo("name", (Object)activity.getName()).andEqualTo("type", (Object)activity.getType()).andEqualTo("merchantId", (Object)activity.getMerchantId());
        List cfList = this.activityMapper.selectByExample((Object)example);
        if (cfList.size() > 0) {
            throw new CustomException("\u6b64\u6d3b\u52a8\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u540d\u79f0\uff01");
        }
        if (!activity.getType().equals(ActivitySanEnum.COMBINATION.getCode())) {
            Example validExample = new Example(Activity.class);
            validExample.createCriteria().andEqualTo("merchantId", (Object)activity.getMerchantId()).andEqualTo("type", (Object)activity.getType()).andCondition("DATE_FORMAT(NOW(),'%Y-%m-%d %H:%i:%S') BETWEEN DATE_FORMAT(begin_date,'%Y-%m-%d %H:%i:%S') AND DATE_FORMAT(end_date,'%Y-%m-%d %H:%i:%S')");
            List activities = this.activityMapper.selectByExample((Object)validExample);
            if (activities.size() > 0) {
                throw new CustomException("\u6b64\u6d3b\u52a8\u5728\u6709\u6548\u65f6\u95f4\u5185\u5df2\u5b58\u5728\u4e00\u4e2a\uff0c\u60a8\u53ef\u4ee5\u5728\u5df2\u6709\u7684\u6d3b\u52a8\u4e2d\u6dfb\u52a0\u7b56\u7565\uff01");
            }
        }
        this.activityMapper.insertSelective((Object)activity);
        List list = activity.getActivityRuleList();
        for (ActivityRule rule : list) {
            rule.setActivityId(activity.getId());
            rule.setActivityType(activity.getType().toString());
            rule.setCombinationNum(Integer.valueOf(rule.getCombinations() == null ? 0 : rule.getCombinations().size()));
            this.activityRuleMapper.insertSelective((Object)rule);
            if (activity.getType().equals(ActivitySanEnum.FULL_GIFT.getCode())) {
                List giftList = rule.getActivityRuleGiftList();
                for (ActivityRuleGift gift : giftList) {
                    gift.setRuleId(rule.getId());
                    this.activityRuleGiftMapper.insertSelective((Object)gift);
                }
                continue;
            }
            if (!activity.getType().equals(ActivitySanEnum.COMBINATION.getCode())) continue;
            List combinations = rule.getCombinations();
            if (this.getComRules(combinations)) {
                throw new CustomException("\u6b64\u7ec4\u5408\u5546\u54c1\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u5546\u54c1");
            }
            for (ActivityRuleCombination combination : combinations) {
                combination.setRuleId(rule.getId());
                this.activityRuleCombinationMapper.insertSelective((Object)combination);
            }
        }
    }

    public Activity getActivityById(Integer id) {
        Activity activity = (Activity)this.activityMapper.selectByPrimaryKey((Object)id);
        if (activity == null) {
            return null;
        }
        Example example = new Example(ActivityRule.class);
        example.createCriteria().andEqualTo("activityId", (Object)id);
        List list = this.activityRuleMapper.selectByExample((Object)example);
        activity.setActivityRuleList(list);
        for (ActivityRule rule : list) {
            if (activity.getType().equals(ActivitySanEnum.FULL_GIFT.getCode())) {
                Example giftExample = new Example(ActivityRuleGift.class);
                giftExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
                List gifts = this.activityRuleGiftMapper.selectByExample((Object)giftExample);
                Iterator iterator = gifts.iterator();
                while (iterator.hasNext()) {
                    ActivityRuleGift ruleGift;
                    Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)(ruleGift = (ActivityRuleGift)iterator.next()).getGoodsId());
                    ruleGift.setGoodsName(goods != null ? goods.getGoodsName() : null);
                }
                rule.setActivityRuleGiftList(gifts);
                continue;
            }
            if (!activity.getType().equals(ActivitySanEnum.COMBINATION.getCode())) continue;
            Example comExample = new Example(ActivityRuleCombination.class);
            comExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
            List combinations = this.activityRuleCombinationMapper.selectByExample((Object)comExample);
            rule.setCombinations(combinations);
        }
        return activity;
    }

    @Transactional
    public int deleteActivity(Integer id) {
        int i = 0;
        Activity activity = (Activity)this.activityMapper.selectByPrimaryKey((Object)id);
        Example example = new Example(ActivityRule.class);
        example.createCriteria().andEqualTo("activityId", (Object)id);
        List rules = this.activityRuleMapper.selectByExample((Object)example);
        for (ActivityRule rule : rules) {
            if (activity.getType().equals(ActivitySanEnum.FULL_GIFT.getCode())) {
                Example giftExample = new Example(ActivityRuleGift.class);
                giftExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
                i += this.activityRuleGiftMapper.deleteByExample((Object)giftExample);
                continue;
            }
            if (!activity.getType().equals(ActivitySanEnum.COMBINATION.getCode())) continue;
            Example comExample = new Example(ActivityRuleCombination.class);
            comExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
            i += this.activityRuleCombinationMapper.deleteByExample((Object)comExample);
        }
        this.activityMapper.deleteByPrimaryKey((Object)id);
        return i += this.activityRuleMapper.deleteByExample((Object)example);
    }

    @Transactional
    public void updateActivity(Activity activity) {
        Example cfExample = new Example(Activity.class);
        cfExample.createCriteria().andEqualTo("name", (Object)activity.getName()).andEqualTo("type", (Object)activity.getType()).andEqualTo("merchantId", (Object)activity.getMerchantId()).andNotEqualTo("id", (Object)activity.getId());
        List cfList = this.activityMapper.selectByExample((Object)cfExample);
        if (cfList.size() > 0) {
            throw new CustomException("\u6b64\u6d3b\u52a8\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u540d\u79f0\uff01");
        }
        this.activityMapper.updateByPrimaryKeySelective((Object)activity);
        Example example = new Example(ActivityRule.class);
        example.createCriteria().andEqualTo("activityId", (Object)activity.getId());
        List rules = this.activityRuleMapper.selectByExample((Object)example);
        for (ActivityRule rule : rules) {
            if (activity.getType().equals(ActivitySanEnum.FULL_GIFT.getCode())) {
                Example giftExample = new Example(ActivityRuleGift.class);
                giftExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
                this.activityRuleGiftMapper.deleteByExample((Object)giftExample);
                continue;
            }
            if (!activity.getType().equals(ActivitySanEnum.COMBINATION.getCode())) continue;
            Example comExample = new Example(ActivityRuleCombination.class);
            comExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
            this.activityRuleCombinationMapper.deleteByExample((Object)comExample);
        }
        this.activityRuleMapper.deleteByExample((Object)example);
        List list = activity.getActivityRuleList();
        for (ActivityRule rule : list) {
            rule.setActivityId(activity.getId());
            rule.setActivityType(activity.getType().toString());
            rule.setCombinationNum(Integer.valueOf(rule.getCombinations() == null ? 0 : rule.getCombinations().size()));
            this.activityRuleMapper.insertSelective((Object)rule);
            if (ActivitySanEnum.FULL_GIFT.getCode().equals(activity.getType())) {
                List giftList = rule.getActivityRuleGiftList();
                for (ActivityRuleGift gift : giftList) {
                    gift.setRuleId(rule.getId());
                    this.activityRuleGiftMapper.insertSelective((Object)gift);
                }
                continue;
            }
            if (!activity.getType().equals(ActivitySanEnum.COMBINATION.getCode())) continue;
            List combinationList = rule.getCombinations();
            if (this.getComRules(combinationList)) {
                throw new CustomException("\u6b64\u7ec4\u5408\u5546\u54c1\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u5546\u54c1");
            }
            for (ActivityRuleCombination combination : combinationList) {
                combination.setRuleId(rule.getId());
                this.activityRuleCombinationMapper.insertSelective((Object)combination);
            }
        }
    }

    private boolean getComRules(List<ActivityRuleCombination> combinationList) {
        boolean flag = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < combinationList.size(); ++i) {
            if (i != combinationList.size() - 1) {
                stringBuffer.append(combinationList.get(i).getGoodsId()).append(",");
                continue;
            }
            stringBuffer.append(combinationList.get(i).getGoodsId());
        }
        Example example = new Example(ActivityRule.class);
        example.createCriteria().andEqualTo("activityType", (Object)"4");
        List rules = this.activityRuleMapper.selectByExample((Object)example);
        for (ActivityRule rule : rules) {
            Example comExample = new Example(ActivityRuleCombination.class);
            comExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
            List combinations = this.activityRuleCombinationMapper.selectByExample((Object)comExample);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < combinations.size(); ++i) {
                if (i != combinations.size() - 1) {
                    sb.append(((ActivityRuleCombination)combinations.get(i)).getGoodsId()).append(",");
                    continue;
                }
                sb.append(((ActivityRuleCombination)combinations.get(i)).getGoodsId());
            }
            if (!this.isScrambledString(stringBuffer.toString(), sb.toString())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private boolean isScrambledString(String source, String target) {
        Integer count;
        if (source.length() != target.length()) {
            System.out.println("target string's length is not equal to source length.");
            return false;
        }
        int length = source.length();
        HashMap<Character, Integer> targetCount = new HashMap<Character, Integer>();
        for (int i = 0; i < length; ++i) {
            char c = target.charAt(i);
            int indexOfSource = source.indexOf(c);
            if (indexOfSource == -1) {
                return false;
            }
            if (targetCount.get(Character.valueOf(c)) == null) {
                targetCount.put(Character.valueOf(c), 1);
                continue;
            }
            count = (Integer)targetCount.get(Character.valueOf(c));
            targetCount.put(Character.valueOf(c), 1 + count);
        }
        HashMap<Character, Integer> sourceCount = new HashMap<Character, Integer>();
        for (int i = 0; i < length; ++i) {
            char c = source.charAt(i);
            if (sourceCount.get(Character.valueOf(c)) == null) {
                sourceCount.put(Character.valueOf(c), 1);
                continue;
            }
            count = (Integer)sourceCount.get(Character.valueOf(c));
            sourceCount.put(Character.valueOf(c), 1 + count);
        }
        for (Map.Entry entry : targetCount.entrySet()) {
            Character key = (Character)entry.getKey();
            if (!((Integer)entry.getValue()).equals(sourceCount.get(key))) continue;
            return false;
        }
        return true;
    }
}

