/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.IntegralSpec;
import com.wmeimob.fastboot.bizvane.service.IntegralSpecService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integral/spec"})
@Api(description="\u79ef\u5206\u5546\u57ce\u89c4\u683cAPI")
public class IntegralSpecController {
    private static final Logger log = LoggerFactory.getLogger(IntegralSpecController.class);
    @Autowired
    private IntegralSpecService integralSpecService;

    @ApiOperation(value="\u4fdd\u5b58\u4fee\u6539\u89c4\u683c")
    @RequestMapping(value={"/saveSpec"}, method={RequestMethod.POST})
    public RestResult saveSpec(@RequestBody IntegralSpec integralSpec) {
        if (integralSpec.getId() == null) {
            log.info("\u79ef\u5206\u5546\u57ce\u89c4\u683c\u7c7b\u578b\u65b0\u589e\u3002\u3002\u3002\u3002");
            this.integralSpecService.add(integralSpec);
            return RestResult.success();
        }
        log.info("\u79ef\u5206\u5546\u57ce\u89c4\u683c\u7c7b\u578b\u4fee\u6539\u3002\u3002\u3002\u3002");
        int num = this.integralSpecService.update(integralSpec);
        return num > 0 ? RestResult.success() : RestResult.fail();
    }

    @ApiOperation(value="\u5220\u9664\u89c4\u683c")
    @ApiImplicitParam(name="id", value="\u4e3b\u952eid", dataType="int", paramType="query", required=true)
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public RestResult delete(@RequestParam(value="id") Integer id) {
        int result = this.integralSpecService.delete(id);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @ApiOperation(value="\u89c4\u683c\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="merchantId", value="\u54c1\u724cid", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875\u6570", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="pageSize", value="\u4e00\u9875\u5c55\u793a\u6570\u91cf", dataType="int", paramType="query", required=true)})
    @RequestMapping(value={"/getSpelList"}, method={RequestMethod.GET})
    @Page
    public PageInfo getSpelList(@RequestParam(value="merchantId") Integer merchantId) {
        log.info("\u89c4\u683c\u5206\u9875\u67e5\u8be2");
        List list = this.integralSpecService.getList(merchantId);
        return new PageInfo(list);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u89c4\u683c")
    @ApiImplicitParam(name="merchantId", value="\u54c1\u724cid", dataType="int", paramType="query", required=true)
    @RequestMapping(value={"/getList"}, method={RequestMethod.GET})
    public List<IntegralSpec> getList(@RequestParam(value="merchantId") Integer merchantId) {
        log.info("\u83b7\u53d6\u6240\u6709\u89c4\u683c");
        List list = this.integralSpecService.getList(merchantId);
        return list;
    }
}

