/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral;

import com.wmeimob.fastboot.bizvane.entity.IntegralConfig;
import com.wmeimob.fastboot.bizvane.service.IntegralConfigService;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.InputValidator;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integral/config"})
@Api(description="\u79ef\u5206\u5546\u57ce\u57fa\u672c\u914d\u7f6eAPI")
public class IntegralConfigController {
    private static final Logger log = LoggerFactory.getLogger(IntegralConfigController.class);
    @Autowired
    private IntegralConfigService integralConfigService;

    @ApiOperation(value="\u4fdd\u5b58\u4fee\u6539\u57fa\u672c\u914d\u7f6e")
    @RequestMapping(value={"/saveConfig"}, method={RequestMethod.POST})
    public RestResult saveConfig(@RequestBody IntegralConfig integralConfig) {
        InputValidator.checkEmpty((Object)integralConfig.getMerchantId(), (String)"\u54c1\u724cid");
        IntegralConfig config = this.integralConfigService.getConfig(integralConfig.getMerchantId());
        if (config == null) {
            log.info("\u57fa\u672c\u914d\u7f6e\u65b0\u589e\u3002\u3002\u3002");
            this.integralConfigService.addConfig(integralConfig);
        } else {
            log.info("\u57fa\u672c\u914d\u7f6e\u4fee\u6539\u3002\u3002\u3002");
            integralConfig.setId(config.getId());
            integralConfig.setGmtCreate(config.getGmtCreate());
            this.integralConfigService.updateConfig(integralConfig);
        }
        return RestResult.success();
    }

    @ApiOperation(value="\u83b7\u53d6\u57fa\u672c\u914d\u7f6e\u4fe1\u606f")
    @ApiImplicitParam(name="merchantId", value="\u54c1\u724cid", dataType="int", paramType="query", required=true)
    @RequestMapping(value={"/getConfig"}, method={RequestMethod.GET})
    public IntegralConfig getConfig(@RequestParam(value="merchantId") Integer merchantId) {
        return this.integralConfigService.getConfig(merchantId);
    }
}

