/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.service.RefundOrderService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"refund-orders"})
public class RefundOrderController {
    @Autowired
    private RefundOrderService refundOrderService;

    @Page
    @GetMapping
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, RefundOrder refundOrder) {
        refundOrder.setMerchantId(merchantId);
        List list = this.refundOrderService.findByCondition((Serializable)refundOrder);
        return new PageInfo(list);
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id, @RequestBody RefundOrder refundOrder) {
        refundOrder.setMerchantId(merchantId);
        int result = this.refundOrderService.update((Serializable)refundOrder);
        return result < 0 ? RestResult.fail() : RestResult.success();
    }

    @GetMapping(value={"{id}"})
    public RefundOrder findById(@PathVariable(value="id") Integer id) {
        return (RefundOrder)this.refundOrderService.findById(id);
    }

    @PutMapping(value={"refund/{id}"})
    public void updateRefundStatus(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id) {
        int result = this.refundOrderService.updateRefundStatus(merchantId, id);
    }
}

