/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.GoodsTag;
import com.wmeimob.fastboot.bizvane.service.GoodsTagService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"goods-tag"})
public class GoodsTagController {
    @Autowired
    private GoodsTagService goodsTagService;

    @PostMapping
    public RestResult add(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsTag goodsTag) {
        goodsTag.setMerchantId(merchantId);
        this.goodsTagService.add((Serializable)goodsTag);
        return RestResult.success();
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@PathVariable(value="id") Integer id, @RequestBody GoodsTag goodsTag) {
        int result = this.goodsTagService.update((Serializable)goodsTag);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @DeleteMapping(value={"{id}"})
    public RestResult delete(@PathVariable(value="id") Integer id) {
        int result = this.goodsTagService.delete(id);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @GetMapping
    @Page
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, GoodsTag toodsTag) {
        toodsTag.setMerchantId(merchantId);
        List list = this.goodsTagService.findByCondition((Serializable)toodsTag);
        return new PageInfo(list);
    }
}

