/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpec;
import com.wmeimob.fastboot.bizvane.service.GoodsSpecService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"goods-spec"})
public class GoodsSpecController {
    @Resource
    private GoodsSpecService goodsSpecService;

    @PostMapping
    public RestResult add(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsSpec goodsSpec) {
        goodsSpec.setMerchantId(merchantId);
        this.goodsSpecService.add((Serializable)goodsSpec);
        return RestResult.success();
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id, @RequestBody GoodsSpec goodsSpec) {
        goodsSpec.setMerchantId(merchantId);
        int result = this.goodsSpecService.update((Serializable)goodsSpec);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @DeleteMapping(value={"{id}"})
    public RestResult delete(@PathVariable(value="id") Integer id) {
        int result = this.goodsSpecService.delete(id);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @GetMapping
    @Page
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, GoodsSpec goodsSpec) {
        goodsSpec.setMerchantId(merchantId);
        List list = this.goodsSpecService.findByCondition((Serializable)goodsSpec);
        return new PageInfo(list);
    }

    @GetMapping(value={"all"})
    public PageInfo listAll(@RequestHeader(value="merchantId") Integer merchantId, GoodsSpec goodsSpec) {
        goodsSpec.setMerchantId(merchantId);
        List list = this.goodsSpecService.findByCondition((Serializable)goodsSpec);
        return new PageInfo(list);
    }

    @GetMapping(value={"selectByPid/{pid}"})
    public List selectByPid(@PathVariable(value="pid") Integer pid) {
        return this.goodsSpecService.selectByPid(pid);
    }
}

