/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.GoodsStatisticalDTO;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsTag;
import com.wmeimob.fastboot.bizvane.mapper.GoodsTagMapper;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.excel.DataConvert;
import com.wmeimob.fastboot.excel.ExcelHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"goods"})
public class GoodsController {
    @Autowired
    private GoodsService goodsService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private GoodsTagMapper goodsTagMapper;

    @PostMapping
    public Goods insert(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Goods goods) {
        goods.setMerchantId(merchantId);
        return (Goods)this.goodsService.add((Serializable)goods);
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id, @RequestBody Goods goods) {
        goods.setMerchantId(merchantId);
        return this.goodsService.update((Serializable)goods) < 1 ? RestResult.fail() : RestResult.success();
    }

    @GetMapping(value={"{id}"})
    public Goods getGoodsById(@PathVariable(value="id") Integer id) {
        return (Goods)this.goodsService.findById(id);
    }

    @Page
    @GetMapping
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, Goods goods) {
        goods.setMerchantId(merchantId);
        List list = this.goodsService.findByCondition((Serializable)goods);
        return new PageInfo(list);
    }

    @PutMapping(value={"updateShelved"})
    public RestResult updateShelved(@RequestBody List<Goods> goodsList, Integer checked) {
        this.goodsService.updateShelved(goodsList, checked);
        return RestResult.success();
    }

    @DeleteMapping(value={"{id}"})
    public RestResult delete(@PathVariable(value="id") Integer id) {
        return this.goodsService.delete(id) < 1 ? RestResult.fail() : RestResult.success();
    }

    @Page
    @GetMapping(value={"goods-stock"})
    public PageInfo<Goods> goodsStock(@RequestHeader(value="merchantId") Integer merchantId, Goods goods) {
        goods.setMerchantId(merchantId);
        List list = this.goodsService.goodsStock(goods);
        return new PageInfo(list);
    }

    @GetMapping(value={"gift/{goodsNo}"})
    public Goods selectGiftByGoodsNo(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="goodsNo") String goodsNo) {
        return this.goodsService.findGiftByNo(merchantId, goodsNo);
    }

    @GetMapping(value={"goodsStatistical"})
    public List<GoodsStatisticalDTO> goodsStatisticalList(@RequestHeader(value="merchantId") Integer merchantId, Goods goods) {
        if (goods.getBeginDate() == null && goods.getEndDate() == null) {
            return null;
        }
        goods.setMerchantId(merchantId);
        return this.goodsService.goodsStatisticalList(goods);
    }

    @GetMapping(value={"goodsNo/{goodsNo}"})
    public Goods selectByGoodsNo(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="goodsNo") String goodsNo) {
        Goods goods = new Goods();
        goods.setMerchantId(merchantId);
        goods.setGoodsNo(goodsNo);
        return this.goodsService.selectByGoodsNo(goods);
    }

    @GetMapping(value={"goodsListExport"})
    public void goodsListExport(String key, Goods goods, HttpServletResponse res) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)("download_key:" + key));
        if (value == null) {
            return;
        }
        goods.setMerchantId(goods.getMerchantId());
        List list = this.goodsService.findByCondition((Serializable)goods);
        for (Goods g : list) {
            if (g.getIsGift() == 1) {
                if (g.getIsShelved().booleanValue()) {
                    g.setOutStatus("\u4e0a\u67b6\uff08\u8d60\u54c1)");
                    continue;
                }
                g.setOutStatus("\u4e0b\u67b6\uff08\u8d60\u54c1)");
                continue;
            }
            if (g.getIsShelved().booleanValue()) {
                g.setOutStatus("\u4e0a\u67b6");
                continue;
            }
            g.setOutStatus("\u4e0b\u67b6");
        }
        String[] heads = new String[]{"\u5546\u54c1\u7f16\u53f7", "\u5546\u54c1\u540d\u79f0", "\u552e\u4ef7", "\u540a\u724c\u4ef7", "\u6807\u7b7e", "\u5b9e\u9645\u9500\u91cf", "\u4e0a\u67b6\u72b6\u6001"};
        String[] fields = new String[]{"goodsNo", "goodsName", "salePrice", "marketPrice", "tagName", "actualSales", "outStatus"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, Goods.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u5546\u54c1\u5217\u8868.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"goodStockListExport"})
    public void goodStockListExport(String key, Goods goods, HttpServletResponse res) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)("download_key:" + key));
        if (value == null) {
            return;
        }
        goods.setMerchantId(goods.getMerchantId());
        List list = this.goodsService.goodsStock(goods);
        HashMap<String, DataConvert> map = new HashMap<String, DataConvert>();
        map.put("isShelved", (v, o) -> o.getIsShelved() != false ? "\u5df2\u4e0a\u67b6" : "\u672a\u4e0a\u67b6");
        map.put("isGift", (v, o) -> o.getIsGift() == 1 ? "\u662f" : "\u5426");
        String[] heads = new String[]{"\u5546\u54c1\u7f16\u7801", "SKU\u7f16\u7801", "\u5546\u54c1\u540d\u79f0", "\u5f53\u524d\u5e93\u5b58", "\u662f\u5426\u8d60\u54c1", "\u4e0a\u67b6\u72b6\u6001", "\u521b\u5efa\u65f6\u95f4"};
        String[] fields = new String[]{"goodsNo", "skuNo", "goodsName", "stock", "isGift", "isShelved", "gmtCreate"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, map, (String[])heads, (String[])fields, Goods.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u5e93\u5b58\u5217\u8868.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"goodsStatisticalExport"})
    public void goodsStatisticalExport(String key, Goods goods, HttpServletResponse res) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)("download_key:" + key));
        if (value == null) {
            return;
        }
        if (goods.getBeginDate() == null && goods.getEndDate() == null) {
            return;
        }
        goods.setMerchantId(goods.getMerchantId());
        List list = this.goodsService.goodsStatisticalList(goods);
        String[] heads = new String[]{"\u5546\u54c1\u7f16\u53f7", "\u6210\u4ea4\u4ef6\u6570", "\u9500\u91cf\u91d1\u989d", "\u6536\u85cf\u91cf", "\u52a0\u5165\u8d2d\u7269\u8f66\u6570\u91cf", "\u552e\u4ef7\u5747\u4ef7"};
        String[] fields = new String[]{"goodsNo", "quantity", "amount", "countCollect", "countCar", "avgPrice"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, GoodsStatisticalDTO.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u5546\u54c1\u7edf\u8ba1.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"getAllTag"})
    public List<GoodsTag> getAllTag(@RequestHeader(value="merchantId") Integer merchantId) {
        Example example = new Example(GoodsTag.class);
        example.orderBy("sort").asc();
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        return this.goodsTagMapper.selectByExample((Object)example);
    }
}

