/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.ExpressTemplate;
import com.wmeimob.fastboot.bizvane.service.ExpressService;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"express"})
public class ExpressController {
    @Autowired
    private ExpressService expressService;

    @PostMapping
    public RestResult add(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody ExpressTemplate expressTemplate) {
        expressTemplate.setStatus(Boolean.valueOf(true));
        expressTemplate.setMerchantId(merchantId);
        this.expressService.add((Serializable)expressTemplate);
        return RestResult.success();
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@PathVariable(value="id") Integer id, @RequestBody ExpressTemplate expressTemplate) {
        expressTemplate.setId(id);
        int result = this.expressService.update((Serializable)expressTemplate);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @DeleteMapping(value={"{id}"})
    public RestResult delete(@PathVariable(value="id") Integer id) {
        int result = this.expressService.delete(id);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @GetMapping
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, ExpressTemplate expressTemplate) {
        expressTemplate.setMerchantId(merchantId);
        List list = this.expressService.findByCondition((Serializable)expressTemplate);
        return new PageInfo(list);
    }

    @GetMapping(value={"{id}"})
    public RestResult selectById(@PathVariable(value="id") Integer id) {
        ExpressTemplate expressTemplate = (ExpressTemplate)this.expressService.findById(id);
        return RestResult.success((Object)expressTemplate);
    }

    @DeleteMapping(value={"template/{id}"})
    public RestResult deleteTemplate(@PathVariable(value="id") Integer id) {
        int result = this.expressService.deleteTemplate(id);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }
}

