/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.Courier;
import com.wmeimob.fastboot.bizvane.service.CourierService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"courier"})
public class CourierController {
    @Autowired
    private CourierService courierService;

    @PostMapping
    public RestResult add(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Courier courier) {
        courier.setMerchantId(merchantId);
        this.courierService.add((Serializable)courier);
        return RestResult.success();
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id, @RequestBody Courier courier) {
        courier.setMerchantId(merchantId);
        int result = this.courierService.update((Serializable)courier);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @DeleteMapping(value={"{id}"})
    public RestResult delete(@PathVariable(value="id") Integer id) {
        int result = this.courierService.delete(id);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @GetMapping
    @Page
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, Courier courier) {
        courier.setMerchantId(merchantId);
        List list = this.courierService.findByCondition((Serializable)courier);
        return new PageInfo(list);
    }
}

