/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.utils;

import com.ververica.cdc.connectors.mysql.schema.MySqlTypeUtils;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class ChunkUtils {
    private ChunkUtils() {
    }

    public static RowType getChunkKeyColumnType(Table table, @Nullable String chunkKeyColumn) {
        return ChunkUtils.getChunkKeyColumnType(ChunkUtils.getChunkKeyColumn(table, chunkKeyColumn));
    }

    public static RowType getChunkKeyColumnType(Column chunkKeyColumn) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)chunkKeyColumn.name(), (DataType)MySqlTypeUtils.fromDbzColumn(chunkKeyColumn))}).getLogicalType();
    }

    public static Column getChunkKeyColumn(Table table, @Nullable String chunkKeyColumn) {
        List primaryKeys = table.primaryKeyColumns();
        if (primaryKeys.isEmpty()) {
            throw new ValidationException(String.format("Incremental snapshot for tables requires primary key, but table %s doesn't have primary key.", table.id()));
        }
        if (chunkKeyColumn != null) {
            Optional<Column> targetPkColumn = primaryKeys.stream().filter(col -> chunkKeyColumn.equals(col.name())).findFirst();
            if (targetPkColumn.isPresent()) {
                return targetPkColumn.get();
            }
            throw new ValidationException(String.format("Chunk key column '%s' doesn't exist in the primary key [%s] of the table %s.", chunkKeyColumn, primaryKeys.stream().map(Column::name).collect(Collectors.joining(",")), table.id()));
        }
        return (Column)primaryKeys.get(0);
    }

    public static int getNextMetaGroupId(int receivedMetaNum, int metaGroupSize) {
        Preconditions.checkState((metaGroupSize > 0 ? 1 : 0) != 0);
        return receivedMetaNum % metaGroupSize == 0 ? receivedMetaNum / metaGroupSize : receivedMetaNum / metaGroupSize + 1;
    }
}

