/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.RegionReqInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

class UpHostHelper {
    private long failedPeriodMillis;
    private Configuration conf;
    private LinkedHashMap<String, RegionUpHost> regionHostsLRU = new LinkedHashMap<String, RegionUpHost>(1, 1.0f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, RegionUpHost> eldest) {
            return this.size() > 6;
        }
    };

    UpHostHelper(Configuration conf, int failedPeriodSeconds) {
        this.conf = conf;
        this.failedPeriodMillis = (long)failedPeriodSeconds * 1000L;
    }

    String upHost(Region region, String upToken, String lastUsedHost, boolean changeHost, boolean mustReturnUpHost) throws QiniuException {
        List<String> srcHosts;
        List<String> accHosts;
        RegionReqInfo regionReqInfo = new RegionReqInfo(upToken);
        try {
            accHosts = region.getAccUpHost(regionReqInfo);
            srcHosts = region.getSrcUpHost(regionReqInfo);
        }
        catch (Exception e) {
            if (mustReturnUpHost && this.conf.useDefaultUpHostIfNone) {
                return this.failedUpHost("failed_get_region");
            }
            if (e instanceof QiniuException) {
                throw e;
            }
            throw QiniuException.unrecoverable(e);
        }
        String regionKey = region.getRegion(regionReqInfo) + "_&//=_" + this.getRegionKey(srcHosts, accHosts);
        RegionUpHost regionHost = this.regionHostsLRU.get(regionKey);
        if (regionHost == null) {
            regionHost = new RegionUpHost();
            this.regionHostsLRU.put(regionKey, regionHost);
        }
        return regionHost.upHost(accHosts, srcHosts, lastUsedHost, changeHost);
    }

    private String failedUpHost(String regionKey) throws QiniuException {
        List<String> srcHosts;
        List<String> accHosts;
        RegionUpHost regionHost = this.regionHostsLRU.get(regionKey);
        if (regionHost == null) {
            regionHost = new RegionUpHost();
            this.regionHostsLRU.put(regionKey, regionHost);
        }
        if (regionHost.lastSrcHosts == null) {
            accHosts = new ArrayList<String>(){
                {
                    this.add("upload.qiniup.com");
                    this.add("upload-z1.qiniup.com");
                    this.add("upload-z2.qiniup.com");
                    this.add("upload-na0.qiniup.com");
                    this.add("upload-as0.qiniup.com");
                }
            };
            Collections.shuffle(accHosts);
            srcHosts = new ArrayList<String>();
        } else {
            srcHosts = regionHost.lastSrcHosts;
            accHosts = regionHost.lastAccHosts;
        }
        return regionHost.upHost(accHosts, srcHosts, null, false);
    }

    String getRegionKey(List<String> srcHosts, List<String> accHosts) {
        String host = null;
        String lhost = null;
        if (srcHosts != null) {
            for (String a : srcHosts) {
                if (host == null) {
                    host = a;
                    lhost = a;
                }
                if (a.length() < host.length()) {
                    host = a;
                }
                if (a.length() <= lhost.length()) continue;
                lhost = a;
            }
        }
        if (host == null && accHosts != null) {
            for (String a : accHosts) {
                if (host == null) {
                    host = a;
                    lhost = a;
                }
                if (a.length() < host.length()) {
                    host = a;
                }
                if (a.length() <= lhost.length()) continue;
                lhost = a;
            }
        }
        return host + ";+=-_" + lhost;
    }

    class RegionUpHost {
        List<String> lastAccHosts;
        List<String> lastSrcHosts;
        HashMap<String, Long> hostMark = new HashMap();
        ArrayList<String> lastHosts;
        volatile int mainHostCount = 0;
        volatile String lastHost;

        RegionUpHost() {
        }

        private void initHostMark(List<String> f, List<String> s) {
            int i;
            if (f == null) {
                f = new ArrayList<String>();
            }
            if (s == null) {
                s = new ArrayList<String>();
            }
            ArrayList<String> _lastHosts = new ArrayList<String>();
            int _mainHostCount = 0;
            if (f.size() > 0) {
                _lastHosts.add(f.get(0));
                ++_mainHostCount;
            }
            if (s.size() > 0) {
                _lastHosts.add(s.get(0));
                ++_mainHostCount;
            }
            int l = Math.min(f.size(), s.size());
            Random r = new Random();
            ArrayList<Integer> iidx = new ArrayList<Integer>();
            for (i = 1; i < l; ++i) {
                iidx.add(i);
            }
            this.randomAdd(_lastHosts, iidx, r, f, s);
            iidx.clear();
            while (i < f.size()) {
                iidx.add(i);
                ++i;
            }
            this.randomAdd(_lastHosts, iidx, r, f, null);
            iidx.clear();
            while (i < s.size()) {
                iidx.add(i);
                ++i;
            }
            this.randomAdd(_lastHosts, iidx, r, s, null);
            this.lastHosts = _lastHosts;
            this.mainHostCount = _mainHostCount;
        }

        private void randomAdd(ArrayList<String> _lastHosts, ArrayList<Integer> iidx, Random r, List<String> list1, List<String> list2) {
            int size = iidx.size();
            for (int j = 0; j < size; ++j) {
                int ji = r.nextInt(iidx.size());
                Integer jv = iidx.remove(ji);
                if (list1 != null) {
                    _lastHosts.add(list1.get(jv));
                }
                if (list2 == null) continue;
                _lastHosts.add(list2.get(jv));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String upHost(List<String> accHosts, List<String> srcHosts, String lastUsedHost, boolean changeHost) throws QiniuException {
            Serializable el0;
            if ((accHosts == null || accHosts.isEmpty()) && (srcHosts == null || srcHosts.isEmpty())) {
                throw QiniuException.unrecoverable("no up host found");
            }
            if (this.lastAccHosts != accHosts || this.lastSrcHosts != srcHosts) {
                this.lastAccHosts = accHosts;
                this.lastSrcHosts = srcHosts;
                HashMap<String, Long> hashMap = this.hostMark;
                synchronized (hashMap) {
                    this.hostMark.clear();
                    if (((UpHostHelper)UpHostHelper.this).conf.accUpHostFirst) {
                        this.initHostMark(this.lastAccHosts, this.lastSrcHosts);
                    } else {
                        this.initHostMark(this.lastSrcHosts, this.lastAccHosts);
                    }
                    this.lastHost = this.lastHosts.get(0);
                }
            }
            long t = System.currentTimeMillis() - UpHostHelper.this.failedPeriodMillis;
            if (!changeHost) {
                int lastUsedIdx;
                el0 = this.hostMark.get(this.lastHost);
                if (el0 == null) {
                    el0 = Long.valueOf(0L);
                }
                if ((Long)el0 < t && (lastUsedIdx = this.lastHosts.indexOf(this.lastHost)) > -1 && lastUsedIdx < this.mainHostCount) {
                    return this.lastHost;
                }
                if (lastUsedHost != null && !this.lastHost.equals(lastUsedHost)) {
                    int lastUsedIdx2;
                    Long el = this.hostMark.get(lastUsedHost);
                    if (el == null) {
                        el = 0L;
                    }
                    if (el < t && (lastUsedIdx2 = this.lastHosts.indexOf(lastUsedHost)) > -1 && lastUsedIdx2 < this.mainHostCount) {
                        this.lastHost = lastUsedHost;
                        return lastUsedHost;
                    }
                }
            }
            if (changeHost) {
                el0 = this.hostMark;
                synchronized (el0) {
                    String host;
                    String string = host = lastUsedHost != null ? lastUsedHost : this.lastHost;
                    if (!this.lastHost.equals(host)) {
                        Long el = this.hostMark.get(this.lastHost);
                        if (el == null) {
                            el = 0L;
                        }
                        if (el < t) {
                            return this.lastHost;
                        }
                    }
                    this.hostMark.put(host, System.currentTimeMillis());
                }
            }
            String _lastHost = this.lastHost;
            for (String h : this.lastHosts) {
                Long e = this.hostMark.get(h);
                if (e == null) {
                    e = 0L;
                }
                if (e < t) {
                    this.lastHost = h;
                    return h;
                }
                if (_lastHost == this.lastHost) continue;
                return this.lastHost;
            }
            HashMap<String, Long> hashMap = this.hostMark;
            synchronized (hashMap) {
                this.hostMark.clear();
                this.lastHost = this.lastHosts.get(0);
            }
            return this.lastHost;
        }
    }
}

