/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.AsyncCallback;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.http.Response;
import com.qiniu.storage.Api;
import com.qiniu.storage.BaseUploader;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.HostProvider;
import com.qiniu.storage.Retry;
import com.qiniu.storage.UpCompletionHandler;
import com.qiniu.storage.UploadToken;
import com.qiniu.util.Crc32;
import com.qiniu.util.StringMap;
import java.io.File;
import java.io.IOException;

public final class FormUploader
extends BaseUploader {
    private final File file;
    private final byte[] data;
    private final String mime;
    private final boolean checkCrc;
    private StringMap params;
    private String filename;

    public FormUploader(Client client, String upToken, String key, byte[] data, StringMap params, String mime, boolean checkCrc, Configuration configuration) {
        this(client, upToken, key, data, null, params, mime, checkCrc, configuration);
    }

    public FormUploader(Client client, String upToken, String key, File file, StringMap params, String mime, boolean checkCrc, Configuration configuration) {
        this(client, upToken, key, null, file, params, mime, checkCrc, configuration);
    }

    private FormUploader(Client client, String upToken, String key, byte[] data, File file, StringMap params, String mime, boolean checkCrc, Configuration configuration) {
        super(client, upToken, key, configuration);
        this.file = file;
        this.data = data;
        this.params = params;
        this.mime = mime;
        this.checkCrc = checkCrc;
    }

    @Override
    Response uploadFlows() throws QiniuException {
        this.buildParams();
        String urlPrefix = this.configHelper.upHost(this.upToken);
        Api api = new Api(this.client, new Api.Config.Builder().setHostRetryMax(this.config.retryMax).setRetryInterval(Retry.staticInterval(this.config.retryInterval)).setHostFreezeDuration(this.config.hostFreezeDuration).setHostProvider(HostProvider.arrayProvider(this.configHelper.upHostsWithoutScheme().toArray(new String[0]))).build());
        Api.Request request = new Api.Request(urlPrefix);
        request.setMethod(MethodType.POST);
        if (this.data != null) {
            request.setMultipartBody("file", this.filename, this.params, this.data, this.mime);
        } else {
            request.setMultipartBody("file", this.filename, this.params, this.file, this.mime);
        }
        return api.requestWithInterceptor(request);
    }

    public void asyncUpload(UpCompletionHandler handler) throws IOException {
        this.buildParams();
        this.asyncRetryUploadBetweenRegion(handler);
    }

    private void asyncRetryUploadBetweenRegion(final UpCompletionHandler handler) {
        UploadToken token = null;
        try {
            token = new UploadToken(this.upToken);
        }
        catch (QiniuException exception) {
            exception.printStackTrace();
            handler.complete(this.key, Response.createError(null, "", 0.0, exception.getMessage()));
            return;
        }
        final UploadToken finalToken = token;
        this.asyncRetryUploadBetweenHosts(0, new UpCompletionHandler(){

            @Override
            public void complete(String key, Response r) {
                if (!(Retry.canSwitchRegionAndRetry(r, null) && FormUploader.this.couldReloadSource() && FormUploader.this.reloadSource() && FormUploader.this.config.region != null && FormUploader.this.config.region.switchRegion(finalToken))) {
                    handler.complete(key, r);
                } else {
                    FormUploader.this.asyncRetryUploadBetweenRegion(handler);
                }
            }
        });
    }

    private void asyncRetryUploadBetweenHosts(final int retryIndex, final UpCompletionHandler handler) {
        String host = null;
        try {
            host = this.configHelper.upHost(this.upToken);
        }
        catch (QiniuException exception) {
            exception.printStackTrace();
            handler.complete(this.key, Response.createError(null, "", 0.0, exception.getMessage()));
            return;
        }
        final String finalHost = host;
        this.asyncUploadWithHost(finalHost, new UpCompletionHandler(){

            @Override
            public void complete(String key, Response r) {
                if (Retry.requestShouldSwitchHost(r, null).booleanValue()) {
                    FormUploader.this.changeHost(FormUploader.this.upToken, finalHost);
                }
                if (Retry.canRequestRetryAgain(r, null).booleanValue() && retryIndex < FormUploader.this.config.retryMax) {
                    FormUploader.this.asyncRetryUploadBetweenHosts(retryIndex + 1, handler);
                } else {
                    handler.complete(key, r);
                }
            }
        });
    }

    private void asyncUploadWithHost(String host, final UpCompletionHandler handler) {
        if (this.data != null) {
            this.client.asyncMultipartPost(host, this.params, "file", this.filename, this.data, this.mime, new StringMap(), new AsyncCallback(){

                @Override
                public void complete(Response res) {
                    handler.complete(FormUploader.this.key, res);
                }
            });
        } else {
            try {
                this.client.asyncMultipartPost(host, this.params, "file", this.filename, this.file, this.mime, new StringMap(), new AsyncCallback(){

                    @Override
                    public void complete(Response res) {
                        handler.complete(FormUploader.this.key, res);
                    }
                });
            }
            catch (QiniuException exception) {
                handler.complete(this.key, Response.createError(null, "", 0.0, exception.getMessage()));
            }
        }
    }

    @Override
    boolean couldReloadSource() {
        return true;
    }

    @Override
    boolean reloadSource() {
        return true;
    }

    private void changeHost(String upToken, String host) {
        try {
            this.configHelper.tryChangeUpHost(upToken, host);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void buildParams() throws QiniuException {
        if (this.params == null) {
            return;
        }
        this.params.put("token", this.upToken);
        if (this.key != null) {
            this.params.put("key", this.key);
        }
        if (this.file != null) {
            this.filename = this.file.getName();
        } else {
            Object object = this.params.get("filename");
            if (object != null) {
                this.filename = (String)object;
                object = null;
            } else if (this.filename == null || this.filename.trim().length() == 0) {
                this.filename = this.key == null ? "defaultFilename" : this.key;
            }
        }
        if (this.checkCrc) {
            long crc32;
            if (this.file != null) {
                try {
                    crc32 = Crc32.file(this.file);
                }
                catch (IOException e) {
                    throw new QiniuException(e);
                }
            } else {
                crc32 = Crc32.bytes(this.data);
            }
            this.params.put("crc32", "" + crc32);
        }
    }
}

