/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.google.gson.Gson;
import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.ConfigHelper;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.util.Json;
import com.qiniu.util.Md5;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlSafeBase64;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Deprecated
public class FixBlockUploader {
    private final int blockSize;
    private final ConfigHelper configHelper;
    private final Client client;
    private final Recorder recorder;
    private final int retryMax;
    private String host = null;

    public FixBlockUploader(int blockSize, Configuration configuration, Client client, Recorder recorder) {
        if (configuration == null) {
            configuration = Configuration.create();
        }
        if (client == null) {
            client = new Client(configuration);
        }
        this.configHelper = new ConfigHelper(configuration);
        this.client = client;
        this.blockSize = blockSize;
        this.recorder = recorder;
        this.retryMax = configuration.retryMax;
    }

    static void sortAsc(List<EtagIdx> etags) {
        Collections.sort(etags, new Comparator<EtagIdx>(){

            @Override
            public int compare(EtagIdx o1, EtagIdx o2) {
                return o1.partNumber - o2.partNumber;
            }
        });
    }

    static void sleepMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Response upload(File file, String token, String key) throws QiniuException {
        return this.upload(file, token, key, null, null, 0);
    }

    public Response upload(File file, String token, String key, ExecutorService pool) throws QiniuException {
        return this.upload(file, token, key, null, pool, 8);
    }

    public Response upload(File file, String token, String key, OptionsMeta params, ExecutorService pool, int maxRunningBlock) throws QiniuException {
        FileBlockData blockData;
        try {
            blockData = new FileBlockData(this.blockSize, file);
        }
        catch (IOException e) {
            throw new QiniuException(e);
        }
        return this.upload((BlockData)blockData, new StaticToken(token), key, params, pool, maxRunningBlock);
    }

    public Response upload(InputStream is, long inputStreamLength, String fileName, String token, String key) throws QiniuException {
        return this.upload(is, inputStreamLength, fileName, token, key, null, null, 0);
    }

    public Response upload(InputStream is, long inputStreamLength, String fileName, String token, String key, ExecutorService pool) throws QiniuException {
        return this.upload(is, inputStreamLength, fileName, token, key, null, pool, 8);
    }

    public Response upload(InputStream is, long inputStreamLength, String fileName, String token, String key, OptionsMeta params, ExecutorService pool, int maxRunningBlock) throws QiniuException {
        InputStreamBlockData blockData = new InputStreamBlockData(this.blockSize, is, inputStreamLength, fileName);
        return this.upload((BlockData)blockData, new StaticToken(token), key, params, pool, maxRunningBlock);
    }

    Response upload(BlockData blockData, String token, String key, OptionsMeta params, ExecutorService pool, int maxRunningBlock) throws QiniuException {
        return this.upload(blockData, new StaticToken(token), key, params, pool, maxRunningBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response upload(BlockData blockData, Token token, String key, OptionsMeta params, ExecutorService pool, int maxRunningBlock) throws QiniuException {
        try {
            Response res;
            String recordFileKey;
            String bucket = this.parseBucket(token.getUpToken());
            String base64Key = key != null ? UrlSafeBase64.encodeToString(key) : "~";
            String string = recordFileKey = this.recorder == null ? "NULL" : this.recorder.recorderKeyGenerate(bucket, base64Key, blockData.getContentUUID(), this.blockSize + "*:|>?^ \b" + this.getClass().getName());
            if (this.host == null) {
                this.host = this.configHelper.upHost(token.getUpToken());
            }
            UploadRecordHelper recordHelper = new UploadRecordHelper(this.recorder, recordFileKey, blockData.repeatable());
            Record record = this.initUpload(blockData, recordHelper, bucket, base64Key, token);
            boolean repeatable = this.recorder != null && blockData.repeatable();
            try {
                this.upBlock(blockData, token, bucket, base64Key, repeatable, record, pool, maxRunningBlock);
                res = this.makeFile(bucket, base64Key, token, record.uploadId, record.etagIdxes, blockData.getFileName(), params);
            }
            catch (QiniuException e) {
                recordHelper.syncRecord(record);
                throw e;
            }
            if (res.isOK()) {
                recordHelper.delRecord();
            }
            Response response = res;
            return response;
        }
        finally {
            blockData.close();
        }
    }

    Record initUpload(BlockData blockData, UploadRecordHelper recordHelper, String bucket, String base64Key, Token token) throws QiniuException {
        Record record = null;
        if (blockData.repeatable() && !recordHelper.isActiveRecord(record = recordHelper.reloadRecord(), blockData)) {
            record = null;
        }
        if (record == null || record.uploadId == null) {
            String uploadId = this.init(bucket, base64Key, token.getUpToken());
            ArrayList<EtagIdx> etagIdxes = new ArrayList<EtagIdx>();
            record = this.initRecord(uploadId, etagIdxes);
            record.blockSize = blockData.blockDataSize;
        }
        return record;
    }

    String init(String bucket, String base64Key, String upToken) throws QiniuException {
        String url = this.host + "/buckets/" + bucket + "/objects/" + base64Key + "/uploads";
        byte[] data = new byte[]{};
        StringMap headers = new StringMap().put("Authorization", "UpToken " + upToken);
        String contentType = "";
        Response res = null;
        try {
            res = this.client.post(url, data, headers, contentType);
        }
        catch (QiniuException e) {
            if (res == null && e.response != null) {
                res = e.response;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (res == null || res.needRetry()) {
            if (res == null || res.needSwitchServer()) {
                this.changeHost(upToken, this.host);
            }
            try {
                res = this.client.post(url, data, headers, contentType);
            }
            catch (QiniuException e) {
                if (res == null && e.response != null) {
                    res = e.response;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (res == null || res.needRetry()) {
                if (res == null || res.needSwitchServer()) {
                    this.changeHost(upToken, this.host);
                }
                res = this.client.post(url, data, headers, contentType);
            }
        }
        try {
            String uploadId = res.jsonToMap().get("uploadId").toString();
            if (uploadId.length() > 10) {
                return uploadId;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new QiniuException(res);
    }

    private void upBlock(BlockData blockData, Token token, String bucket, String base64Key, boolean repeatable, Record record, ExecutorService pool, int maxRunningBlock) throws QiniuException {
        boolean useParallel = this.useParallel(pool, blockData, record);
        if (!useParallel) {
            this.seqUpload(blockData, token, bucket, base64Key, record);
        } else {
            this.parallelUpload(blockData, token, bucket, base64Key, record, repeatable, pool, maxRunningBlock);
        }
    }

    private boolean useParallel(ExecutorService pool, BlockData blockData, Record record) {
        return pool != null && blockData.size() - record.size > (long)this.blockSize;
    }

    private void seqUpload(BlockData blockData, Token token, String bucket, String base64Key, Record record) throws QiniuException {
        String uploadId = record.uploadId;
        List<EtagIdx> etagIdxes = record.etagIdxes;
        NormalRetryCounter counter = new NormalRetryCounter(this.retryMax);
        while (blockData.hasNext()) {
            EtagIdx etagIdx;
            try {
                blockData.nextBlock();
            }
            catch (IOException e) {
                throw new QiniuException(e, e.getMessage());
            }
            DataWraper wrapper = blockData.getCurrentBlockData();
            if (this.alreadyDone(wrapper.getIndex(), etagIdxes)) continue;
            try {
                etagIdx = this.uploadBlock(bucket, base64Key, token, uploadId, wrapper.getData(), wrapper.getSize(), wrapper.getIndex(), counter);
            }
            catch (IOException e) {
                throw new QiniuException(e, e.getMessage());
            }
            etagIdxes.add(etagIdx);
            record.size += (long)etagIdx.size;
        }
    }

    private void parallelUpload(BlockData blockData, final Token token, final String bucket, final String base64Key, Record record, boolean needRecord, ExecutorService pool, int maxRunningBlock) throws QiniuException {
        final String uploadId = record.uploadId;
        List<EtagIdx> etagIdxes = record.etagIdxes;
        final AsyncRetryCounter counter = new AsyncRetryCounter(this.retryMax);
        ArrayList<Future<EtagIdx>> futures = new ArrayList<Future<EtagIdx>>((int)((blockData.size() - record.size + (long)this.blockSize - 1L) / (long)this.blockSize));
        QiniuException qiniuEx = null;
        while (blockData.hasNext()) {
            try {
                blockData.nextBlock();
            }
            catch (IOException e) {
                qiniuEx = new QiniuException(e, e.getMessage());
                break;
            }
            final DataWraper wrapper = blockData.getCurrentBlockData();
            if (this.alreadyDone(wrapper.getIndex(), etagIdxes)) continue;
            Callable<EtagIdx> callable = new Callable<EtagIdx>(){

                @Override
                public EtagIdx call() throws Exception {
                    return FixBlockUploader.this.uploadBlock(bucket, base64Key, token, uploadId, wrapper.getData(), wrapper.getSize(), wrapper.getIndex(), counter);
                }
            };
            this.waitingEnough(maxRunningBlock, futures);
            try {
                futures.add(pool.submit(callable));
            }
            catch (Exception e) {
                qiniuEx = new QiniuException(e, e.getMessage());
                break;
            }
        }
        for (Future future : futures) {
            if (!needRecord && qiniuEx != null) {
                future.cancel(true);
                continue;
            }
            try {
                EtagIdx etagIdx = (EtagIdx)future.get();
                etagIdxes.add(etagIdx);
                record.size += (long)etagIdx.size;
            }
            catch (Exception e) {
                if (qiniuEx != null) continue;
                qiniuEx = new QiniuException(e, e.getMessage());
            }
        }
        if (qiniuEx != null) {
            throw qiniuEx;
        }
    }

    private boolean alreadyDone(int index, List<EtagIdx> etagIdxes) {
        for (EtagIdx etagIdx : etagIdxes) {
            if (etagIdx.partNumber != index) continue;
            return true;
        }
        return false;
    }

    private void waitingEnough(int maxRunningBlock, List<Future<EtagIdx>> futures) {
        while (futures.size() >= maxRunningBlock) {
            int done = 0;
            for (Future<EtagIdx> future : futures) {
                if (!future.isDone()) continue;
                ++done;
            }
            if (futures.size() - done < maxRunningBlock) break;
            FixBlockUploader.sleepMillis(500L);
        }
    }

    EtagIdx uploadBlock(String bucket, String base64Key, Token token, String uploadId, byte[] data, int dataLength, int partNum, RetryCounter counter) throws QiniuException {
        Response res = this.uploadBlockWithRetry(bucket, base64Key, token, uploadId, data, dataLength, partNum, counter);
        try {
            String etag = res.jsonToMap().get("etag").toString();
            if (etag.length() > 10) {
                return new EtagIdx(etag, partNum, dataLength);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new QiniuException(res);
    }

    Response uploadBlockWithRetry(String bucket, String base64Key, Token token, String uploadId, byte[] data, int dataLength, int partNum, RetryCounter counter) throws QiniuException {
        StringMap headers;
        String url = this.host + "/buckets/" + bucket + "/objects/" + base64Key + "/uploads/" + uploadId + "/" + partNum;
        Response res = this.uploadBlock1(url, data, dataLength, headers = new StringMap().put("Content-MD5", Md5.md5(data, 0, dataLength)).put("Authorization", "UpToken " + token.getUpToken()), true);
        if (res.isOK()) {
            return res;
        }
        if (res.needSwitchServer()) {
            this.changeHost(token.getUpToken(), this.host);
        }
        if (!counter.inRange()) {
            return res;
        }
        if (res.needRetry()) {
            counter.retried();
            res = this.uploadBlock1(url, data, dataLength, headers, true);
            if (res.isOK()) {
                return res;
            }
            if (res.needSwitchServer()) {
                this.changeHost(token.getUpToken(), this.host);
            }
            if (!counter.inRange()) {
                return res;
            }
            if (res.needRetry()) {
                counter.retried();
                res = this.uploadBlock1(url, data, dataLength, headers, false);
            }
        }
        return res;
    }

    Response uploadBlock1(String url, byte[] data, int dataLength, StringMap headers, boolean ignoreError) throws QiniuException {
        try {
            Response res = this.client.put(url, data, 0, dataLength, headers, "application/octet-stream");
            return res;
        }
        catch (QiniuException e) {
            if (ignoreError) {
                if (e.response != null) {
                    return e.response;
                }
                return Response.createError(null, null, -1.0, e.getMessage());
            }
            throw e;
        }
    }

    Response makeFile(String bucket, String base64Key, Token token, String uploadId, List<EtagIdx> etags, String fileName, OptionsMeta params) throws QiniuException {
        String url = this.host + "/buckets/" + bucket + "/objects/" + base64Key + "/uploads/" + uploadId;
        StringMap headers = new StringMap().put("Authorization", "UpToken " + token.getUpToken());
        FixBlockUploader.sortAsc(etags);
        byte[] data = new MakefileBody(etags, fileName, params).json().getBytes(Constants.UTF_8);
        Response res = this.makeFile1(url, data, headers, true);
        if (res.needRetry()) {
            res = this.makeFile1(url, data, headers, true);
        }
        if (res.needRetry()) {
            if (res.needSwitchServer()) {
                this.changeHost(token.getUpToken(), this.host);
            }
            res = this.makeFile1(url, data, headers, false);
        }
        if (res.statusCode >= 300) {
            throw new QiniuException(res);
        }
        return res;
    }

    Response makeFile1(String url, byte[] data, StringMap headers, boolean ignoreError) throws QiniuException {
        try {
            Response res = this.client.post(url, data, headers, "application/json");
            return res;
        }
        catch (QiniuException e) {
            if (ignoreError) {
                if (e.response != null) {
                    return e.response;
                }
                return Response.createError(null, null, -1.0, e.getMessage());
            }
            throw e;
        }
    }

    private void changeHost(String upToken, String host) {
        try {
            this.host = this.configHelper.tryChangeUpHost(upToken, host);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String parseBucket(String upToken) throws QiniuException {
        try {
            String part3 = upToken.split(":")[2];
            byte[] b = UrlSafeBase64.decode(part3);
            StringMap m = Json.decode(new String(b, Constants.UTF_8));
            String scope = m.get("scope").toString();
            return scope.split(":")[0];
        }
        catch (Exception e) {
            throw new QiniuException(e, "invalid uptoken : " + upToken);
        }
    }

    Record initRecord(String uploadId, List<EtagIdx> etagIdxes) {
        Record record = new Record();
        record.createdTime = System.currentTimeMillis();
        record.uploadId = uploadId;
        record.size = 0L;
        record.etagIdxes = etagIdxes != null ? etagIdxes : new ArrayList();
        return record;
    }

    public static class OptionsMeta {
        String mimeType;
        StringMap metadata;
        StringMap customVars;

        public OptionsMeta setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public OptionsMeta addMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new StringMap();
            }
            this.metadata.put(key, value);
            return this;
        }

        public OptionsMeta addCustomVar(String key, String value) {
            if (this.customVars == null) {
                this.customVars = new StringMap();
            }
            this.customVars.put(key, value);
            return this;
        }
    }

    static class FileBlockData
    extends BlockData {
        final long totalLength;
        String contentUUID;
        DataWraper dataWraper;
        RandomAccessFile fis;
        String fileName;
        int index = 0;
        long alreadyReadSize = 0L;
        Lock lock;

        FileBlockData(int blockDataSize, File file) throws IOException {
            super(blockDataSize);
            this.fis = new RandomAccessFile(file, "r");
            this.fileName = file.getName();
            this.totalLength = file.length();
            this.contentUUID = file.lastModified() + "_.-^ \b" + file.getAbsolutePath();
            this.lock = new ReentrantLock();
        }

        @Override
        public long size() {
            return this.totalLength;
        }

        @Override
        public DataWraper getCurrentBlockData() {
            return this.dataWraper;
        }

        @Override
        public boolean hasNext() {
            return this.alreadyReadSize < this.totalLength;
        }

        @Override
        public void nextBlock() throws IOException {
            final long start = this.alreadyReadSize + 0L;
            final int readLength = (int)Math.min(this.totalLength - this.alreadyReadSize, (long)this.blockDataSize);
            this.alreadyReadSize += (long)readLength;
            ++this.index;
            final int idx = this.index + 0;
            this.dataWraper = new DataWraper(){

                @Override
                public int getSize() {
                    return readLength;
                }

                @Override
                public int getIndex() {
                    return idx;
                }

                @Override
                public byte[] getData() throws IOException {
                    byte[] data = new byte[FileBlockData.this.blockDataSize];
                    FileBlockData.this.lock.lock();
                    try {
                        FileBlockData.this.fis.seek(start);
                        int size = FileBlockData.this.fis.read(data);
                        assert (readLength == size) : "read size should equals (int)Math.min(totalLength - alreadyReadSize, blockDataSize): " + readLength;
                    }
                    finally {
                        FileBlockData.this.lock.unlock();
                    }
                    return data;
                }
            };
        }

        @Override
        public boolean repeatable() {
            return true;
        }

        @Override
        public String getContentUUID() {
            return this.contentUUID;
        }

        @Override
        public void close() {
            try {
                this.fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }
    }

    static class StaticToken
    implements Token {
        String token;

        StaticToken(String token) {
            this.token = token;
        }

        @Override
        public String getUpToken() {
            return this.token;
        }
    }

    static abstract class BlockData {
        protected final int blockDataSize;

        BlockData(int blockDataSize) {
            this.blockDataSize = blockDataSize;
        }

        abstract DataWraper getCurrentBlockData();

        abstract boolean hasNext();

        abstract void nextBlock() throws IOException;

        abstract void close();

        abstract long size();

        abstract boolean repeatable();

        abstract String getContentUUID();

        abstract String getFileName();
    }

    static interface Token {
        public String getUpToken();
    }

    static class InputStreamBlockData
    extends BlockData {
        final long totalLength;
        final boolean closedAfterUpload;
        boolean repeatable;
        String contentUUID;
        DataWraper dataWraper;
        InputStream is;
        String fileName;
        int index = 0;
        long alreadyReadSize = 0L;

        InputStreamBlockData(int blockDataSize, InputStream is, long totalLength, String fileName) {
            this(blockDataSize, is, totalLength, fileName, true);
        }

        InputStreamBlockData(int blockDataSize, InputStream is, long totalLength, String fileName, boolean closedAfterUpload) {
            this(blockDataSize, is, totalLength, fileName, closedAfterUpload, false, "");
        }

        InputStreamBlockData(int blockDataSize, InputStream is, long totalLength, String fileName, boolean closedAfterUpload, boolean repeatable, String contentUUID) {
            super(blockDataSize);
            this.is = is;
            this.fileName = fileName;
            this.totalLength = totalLength;
            this.closedAfterUpload = closedAfterUpload;
            this.repeatable = repeatable;
            this.contentUUID = contentUUID;
        }

        @Override
        public long size() {
            return this.totalLength;
        }

        @Override
        public DataWraper getCurrentBlockData() {
            return this.dataWraper;
        }

        @Override
        public boolean hasNext() {
            return this.alreadyReadSize < this.totalLength;
        }

        @Override
        public void nextBlock() throws IOException {
            int rl;
            final byte[] data = new byte[this.blockDataSize];
            int rlt = rl = this.is.read(data);
            while (rlt < this.blockDataSize && rl != -1) {
                FixBlockUploader.sleepMillis(100L);
                rl = this.is.read(data, rlt, this.blockDataSize - rlt);
                if (rl <= 0) continue;
                rlt += rl;
            }
            if (rlt != -1) {
                this.alreadyReadSize += (long)rlt;
                ++this.index;
            }
            final int dataLen = rlt;
            final int idx = this.index;
            this.dataWraper = new DataWraper(){

                @Override
                public byte[] getData() {
                    return data;
                }

                @Override
                public int getSize() {
                    return dataLen;
                }

                @Override
                public int getIndex() {
                    return idx;
                }
            };
        }

        @Override
        public boolean repeatable() {
            return this.repeatable;
        }

        @Override
        public String getContentUUID() {
            return this.contentUUID;
        }

        @Override
        public void close() {
            if (this.closedAfterUpload) {
                try {
                    this.is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }
    }

    class UploadRecordHelper {
        boolean needRecord;
        Recorder recorder;
        String recordFileKey;

        UploadRecordHelper(Recorder recorder, String recordFileKey, boolean needRecord) {
            this.needRecord = needRecord;
            if (recorder != null) {
                this.recorder = recorder;
                this.recordFileKey = recordFileKey;
            }
        }

        public Record reloadRecord() {
            Record record = null;
            if (this.recorder != null) {
                try {
                    byte[] data = this.recorder.get(this.recordFileKey);
                    record = (Record)new Gson().fromJson(new String(data, Constants.UTF_8), Record.class);
                    if (!record.isValid()) {
                        record = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return record;
        }

        public void delRecord() {
            if (this.recorder != null) {
                this.recorder.del(this.recordFileKey);
            }
        }

        public void syncRecord(Record record) {
            if (this.needRecord && this.recorder != null && record.etagIdxes.size() > 0) {
                FixBlockUploader.sortAsc(record.etagIdxes);
                this.recorder.set(this.recordFileKey, new Gson().toJson((Object)record).getBytes(Constants.UTF_8));
            }
        }

        public boolean isActiveRecord(Record record, BlockData blockData) {
            boolean isOk;
            boolean bl = isOk = record != null && record.createdTime > System.currentTimeMillis() - 432000000L && !StringUtils.isNullOrEmpty(record.uploadId) && record.etagIdxes != null && record.etagIdxes.size() > 0 && record.size > 0L && record.size <= blockData.size() && record.blockSize == (long)blockData.blockDataSize;
            if (isOk) {
                int p = 0;
                for (EtagIdx ei : record.etagIdxes) {
                    if (ei.partNumber > p) {
                        p = ei.partNumber;
                        continue;
                    }
                    return false;
                }
            }
            return isOk;
        }
    }

    class Record {
        long createdTime;
        String uploadId;
        long size;
        long blockSize;
        List<EtagIdx> etagIdxes;

        Record() {
        }

        boolean isValid() {
            return this.uploadId != null && this.etagIdxes != null && this.etagIdxes.size() > 0;
        }
    }

    class NormalRetryCounter
    implements RetryCounter {
        int count;

        NormalRetryCounter(int max) {
            this.count = max;
        }

        @Override
        public void retried() {
            --this.count;
        }

        @Override
        public boolean inRange() {
            return this.count > 0;
        }
    }

    static interface DataWraper {
        public byte[] getData() throws IOException;

        public int getSize();

        public int getIndex();
    }

    static interface RetryCounter {
        public void retried();

        public boolean inRange();
    }

    class EtagIdx {
        String etag;
        int partNumber;
        transient int size;

        EtagIdx(String etag, int idx, int size) {
            this.etag = etag;
            this.partNumber = idx;
            this.size = size;
        }

        public String toString() {
            return new Gson().toJson((Object)this);
        }
    }

    class AsyncRetryCounter
    implements RetryCounter {
        volatile int count;

        AsyncRetryCounter(int max) {
            this.count = max;
        }

        @Override
        public synchronized void retried() {
            --this.count;
        }

        @Override
        public synchronized boolean inRange() {
            return this.count > 0;
        }
    }

    class MakefileBody {
        List<EtagIdx> parts;
        String fname;
        String mimeType;
        Map<String, Object> metadata;
        Map<String, Object> customVars;

        MakefileBody(List<EtagIdx> etags, String fileName, OptionsMeta params) {
            this.parts = etags;
            this.fname = fileName;
            if (params != null) {
                this.mimeType = params.mimeType;
                if (params.metadata != null && params.metadata.size() > 0) {
                    this.metadata = this.filterParam(params.metadata, "X-Qn-Meta-");
                }
                if (params.customVars != null && params.customVars.size() > 0) {
                    this.customVars = this.filterParam(params.customVars, "x:");
                }
            }
        }

        private Map<String, Object> filterParam(StringMap param, String keyPrefix) {
            final HashMap<String, Object> ret = new HashMap<String, Object>();
            final String prefix = keyPrefix.toLowerCase();
            param.forEach(new StringMap.Consumer(){

                @Override
                public void accept(String key, Object value) {
                    if (key != null && value != null && !StringUtils.isNullOrEmpty(value.toString()) && key.toLowerCase().startsWith(prefix)) {
                        ret.put(key, value);
                    }
                }
            });
            return ret;
        }

        public String json() {
            return new Gson().toJson((Object)this);
        }
    }
}

