/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.media.apis;

import com.google.gson.annotations.SerializedName;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.util.Json;

public class ApiPrefop
extends Api {
    public ApiPrefop(Client client) {
        super(client);
    }

    public ApiPrefop(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends Api.Response {
        private PfopTask data;

        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
            this.data = Json.decode(response.bodyString(), PfopTask.class);
        }

        public PfopTask getData() {
            return this.data;
        }

        public static final class PfopTask {
            @SerializedName(value="id")
            private String persistentId;
            @SerializedName(value="code")
            private Integer code;
            @SerializedName(value="desc")
            private String description;
            @SerializedName(value="inputKey")
            private String objectName;
            @SerializedName(value="inputBucket")
            private String bucketName;
            @SerializedName(value="pipeline")
            private String pipeline;
            @SerializedName(value="taskFrom")
            private String taskFrom;
            @SerializedName(value="reqid")
            private String requestId;
            @SerializedName(value="type")
            private Integer type;
            @SerializedName(value="creationDate")
            private String createdAt;
            @SerializedName(value="items")
            private PfopTaskItem[] items;

            public String getPersistentId() {
                return this.persistentId;
            }

            public Integer getCode() {
                return this.code;
            }

            public String getDescription() {
                return this.description;
            }

            public String getObjectName() {
                return this.objectName;
            }

            public String getBucketName() {
                return this.bucketName;
            }

            public String getPipeline() {
                return this.pipeline;
            }

            public String getTaskFrom() {
                return this.taskFrom;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Integer getType() {
                return this.type;
            }

            public String getCreatedAt() {
                return this.createdAt;
            }

            public PfopTaskItem[] getItems() {
                return this.items;
            }
        }

        public static final class PfopTaskItem {
            @SerializedName(value="cmd")
            private String command;
            @SerializedName(value="code")
            private Integer code;
            @SerializedName(value="desc")
            private String description;
            @SerializedName(value="error")
            private String error;
            @SerializedName(value="hash")
            private String hash;
            @SerializedName(value="key")
            private String objectName;
            @SerializedName(value="returnOld")
            private Integer returnOld;

            public String getCommand() {
                return this.command;
            }

            public Integer getCode() {
                return this.code;
            }

            public String getDescription() {
                return this.description;
            }

            public String getError() {
                return this.error;
            }

            public String getHash() {
                return this.hash;
            }

            public String getObjectName() {
                return this.objectName;
            }

            public Integer getReturnOld() {
                return this.returnOld;
            }
        }
    }

    public static class Request
    extends Api.Request {
        private String persistentId;

        public Request(String urlPrefix, String persistentId) {
            super(urlPrefix);
            this.setMethod(MethodType.GET);
            this.setAuthType(1);
            this.persistentId = persistentId;
        }

        @Override
        protected void prepareToRequest() throws QiniuException {
            if (this.persistentId == null) {
                throw new QiniuException(new NullPointerException("persistentId can't empty"));
            }
            super.prepareToRequest();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("status/get/prefop");
            super.buildPath();
        }

        @Override
        protected void buildQuery() throws QiniuException {
            this.addQueryPair("id", this.persistentId);
            super.buildQuery();
        }

        @Override
        protected void buildHeader() throws QiniuException {
            super.buildHeader();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            super.buildBodyInfo();
        }
    }
}

