/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.media.apis;

import com.google.gson.annotations.SerializedName;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.util.Json;
import com.qiniu.util.StringMap;

public class ApiPfop
extends Api {
    public ApiPfop(Client client) {
        super(client);
    }

    public ApiPfop(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends Api.Response {
        private PfopId data;

        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
            this.data = Json.decode(response.bodyString(), PfopId.class);
        }

        public PfopId getData() {
            return this.data;
        }

        public static final class PfopId {
            @SerializedName(value="persistentId")
            private String persistentId;

            public String getPersistentId() {
                return this.persistentId;
            }
        }
    }

    public static class Request
    extends Api.Request {
        private String bucketName;
        private String objectName;
        private String fops = null;
        private String notifyUrl = null;
        private Integer force = null;
        private Integer type = null;
        private String pipeline = null;
        private String workflowTemplateId = null;

        public Request(String urlPrefix, String bucketName, String objectName) {
            super(urlPrefix);
            this.setMethod(MethodType.POST);
            this.setAuthType(1);
            this.bucketName = bucketName;
            this.objectName = objectName;
        }

        public Request setFops(String fops) {
            this.fops = fops;
            return this;
        }

        public Request setNotifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public Request setForce(Integer force) {
            this.force = force;
            return this;
        }

        public Request setType(Integer type) {
            this.type = type;
            return this;
        }

        public Request setPipeline(String pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public Request setWorkflowTemplateId(String workflowTemplateId) {
            this.workflowTemplateId = workflowTemplateId;
            return this;
        }

        @Override
        protected void prepareToRequest() throws QiniuException {
            if (this.bucketName == null) {
                throw new QiniuException(new NullPointerException("bucketName can't empty"));
            }
            if (this.objectName == null) {
                throw new QiniuException(new NullPointerException("objectName can't empty"));
            }
            super.prepareToRequest();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("pfop/");
            super.buildPath();
        }

        @Override
        protected void buildQuery() throws QiniuException {
            super.buildQuery();
        }

        @Override
        protected void buildHeader() throws QiniuException {
            super.buildHeader();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            StringMap fields = new StringMap();
            fields.put("bucket", this.bucketName);
            fields.put("key", this.objectName);
            if (this.fops != null) {
                fields.put("fops", this.fops);
            }
            if (this.notifyUrl != null) {
                fields.put("notifyURL", this.notifyUrl);
            }
            if (this.force != null) {
                fields.put("force", this.force);
            }
            if (this.type != null) {
                fields.put("type", this.type);
            }
            if (this.pipeline != null) {
                fields.put("pipeline", this.pipeline);
            }
            if (this.workflowTemplateId != null) {
                fields.put("workflowTemplateID", this.workflowTemplateId);
            }
            this.setFormBody(fields);
            super.buildBodyInfo();
        }
    }
}

