/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.iam.apis;

import com.google.gson.annotations.SerializedName;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.util.Json;

public class ApiGetPolicies
extends Api {
    public ApiGetPolicies(Client client) {
        super(client);
    }

    public ApiGetPolicies(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends Api.Response {
        private GetPoliciesResp data;

        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
            this.data = Json.decode(response.bodyString(), GetPoliciesResp.class);
        }

        public GetPoliciesResp getData() {
            return this.data;
        }

        public static final class GetPoliciesResp {
            @SerializedName(value="data")
            private GetPoliciesData data;

            public GetPoliciesData getData() {
                return this.data;
            }
        }

        public static final class GetPoliciesData {
            @SerializedName(value="count")
            private Integer count;
            @SerializedName(value="list")
            private Policy[] list;

            public Integer getCount() {
                return this.count;
            }

            public Policy[] getList() {
                return this.list;
            }
        }

        public static final class Policy {
            @SerializedName(value="id")
            private String id;
            @SerializedName(value="root_uid")
            private Integer rootUid;
            @SerializedName(value="alias")
            private String alias;
            @SerializedName(value="description")
            private String description;
            @SerializedName(value="enabled")
            private Boolean enabled;
            @SerializedName(value="created_at")
            private String createdAt;
            @SerializedName(value="updated_at")
            private String updatedAt;
            @SerializedName(value="statement")
            private Statement[] statement;

            public String getId() {
                return this.id;
            }

            public Integer getRootUid() {
                return this.rootUid;
            }

            public String getAlias() {
                return this.alias;
            }

            public String getDescription() {
                return this.description;
            }

            public Boolean getEnabled() {
                return this.enabled;
            }

            public String getCreatedAt() {
                return this.createdAt;
            }

            public String getUpdatedAt() {
                return this.updatedAt;
            }

            public Statement[] getStatement() {
                return this.statement;
            }
        }

        public static final class Statement {
            @SerializedName(value="action")
            private String[] actions;
            @SerializedName(value="resource")
            private String[] resources;
            @SerializedName(value="effect")
            private String effect;

            public String[] getActions() {
                return this.actions;
            }

            public String[] getResources() {
                return this.resources;
            }

            public String getEffect() {
                return this.effect;
            }
        }
    }

    public static class Request
    extends Api.Request {
        private Integer page = null;
        private Integer pageSize = null;

        public Request(String urlPrefix) {
            super(urlPrefix);
            this.setMethod(MethodType.GET);
            this.setAuthType(1);
        }

        public Request setPage(Integer page) {
            this.page = page;
            return this;
        }

        public Request setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        protected void prepareToRequest() throws QiniuException {
            super.prepareToRequest();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("iam/v1/policies");
            super.buildPath();
        }

        @Override
        protected void buildQuery() throws QiniuException {
            if (this.page != null) {
                this.addQueryPair("page", this.page);
            }
            if (this.pageSize != null) {
                this.addQueryPair("page_size", this.pageSize);
            }
            super.buildQuery();
        }

        @Override
        protected void buildHeader() throws QiniuException {
            super.buildHeader();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            super.buildBodyInfo();
        }
    }
}

