/*
 * Decompiled with CFR 0.152.
 */
package com.montnets.mwgate.smsutil;

import com.google.gson.Gson;
import com.montnets.mwgate.common.ConnObject;
import com.montnets.mwgate.common.Logger;
import com.montnets.mwgate.common.MO;
import com.montnets.mwgate.common.Message;
import com.montnets.mwgate.common.MultiMt;
import com.montnets.mwgate.common.NearMO;
import com.montnets.mwgate.common.NearRPT;
import com.montnets.mwgate.common.RPT;
import com.montnets.mwgate.common.Remains;
import com.montnets.mwgate.common.StaticValue;
import com.montnets.mwgate.common.ValidateParamTool;
import com.montnets.mwgate.smsutil.SmsSendBiz;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class SmsSendConn {
    private SimpleDateFormat sdf = new SimpleDateFormat("MMddHHmmss");
    private boolean isKeepAlive = true;
    private Map<String, ConnObject> connMap = new ConcurrentHashMap<String, ConnObject>();
    private Map<String, String> availIpMap = new ConcurrentHashMap<String, String>();
    private Gson gson = new Gson();

    public SmsSendConn(boolean isKeepAlive) {
        this.isKeepAlive = isKeepAlive;
    }

    public int singleSend(Message message, StringBuffer returnValue) {
        int returnInt;
        block15: {
            returnInt = StaticValue.ERROR_310001;
            int sendSuccess = StaticValue.ERROR_310001;
            try {
                if (message == null) {
                    Logger.getSingleton().info("\u9a8c\u8bc1message\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300015 + ",message\u4e3a\u7a7a\u3002");
                    return StaticValue.ERROR_300015;
                }
                if (returnValue == null || returnValue.length() > 0) {
                    String returnValueStr = "";
                    returnValueStr = returnValue == null ? "returnValue\u4e3a\u7a7a\u3002" : "returnValue:" + returnValue.toString();
                    Logger.getSingleton().info("returnValue\u53c2\u6570\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300016 + "," + returnValueStr);
                    return StaticValue.ERROR_300016;
                }
                if (!ValidateParamTool.validateMobile(message.getMobile())) {
                    return StaticValue.ERROR_300006;
                }
                if (!ValidateParamTool.validateMessage(message.getContent())) {
                    return StaticValue.ERROR_300007;
                }
                SmsSendBiz smsSendBiz = new SmsSendBiz();
                String content = message.getContent().trim();
                if ((content = smsSendBiz.handleContent(content)) == null) {
                    return StaticValue.ERROR_300025;
                }
                message.setContent(content);
                String timestamp = this.sdf.format(Calendar.getInstance().getTime());
                message.setTimestamp(timestamp);
                if (!ValidateParamTool.validateSubPort(message.getExno())) {
                    return StaticValue.ERROR_300008;
                }
                if (!ValidateParamTool.validateCustId(message.getCustid())) {
                    return StaticValue.ERROR_300009;
                }
                if (!ValidateParamTool.validateSvrType(message.getSvrtype())) {
                    return StaticValue.ERROR_300011;
                }
                if (!ValidateParamTool.validateExData(message.getExdata())) {
                    return StaticValue.ERROR_300012;
                }
                String Message2 = null;
                StringBuffer messageBuffer = new StringBuffer("");
                sendSuccess = this.isKeepAlive ? smsSendBiz.sendSmsByKeepAlive(1, message, messageBuffer, this.connMap) : smsSendBiz.sendSmsByNotKeepAlive(1, message, messageBuffer, this.availIpMap);
                if (sendSuccess != 0) {
                    return sendSuccess;
                }
                Message2 = messageBuffer.toString();
                Long rMsgid = null;
                String rCustid = "";
                if (Message2 != null && !"".equals(Message2.trim())) {
                    JSONObject parseObject = (JSONObject)JSONValue.parse((String)Message2);
                    returnInt = Integer.parseInt(String.valueOf(parseObject.get((Object)"result")));
                    if (returnInt == 0) {
                        rMsgid = (Long)parseObject.get((Object)"msgid");
                        rCustid = (String)parseObject.get((Object)"custid");
                        returnValue.append(String.valueOf(message.getMobile()) + "," + rCustid + "," + rMsgid);
                    }
                } else {
                    returnInt = 0;
                }
            }
            catch (Exception e) {
                Logger.getSingleton().error(e, "\u5355\u6761\u53d1\u9001\u63a5\u53e3\u5931\u8d25\uff01");
                if (sendSuccess != 0 || returnInt != StaticValue.ERROR_310001) break block15;
                returnInt = 0;
            }
        }
        return returnInt;
    }

    public int batchSend(Message message, StringBuffer returnValue) {
        int returnInt;
        block16: {
            returnInt = StaticValue.ERROR_310002;
            int sendSuccess = StaticValue.ERROR_310002;
            try {
                if (message == null) {
                    Logger.getSingleton().info("\u9a8c\u8bc1message\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300015 + ",message\u4e3a\u7a7a\u3002");
                    return StaticValue.ERROR_300015;
                }
                if (returnValue == null || returnValue.length() > 0) {
                    String returnValueStr = "";
                    returnValueStr = returnValue == null ? "returnValue\u4e3a\u7a7a\u3002" : "returnValue:" + returnValue.toString();
                    Logger.getSingleton().info("returnValue\u53c2\u6570\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300016 + "," + returnValueStr);
                    return StaticValue.ERROR_300016;
                }
                String validateResult = ValidateParamTool.validateMobiles(message.getMobile());
                if ("fail".equals(validateResult) || "illegalFormat".equals(validateResult)) {
                    return StaticValue.ERROR_300006;
                }
                if ("overNum".equals(validateResult)) {
                    return StaticValue.ERROR_300024;
                }
                if (!ValidateParamTool.validateMessage(message.getContent())) {
                    return StaticValue.ERROR_300007;
                }
                String timestamp = this.sdf.format(Calendar.getInstance().getTime());
                message.setTimestamp(timestamp);
                SmsSendBiz smsSendBiz = new SmsSendBiz();
                String content = message.getContent().trim();
                content = smsSendBiz.handleContent(content);
                if (content == null) {
                    return StaticValue.ERROR_300025;
                }
                message.setContent(content);
                if (!ValidateParamTool.validateSubPort(message.getExno())) {
                    return StaticValue.ERROR_300008;
                }
                if (!ValidateParamTool.validateCustId(message.getCustid())) {
                    return StaticValue.ERROR_300009;
                }
                if (!ValidateParamTool.validateSvrType(message.getSvrtype())) {
                    return StaticValue.ERROR_300011;
                }
                if (!ValidateParamTool.validateExData(message.getExdata())) {
                    return StaticValue.ERROR_300012;
                }
                String Message2 = null;
                StringBuffer messageBuffer = new StringBuffer("");
                sendSuccess = this.isKeepAlive ? smsSendBiz.sendSmsByKeepAlive(2, message, messageBuffer, this.connMap) : smsSendBiz.sendSmsByNotKeepAlive(2, message, messageBuffer, this.availIpMap);
                if (sendSuccess != 0) {
                    return sendSuccess;
                }
                Message2 = messageBuffer.toString();
                Long rMsgid = null;
                String rCustid = "";
                if (Message2 != null && !"".equals(Message2.trim())) {
                    JSONObject parseObject = (JSONObject)JSONValue.parse((String)Message2);
                    returnInt = Integer.parseInt(String.valueOf(parseObject.get((Object)"result")));
                    if (returnInt == 0) {
                        rMsgid = (Long)parseObject.get((Object)"msgid");
                        rCustid = (String)parseObject.get((Object)"custid");
                        returnValue.append(String.valueOf(message.getMobile().split(",")[0]) + "," + rCustid + "," + rMsgid);
                    }
                } else {
                    returnInt = 0;
                }
            }
            catch (Exception e) {
                Logger.getSingleton().error(e, "\u76f8\u540c\u5185\u5bb9\u7fa4\u53d1\u63a5\u53e3\u5931\u8d25\uff01");
                if (sendSuccess != 0 || returnInt != StaticValue.ERROR_310002) break block16;
                returnInt = 0;
            }
        }
        return returnInt;
    }

    public int multiSend(String userid, Long packid, List<MultiMt> multiMtList, StringBuffer returnValue) {
        int returnInt;
        block17: {
            returnInt = StaticValue.ERROR_310003;
            int sendSuccess = StaticValue.ERROR_310003;
            try {
                if (returnValue == null || returnValue.length() > 0) {
                    String returnValueStr = "";
                    returnValueStr = returnValue == null ? "returnValue\u4e3a\u7a7a\u3002" : "returnValue:" + returnValue.toString();
                    Logger.getSingleton().info("returnValue\u53c2\u6570\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300016 + "," + returnValueStr);
                    return StaticValue.ERROR_300016;
                }
                Message message = new Message();
                String timestamp = this.sdf.format(Calendar.getInstance().getTime());
                message.setTimestamp(timestamp);
                message.setUserid(userid);
                message.setPackid(packid);
                SmsSendBiz smsSendBiz = new SmsSendBiz();
                if (multiMtList != null && multiMtList.size() > 0 && multiMtList.size() < 101) {
                    int j = 0;
                    while (j < multiMtList.size()) {
                        MultiMt multiMt = multiMtList.get(j);
                        if (!ValidateParamTool.validateMobile(multiMt.getMobile())) {
                            return StaticValue.ERROR_300006;
                        }
                        if (!ValidateParamTool.validateMessage(multiMt.getContent())) {
                            return StaticValue.ERROR_300007;
                        }
                        String content = multiMt.getContent().trim();
                        if ((content = smsSendBiz.handleContent(content)) == null) {
                            return StaticValue.ERROR_300025;
                        }
                        multiMt.setContent(content);
                        if (!ValidateParamTool.validateSvrType(multiMt.getSvrtype())) {
                            return StaticValue.ERROR_300011;
                        }
                        if (!ValidateParamTool.validateSubPort(multiMt.getExno())) {
                            return StaticValue.ERROR_300008;
                        }
                        if (!ValidateParamTool.validateCustId(multiMt.getCustid())) {
                            return StaticValue.ERROR_300009;
                        }
                        if (!ValidateParamTool.validateExData(multiMt.getExdata())) {
                            return StaticValue.ERROR_300012;
                        }
                        ++j;
                    }
                } else {
                    String sizeStr = "";
                    sizeStr = multiMtList == null ? "multiMtList\u4e3a\u7a7a" : "multiMtList\u96c6\u5408\u5bf9\u8c61\u4e2a\u6570:" + multiMtList.size();
                    Logger.getSingleton().info("\u4e2a\u6027\u5316\u7fa4\u53d1\u624b\u673a\u53f7\u7801\u4e2a\u6570\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300014 + "," + sizeStr);
                    return StaticValue.ERROR_300014;
                }
                String multimt = this.gson.toJson(multiMtList);
                message.setMultimt(multimt);
                String Message2 = null;
                StringBuffer messageBuffer = new StringBuffer("");
                sendSuccess = this.isKeepAlive ? smsSendBiz.sendSmsByKeepAlive(3, message, messageBuffer, this.connMap) : smsSendBiz.sendSmsByNotKeepAlive(3, message, messageBuffer, this.availIpMap);
                if (sendSuccess != 0) {
                    return sendSuccess;
                }
                Message2 = messageBuffer.toString();
                Long rMsgid = null;
                String rCustid = "";
                if (Message2 != null && !"".equals(Message2.trim())) {
                    JSONObject parseObject = (JSONObject)JSONValue.parse((String)Message2);
                    returnInt = Integer.parseInt(String.valueOf(parseObject.get((Object)"result")));
                    if (returnInt == 0) {
                        rMsgid = (Long)parseObject.get((Object)"msgid");
                        rCustid = (String)parseObject.get((Object)"custid");
                        returnValue.append(String.valueOf(multiMtList.get(0).getMobile()) + "," + rCustid + "," + rMsgid);
                    }
                } else {
                    returnInt = 0;
                }
            }
            catch (Exception e) {
                Logger.getSingleton().error(e, "\u4e2a\u6027\u5316\u7fa4\u53d1\u63a5\u53e3\u5931\u8d25\uff01");
                if (sendSuccess != 0 || returnInt != StaticValue.ERROR_310003) break block17;
                returnInt = 0;
            }
        }
        return returnInt;
    }

    public int getBalance(String userid) {
        int resultBalance = StaticValue.ERROR_310006;
        try {
            Message message = new Message();
            String timestamp = this.sdf.format(Calendar.getInstance().getTime());
            message.setTimestamp(timestamp);
            if (!ValidateParamTool.validateUserId(userid)) {
                return StaticValue.ERROR_300001;
            }
            userid = userid.trim().toUpperCase();
            message.setUserid(userid);
            String Message2 = null;
            StringBuffer messageBuffer = new StringBuffer("");
            int getSuccess = StaticValue.ERROR_310006;
            SmsSendBiz smsSendBiz = new SmsSendBiz();
            getSuccess = this.isKeepAlive ? smsSendBiz.getMoRptFeeByKeepAlive(6, message, messageBuffer, this.connMap) : smsSendBiz.getMoRptFeeByNotKeepAlive(6, message, messageBuffer, this.availIpMap);
            if (getSuccess != 0) {
                return getSuccess;
            }
            Message2 = messageBuffer.toString();
            if (Message2 != null && !"".equals(Message2.trim())) {
                JSONObject parseObject = (JSONObject)JSONValue.parse((String)Message2);
                int result = Integer.parseInt(String.valueOf(parseObject.get((Object)"result")));
                resultBalance = result == 0 ? Integer.parseInt(String.valueOf(parseObject.get((Object)"balance"))) : result;
            }
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u67e5\u8be2\u4f59\u989d\u63a5\u53e3\u5931\u8d25\uff01");
            resultBalance = StaticValue.ERROR_310006;
        }
        return resultBalance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMo(String userid, int retsize, List<MO> mos) {
        NearMO nearMO;
        block7: {
            try {
                if (mos == null || mos.size() > 0) {
                    String mosStr = "";
                    mosStr = mos == null ? "mos\u53c2\u6570\u4e3a\u7a7a" : "mos\u53c2\u6570\u5927\u5c0f\u4e3a" + mos.size();
                    Logger.getSingleton().info("\u4e0a\u884cmos\u53c2\u6570\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300019 + "," + mosStr);
                    return StaticValue.ERROR_300019;
                }
                if (!ValidateParamTool.validateUserId(userid)) {
                    return StaticValue.ERROR_300001;
                }
                Message message = new Message();
                String timestamp = this.sdf.format(Calendar.getInstance().getTime());
                message.setTimestamp(timestamp);
                userid = userid.trim().toUpperCase();
                message.setUserid(userid);
                message.setRetsize(retsize);
                String Message2 = null;
                StringBuffer messageBuffer = new StringBuffer("");
                int getSuccess = StaticValue.ERROR_310006;
                SmsSendBiz smsSendBiz = new SmsSendBiz();
                getSuccess = this.isKeepAlive ? smsSendBiz.getMoRptFeeByKeepAlive(4, message, messageBuffer, this.connMap) : smsSendBiz.getMoRptFeeByNotKeepAlive(4, message, messageBuffer, this.availIpMap);
                if (getSuccess != 0) {
                    return getSuccess;
                }
                Message2 = messageBuffer.toString();
                if (Message2 == null || "".equals(Message2.trim())) return StaticValue.ERROR_310004;
                nearMO = (NearMO)this.gson.fromJson(Message2, NearMO.class);
                if (nearMO.getResult() != 0) break block7;
                mos.addAll(nearMO.getMos());
                MO mo = null;
                int i = 0;
                while (i < mos.size()) {
                    mo = mos.get(i);
                    mos.get(i).setContent(URLDecoder.decode(mo.getContent(), "UTF-8"));
                    ++i;
                }
                return 0;
            }
            catch (Exception e) {
                Logger.getSingleton().error(e, "\u83b7\u53d6\u4e0a\u884c\u63a5\u53e3\u5931\u8d25\uff01");
                return StaticValue.ERROR_310004;
            }
        }
        return nearMO.getResult();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRpt(String userid, int retsize, List<RPT> rpts) {
        NearRPT nearRPT;
        block6: {
            try {
                if (rpts == null || rpts.size() > 0) {
                    String rptsStr = "";
                    rptsStr = rpts == null ? "rpts\u53c2\u6570\u4e3a\u7a7a" : "rpts\u53c2\u6570\u5927\u5c0f\u4e3a" + rpts.size();
                    Logger.getSingleton().info("\u72b6\u6001\u62a5\u544arpts\u53c2\u6570\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300020 + "," + rptsStr);
                    return StaticValue.ERROR_300020;
                }
                if (!ValidateParamTool.validateUserId(userid)) {
                    return StaticValue.ERROR_300001;
                }
                Message message = new Message();
                String timestamp = this.sdf.format(Calendar.getInstance().getTime());
                message.setTimestamp(timestamp);
                userid = userid.trim().toUpperCase();
                message.setUserid(userid);
                message.setRetsize(retsize);
                String Message2 = null;
                StringBuffer messageBuffer = new StringBuffer("");
                int getSuccess = StaticValue.ERROR_310005;
                SmsSendBiz smsSendBiz = new SmsSendBiz();
                getSuccess = this.isKeepAlive ? smsSendBiz.getMoRptFeeByKeepAlive(5, message, messageBuffer, this.connMap) : smsSendBiz.getMoRptFeeByNotKeepAlive(5, message, messageBuffer, this.availIpMap);
                if (getSuccess != 0) {
                    return getSuccess;
                }
                Message2 = messageBuffer.toString();
                if (Message2 == null || "".equals(Message2)) return StaticValue.ERROR_310005;
                nearRPT = (NearRPT)this.gson.fromJson(Message2, NearRPT.class);
                if (nearRPT.getResult() != 0) break block6;
                rpts.addAll(nearRPT.getRpts());
                return 0;
            }
            catch (Exception e) {
                Logger.getSingleton().error(e, "\u83b7\u53d6\u72b6\u6001\u62a5\u544a\u63a5\u53e3\u5931\u8d25\uff01");
                return StaticValue.ERROR_310005;
            }
        }
        return nearRPT.getResult();
    }

    public Remains getRemains(String userid) {
        Remains remains = new Remains();
        try {
            Message message = new Message();
            String timestamp = this.sdf.format(Calendar.getInstance().getTime());
            message.setTimestamp(timestamp);
            if (!ValidateParamTool.validateUserId(userid)) {
                return new Remains(StaticValue.ERROR_300001);
            }
            userid = userid.trim().toUpperCase();
            message.setUserid(userid);
            String Message2 = null;
            StringBuffer messageBuffer = new StringBuffer("");
            int getSuccess = StaticValue.ERROR_310006;
            SmsSendBiz smsSendBiz = new SmsSendBiz();
            getSuccess = this.isKeepAlive ? smsSendBiz.getMoRptFeeByKeepAlive(6, message, messageBuffer, this.connMap) : smsSendBiz.getMoRptFeeByNotKeepAlive(6, message, messageBuffer, this.availIpMap);
            if (getSuccess != 0) {
                return new Remains(getSuccess);
            }
            Message2 = messageBuffer.toString();
            if (Message2 != null && !"".equals(Message2.trim())) {
                JSONObject parseObject = (JSONObject)JSONValue.parse((String)Message2);
                int result = Integer.parseInt(String.valueOf(parseObject.get((Object)"result")));
                remains.setResult(result);
                if (result == 0) {
                    int chargetype = Integer.parseInt(String.valueOf(parseObject.get((Object)"chargetype")));
                    remains.setChargetype(chargetype);
                    int balance = Integer.parseInt(String.valueOf(parseObject.get((Object)"balance")));
                    remains.setBalance(balance);
                    String money = String.valueOf(parseObject.get((Object)"money"));
                    remains.setMoney(money);
                }
            }
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u67e5\u8be2\u5269\u4f59\u91d1\u989d\u6216\u6761\u6570\u5931\u8d25\uff01");
            remains.setResult(StaticValue.ERROR_310006);
        }
        return remains;
    }
}

