/*
 * Decompiled with CFR 0.152.
 */
package com.montnets.mwgate.smsutil;

import com.montnets.mwgate.common.Account;
import com.montnets.mwgate.common.ConnObject;
import com.montnets.mwgate.common.EncryptUtil;
import com.montnets.mwgate.common.Logger;
import com.montnets.mwgate.common.Message;
import com.montnets.mwgate.common.StaticValue;
import com.montnets.mwgate.common.ValidateParamTool;
import com.montnets.mwgate.smsutil.ConfigManager;
import com.montnets.mwgate.smsutil.ConnManager;
import com.montnets.mwgate.smsutil.HttpPostBiz;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Map;

public class SmsSendBiz {
    public int sendSmsByKeepAlive(int sendType, Message message, StringBuffer messageBuffer, Map<String, ConnObject> connMap) {
        int failCode = StaticValue.ERROR_310001;
        ConnObject connObject = null;
        try {
            String encryptPwd;
            Account account;
            ConnManager connManager = new ConnManager();
            if (message.getUserid() != null && message.getUserid().trim().length() > 0) {
                if (!ValidateParamTool.validateUserId(message.getUserid())) {
                    return StaticValue.ERROR_300001;
                }
                message.setUserid(message.getUserid().trim().toUpperCase());
                account = new Account();
                connObject = connManager.getConnByUserID(account, message.getUserid(), connMap);
                if (connObject == null) {
                    Logger.getSingleton().info("\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u8005\u8d26\u53f7\u4e0d\u53ef\u7528,\u9519\u8bef\u7801:" + StaticValue.ERROR_310008 + ",\u8d26\u53f7:" + message.getUserid());
                    return StaticValue.ERROR_310008;
                }
                encryptPwd = new EncryptUtil().encryptPwd(account.getUserid(), account.getPassword(), message.getTimestamp());
                if (encryptPwd == null || encryptPwd.length() < 1) {
                    return StaticValue.ERROR_300010;
                }
                message.setPwd(encryptPwd);
            } else {
                account = new Account();
                connObject = connManager.getConnByPriority(connMap, account);
                if (connObject == null) {
                    Logger.getSingleton().info("\u65e0\u53ef\u7528\u7684\u8d26\u53f7,\u9519\u8bef\u7801:" + StaticValue.ERROR_310009);
                    return StaticValue.ERROR_310009;
                }
                message.setUserid(account.getUserid());
                encryptPwd = new EncryptUtil().encryptPwd(account.getUserid(), account.getPassword(), message.getTimestamp());
                if (encryptPwd == null) {
                    return StaticValue.ERROR_300010;
                }
                message.setPwd(encryptPwd);
            }
            String requestHost = "http://" + connObject.getIpAndPort();
            String Message2 = null;
            String methodName = "";
            if (sendType == 1) {
                methodName = "single_send";
                failCode = StaticValue.ERROR_310001;
            } else if (sendType == 2) {
                methodName = "batch_send";
                failCode = StaticValue.ERROR_310002;
            } else if (sendType == 3) {
                methodName = "multi_send";
                failCode = StaticValue.ERROR_310003;
            } else {
                Logger.getSingleton().info("\u53d1\u9001\u7c7b\u578b\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300018 + ",\u53d1\u9001\u7c7b\u578b:" + sendType);
                return StaticValue.ERROR_300018;
            }
            HttpPostBiz httpPostBiz = new HttpPostBiz();
            Message2 = httpPostBiz.executeKeepAliveNotUrlEncodePost(message, String.valueOf(requestHost) + ConfigManager.REQUEST_PATH + methodName, connObject);
            if (String.valueOf(StaticValue.ERROR_310099).equals(Message2)) {
                String oldIpAndPort = connObject.getIpAndPort();
                Account account2 = ConfigManager.accountMap.get(message.getUserid());
                String domainAndPort = null;
                boolean isMasterIpAndPort = false;
                if (account2.getIpAndPort().equals(oldIpAndPort)) {
                    isMasterIpAndPort = true;
                    domainAndPort = account2.getMasterDomainAndPort();
                } else {
                    domainAndPort = account2.getIpAndDomainBakMap().get(oldIpAndPort);
                }
                String ip = null;
                if (domainAndPort != null && !"".equals(domainAndPort.trim())) {
                    ip = connManager.getIpByDomain(domainAndPort.split(":")[0]);
                }
                boolean isNewIpSend = false;
                String newIpAndPort = null;
                if (ip != null && !"".equals(ip.trim()) && !ip.equals(oldIpAndPort.split(":")[0])) {
                    newIpAndPort = String.valueOf(ip) + ":" + oldIpAndPort.split(":")[1];
                    connObject = connManager.newconnection(connObject, connMap, newIpAndPort);
                    isNewIpSend = true;
                } else {
                    connObject = connManager.reconnection(connObject, connMap);
                }
                Message2 = httpPostBiz.executeKeepAliveNotUrlEncodePost(message, String.valueOf(requestHost) + ConfigManager.REQUEST_PATH + methodName, connObject);
                if (String.valueOf(StaticValue.ERROR_310099).equals(Message2)) {
                    connManager.handleLongConnFail(connObject, message.getUserid(), oldIpAndPort, connMap);
                    return failCode;
                }
                if (isNewIpSend) {
                    if (isMasterIpAndPort) {
                        ConfigManager.accountMap.get(account2.getUserid()).setIpAndPort(newIpAndPort);
                    } else {
                        ConfigManager.accountMap.get(account2.getUserid()).getIpAndDomainBakMap().remove(oldIpAndPort);
                        ConfigManager.accountMap.get(account2.getUserid()).getIpAndDomainBakMap().put(newIpAndPort, domainAndPort);
                        ConfigManager.accountMap.get(account2.getUserid()).getIpAndPortBak().remove(oldIpAndPort);
                        ConfigManager.accountMap.get(account2.getUserid()).getIpAndPortBak().add(newIpAndPort);
                    }
                }
            }
            connObject.setLastSendTime(Calendar.getInstance().getTimeInMillis());
            connMap.put(connObject.getIpAndPort(), connObject);
            messageBuffer.append(Message2);
            return 0;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u957f\u8fde\u63a5\u53d1\u9001\u65b9\u6cd5\u51fa\u73b0\u5931\u8d25\uff01");
            return failCode;
        }
    }

    public int sendSmsByNotKeepAlive(int sendType, Message message, StringBuffer messageBuffer, Map<String, String> availIpMap) {
        int failCode = StaticValue.ERROR_310001;
        String availableAddress = null;
        try {
            String encryptPwd;
            Account account;
            ConnManager connManager = new ConnManager();
            if (message.getUserid() != null && !"".equals(message.getUserid())) {
                if (!ValidateParamTool.validateUserId(message.getUserid())) {
                    return StaticValue.ERROR_300001;
                }
                message.setUserid(message.getUserid().trim().toUpperCase());
                account = new Account();
                availableAddress = connManager.getAddressByUserID(account, message.getUserid(), availIpMap);
                if (availableAddress == null) {
                    Logger.getSingleton().info("\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u8005\u8d26\u53f7\u4e0d\u53ef\u7528,\u9519\u8bef\u7801:" + StaticValue.ERROR_310008 + ",\u8d26\u53f7:" + message.getUserid());
                    return StaticValue.ERROR_310008;
                }
                encryptPwd = new EncryptUtil().encryptPwd(account.getUserid(), account.getPassword(), message.getTimestamp());
                if (encryptPwd == null || encryptPwd.length() < 1) {
                    return StaticValue.ERROR_300010;
                }
                message.setPwd(encryptPwd);
            } else {
                account = new Account();
                availableAddress = connManager.getAccountByPriority(account, availIpMap);
                if (account == null) {
                    Logger.getSingleton().info("\u65e0\u53ef\u7528\u7684\u8d26\u53f7,\u9519\u8bef\u7801:" + StaticValue.ERROR_310009);
                    return StaticValue.ERROR_310009;
                }
                message.setUserid(account.getUserid());
                encryptPwd = new EncryptUtil().encryptPwd(account.getUserid(), account.getPassword(), message.getTimestamp());
                message.setPwd(encryptPwd);
            }
            String requestHost = "http://" + availableAddress;
            String Message2 = null;
            String methodName = "";
            if (sendType == 1) {
                methodName = "single_send";
                failCode = StaticValue.ERROR_310001;
            } else if (sendType == 2) {
                methodName = "batch_send";
                failCode = StaticValue.ERROR_310002;
            } else if (sendType == 3) {
                methodName = "multi_send";
                failCode = StaticValue.ERROR_310003;
            } else {
                Logger.getSingleton().info("\u53d1\u9001\u7c7b\u578b\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300018 + ",\u53d1\u9001\u7c7b\u578b:" + sendType);
                return StaticValue.ERROR_300018;
            }
            Message2 = new HttpPostBiz().executeNotKeepAliveNotUrlEncodePost(message, String.valueOf(requestHost) + ConfigManager.REQUEST_PATH + methodName);
            if (String.valueOf(StaticValue.ERROR_310099).equals(Message2)) {
                connManager.handleShortConnFail(message.getUserid(), availableAddress, availIpMap);
                return failCode;
            }
            messageBuffer.append(Message2);
            return 0;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u77ed\u8fde\u63a5\u53d1\u9001\u65b9\u6cd5\u51fa\u73b0\u5931\u8d25\uff01");
            return failCode;
        }
    }

    public int getMoRptFeeByKeepAlive(int sendType, Message message, StringBuffer messageBuffer, Map<String, ConnObject> connMap) {
        int failCode = StaticValue.ERROR_310004;
        try {
            ConnManager connManager = new ConnManager();
            Account account = new Account();
            ConnObject connObject = connManager.getConnByUserID(account, message.getUserid(), connMap);
            if (connObject == null) {
                Logger.getSingleton().info("\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u8005\u8d26\u53f7\u4e0d\u53ef\u7528,\u9519\u8bef\u7801:" + StaticValue.ERROR_310008 + ",\u8d26\u53f7:" + message.getUserid());
                return StaticValue.ERROR_310008;
            }
            String encryptPwd = new EncryptUtil().encryptPwd(account.getUserid(), account.getPassword(), message.getTimestamp());
            message.setPwd(encryptPwd);
            String requestHost = "http://" + connObject.getIpAndPort();
            String Message2 = null;
            String methodName = "";
            if (sendType == 4) {
                methodName = "get_mo";
                failCode = StaticValue.ERROR_310004;
            } else if (sendType == 5) {
                methodName = "get_rpt";
                failCode = StaticValue.ERROR_310005;
            } else if (sendType == 6) {
                methodName = "get_balance";
                failCode = StaticValue.ERROR_310006;
            } else {
                Logger.getSingleton().info("\u53d1\u9001\u7c7b\u578b\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300018 + ",\u53d1\u9001\u7c7b\u578b:" + sendType);
                return StaticValue.ERROR_300018;
            }
            Message2 = new HttpPostBiz().executeKeepAlivePost(message, String.valueOf(requestHost) + ConfigManager.REQUEST_PATH + methodName, connObject);
            if (String.valueOf(StaticValue.ERROR_310099).equals(Message2)) {
                connManager.handleLongConnFail(connObject, message.getUserid(), connObject.getIpAndPort(), connMap);
                return failCode;
            }
            connObject.setLastSendTime(Calendar.getInstance().getTimeInMillis());
            connMap.put(connObject.getIpAndPort(), connObject);
            messageBuffer.append(Message2);
            return 0;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u957f\u8fde\u63a5\u83b7\u53d6\u4e0a\u884c\u3001\u72b6\u6001\u62a5\u544a\u3001\u4f59\u989d\u65b9\u6cd5\u51fa\u73b0\u5931\u8d25\uff01");
            return failCode;
        }
    }

    public int getMoRptFeeByNotKeepAlive(int sendType, Message message, StringBuffer messageBuffer, Map<String, String> availIpMap) {
        int failCode = StaticValue.ERROR_310004;
        String availableAddress = null;
        try {
            ConnManager connManager = new ConnManager();
            Account account = new Account();
            availableAddress = connManager.getAddressByUserID(account, message.getUserid(), availIpMap);
            if (availableAddress == null) {
                Logger.getSingleton().info("\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u8005\u8d26\u53f7\u4e0d\u53ef\u7528,\u9519\u8bef\u7801:" + StaticValue.ERROR_310008 + ",\u8d26\u53f7:" + message.getUserid());
                return StaticValue.ERROR_310008;
            }
            String encryptPwd = new EncryptUtil().encryptPwd(account.getUserid(), account.getPassword(), message.getTimestamp());
            message.setPwd(encryptPwd);
            String requestHost = "http://" + availableAddress;
            String Message2 = null;
            String methodName = "";
            if (sendType == 4) {
                methodName = "get_mo";
                failCode = StaticValue.ERROR_310004;
            } else if (sendType == 5) {
                methodName = "get_rpt";
                failCode = StaticValue.ERROR_310005;
            } else if (sendType == 6) {
                methodName = "get_balance";
                failCode = StaticValue.ERROR_310006;
            } else {
                Logger.getSingleton().info("\u53d1\u9001\u7c7b\u578b\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300018 + ",\u53d1\u9001\u7c7b\u578b:" + sendType);
                return StaticValue.ERROR_300018;
            }
            Message2 = new HttpPostBiz().executeNotKeepAlivePost(message, String.valueOf(requestHost) + ConfigManager.REQUEST_PATH + methodName);
            if (String.valueOf(StaticValue.ERROR_310099).equals(Message2)) {
                connManager.handleShortConnFail(message.getUserid(), availableAddress, availIpMap);
                return failCode;
            }
            messageBuffer.append(Message2);
            return 0;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u77ed\u8fde\u63a5\u83b7\u53d6\u4e0a\u884c\u3001\u72b6\u6001\u62a5\u544a\u3001\u4f59\u989d\u65b9\u6cd5\u51fa\u73b0\u5931\u8d25\uff01");
            return failCode;
        }
    }

    public String handleContent(String content) {
        try {
            if (!content.contains("\u00a5")) {
                content = URLEncoder.encode(content, "GBK");
                return content;
            }
            content = content.replace("\u00a5", "\uffe5");
            content = URLEncoder.encode(content, "GBK");
            return content;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u7f16\u7801\u77ed\u4fe1\u5185\u5bb9\u5931\u8d25\uff01\u77ed\u4fe1\u5185\u5bb9:" + content);
            return null;
        }
    }
}

