/*
 * Decompiled with CFR 0.152.
 */
package com.montnets.mwgate.smsutil;

import com.montnets.mwgate.common.Account;
import com.montnets.mwgate.common.ConnObject;
import com.montnets.mwgate.common.Logger;
import com.montnets.mwgate.common.StaticValue;
import com.montnets.mwgate.smsutil.CheckAccount;
import com.montnets.mwgate.smsutil.ConfigManager;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

public class ConnManager {
    public ConnObject getConnByUserID(Account returnAccount, String userid, Map<String, ConnObject> connMap) {
        ConnObject connObject;
        block5: {
            Account account;
            block4: {
                connObject = null;
                account = null;
                account = ConfigManager.accountMap.get(userid);
                if (account != null) break block4;
                return null;
            }
            try {
                returnAccount.setUserid(account.getUserid());
                returnAccount.setPassword(account.getPassword());
                connObject = this.getConnByConnMap(account, connMap);
                if (connObject != null) break block5;
                long checkStartTime = Calendar.getInstance().getTimeInMillis();
                String availableAddress = new CheckAccount().checkAddress(account);
                long checkEndTime = Calendar.getInstance().getTimeInMillis();
                if (availableAddress != null) {
                    Logger.getSingleton().info("\u957f\u8fde\u63a5,\u6307\u5b9a\u8d26\u53f7,\u68c0\u6d4b\u5230\u8d26\u53f7[" + account.getUserid() + "]\u53ef\u7528\u7684\u5907IP\u4fe1\u606f\u4e3a:" + availableAddress + "\u3002" + "\u68c0\u6d4b\u8017\u65f6:" + (checkEndTime - checkStartTime) + "\u6beb\u79d2\u3002");
                    connObject = this.createConn(availableAddress.split(":")[0], Integer.parseInt(availableAddress.split(":")[1]), connMap);
                    break block5;
                }
                return null;
            }
            catch (Exception e) {
                Logger.getSingleton().error(e, "\u6839\u636e\u53d1\u9001\u8d26\u53f7\u83b7\u53d6\u8fde\u63a5\u5bf9\u8c61\u5931\u8d25,\u53d1\u9001\u8d26\u53f7:" + userid);
            }
        }
        return connObject;
    }

    public ConnObject getConnByPriority(Map<String, ConnObject> connMap, Account returnAccount) {
        ConcurrentHashMap<String, List<String>> priorityAccountMap;
        Account account;
        ConnObject connObject;
        block13: {
            block12: {
                connObject = null;
                account = null;
                if (ConfigManager.accountMap != null && ConfigManager.accountMap.size() != 0) break block12;
                return null;
            }
            priorityAccountMap = new ConcurrentHashMap<String, List<String>>();
            priorityAccountMap.putAll(ConfigManager.priorityAccountMap);
            if (priorityAccountMap != null && priorityAccountMap.size() != 0) break block13;
            return null;
        }
        try {
            int i = 1;
            while (i < 10) {
                List accountList = (List)priorityAccountMap.get(String.valueOf(i));
                if (accountList != null && accountList.size() > 0) {
                    int j = 0;
                    while (j < accountList.size()) {
                        account = ConfigManager.accountMap.get(accountList.get(j));
                        connObject = this.getConnByConnMap(account, connMap);
                        if (connObject != null) {
                            returnAccount.setUserid(account.getUserid());
                            returnAccount.setPassword(account.getPassword());
                            return connObject;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            CheckAccount checkAccount = new CheckAccount();
            long checkStartTime = Calendar.getInstance().getTimeInMillis();
            int i2 = 1;
            while (i2 < 10) {
                List accountList = (List)priorityAccountMap.get(String.valueOf(i2));
                if (accountList != null && accountList.size() > 0) {
                    int j = 0;
                    while (j < accountList.size()) {
                        account = ConfigManager.accountMap.get(accountList.get(j));
                        String availableAddress = checkAccount.checkAddress(account);
                        long checkEndTime = Calendar.getInstance().getTimeInMillis();
                        if (availableAddress != null) {
                            Logger.getSingleton().info("\u957f\u8fde\u63a5,\u4e0d\u6307\u5b9a\u8d26\u53f7\uff0c\u68c0\u6d4b\u5230\u8d26\u53f7[" + account.getUserid() + "]\u53ef\u7528\u7684\u5907IP\u4fe1\u606f\u4e3a:" + availableAddress + "\u3002" + "\u68c0\u6d4b\u8017\u65f6:" + (checkEndTime - checkStartTime) + "\u6beb\u79d2\u3002");
                            returnAccount.setUserid(account.getUserid());
                            returnAccount.setPassword(account.getPassword());
                            connObject = this.createConn(availableAddress.split(":")[0], Integer.parseInt(availableAddress.split(":")[1]), connMap);
                            return connObject;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }
        catch (Exception e) {
            connObject = null;
            Logger.getSingleton().error(e, "\u6839\u636e\u8d26\u53f7\u4f18\u5148\u7ea7\u83b7\u53d6\u8fde\u63a5\u5bf9\u8c61\u5931\u8d25\uff01");
        }
        return connObject;
    }

    public String getAddressByUserID(Account returnAccount, String userid, Map<String, String> availIpMap) {
        Account account;
        block9: {
            account = null;
            account = ConfigManager.accountMap.get(userid);
            if (account != null) break block9;
            return null;
        }
        try {
            returnAccount.setUserid(account.getUserid());
            returnAccount.setPassword(account.getPassword());
            String ipAndPort = account.getIpAndPort();
            List<String> ipAndPortBak = account.getIpAndPortBak();
            if (account.getMasterIPState() == 0) {
                if (!availIpMap.containsKey(ipAndPort)) {
                    Logger.getSingleton().info("\u77ed\u8fde\u63a5,\u6307\u5b9a\u8d26\u53f7,\u4f7f\u7528\u8d26\u53f7[" + account.getUserid() + "]\u7684\u4e3bIP\u4fe1\u606f[" + account.getIpAndPort() + "]\u7b2c\u4e00\u6b21\u8bf7\u6c42\u7f51\u5173\u6216\u8005\u4e3bIP\u6062\u590d\u6b63\u5e38\uff0c\u4f7f\u7528\u4e3bIP\u8bf7\u6c42\u7f51\u5173\u3002");
                    availIpMap.put(ipAndPort, "");
                }
                return ipAndPort;
            }
            if (ipAndPortBak != null && ipAndPortBak.size() > 0) {
                int i = 0;
                while (i < ipAndPortBak.size()) {
                    if (availIpMap.containsKey(ipAndPortBak.get(i))) {
                        return ipAndPortBak.get(i);
                    }
                    ++i;
                }
            }
            long checkStartTime = Calendar.getInstance().getTimeInMillis();
            String availableAddress = new CheckAccount().checkAddress(account);
            long checkEndTime = Calendar.getInstance().getTimeInMillis();
            if (availableAddress != null) {
                Logger.getSingleton().info("\u77ed\u8fde\u63a5,\u6307\u5b9a\u8d26\u53f7,\u68c0\u6d4b\u5230\u8d26\u53f7[" + account.getUserid() + "]\u53ef\u7528\u7684\u5907IP\u4fe1\u606f\u4e3a:" + availableAddress + "\u3002" + "\u68c0\u6d4b\u8017\u65f6:" + (checkEndTime - checkStartTime) + "\u6beb\u79d2\u3002");
                availIpMap.put(availableAddress, "");
                return availableAddress;
            }
            return null;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u6839\u636e\u53d1\u9001\u8d26\u53f7\u83b7\u53d6\u8be5\u8d26\u53f7\u53ef\u7528\u7684\u5730\u5740\u4fe1\u606f\u5931\u8d25,\u53d1\u9001\u8d26\u53f7\uff1a" + userid);
            return null;
        }
    }

    public String getAccountByPriority(Account returnAccount, Map<String, String> availIpMap) {
        ConcurrentHashMap<String, List<String>> priorityAccountMap;
        List<Object> ipAndPortBak;
        Account account;
        block17: {
            block16: {
                account = null;
                ipAndPortBak = new ArrayList();
                if (ConfigManager.accountMap != null && ConfigManager.accountMap.size() != 0) break block16;
                return null;
            }
            priorityAccountMap = new ConcurrentHashMap<String, List<String>>();
            priorityAccountMap.putAll(ConfigManager.priorityAccountMap);
            if (priorityAccountMap != null && priorityAccountMap.size() != 0) break block17;
            return null;
        }
        try {
            int i = 1;
            while (i < 10) {
                List accountList = (List)priorityAccountMap.get(String.valueOf(i));
                if (accountList != null && accountList.size() > 0) {
                    int j = 0;
                    while (j < accountList.size()) {
                        account = ConfigManager.accountMap.get(accountList.get(j));
                        if (account.getMasterIPState() == 0) {
                            if (!availIpMap.containsKey(account.getIpAndPort())) {
                                Logger.getSingleton().info("\u77ed\u8fde\u63a5,\u4e0d\u6307\u5b9a\u8d26\u53f7,\u4f7f\u7528\u8d26\u53f7[" + account.getUserid() + "]\u7684\u4e3bIP\u4fe1\u606f[" + account.getIpAndPort() + "]\u7b2c\u4e00\u6b21\u8bf7\u6c42\u7f51\u5173\u6216\u8005\u4e3bIP\u6062\u590d\u6b63\u5e38\uff0c\u4f7f\u7528\u4e3bIP\u8bf7\u6c42\u7f51\u5173\u3002");
                                availIpMap.put(account.getIpAndPort(), "");
                            }
                            returnAccount.setUserid(account.getUserid());
                            returnAccount.setPassword(account.getPassword());
                            return account.getIpAndPort();
                        }
                        ipAndPortBak = account.getIpAndPortBak();
                        if (ipAndPortBak != null && ipAndPortBak.size() > 0) {
                            int k = 0;
                            while (k < ipAndPortBak.size()) {
                                if (availIpMap.containsKey(ipAndPortBak.get(k))) {
                                    returnAccount.setUserid(account.getUserid());
                                    returnAccount.setPassword(account.getPassword());
                                    return (String)ipAndPortBak.get(k);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            CheckAccount checkAccount = new CheckAccount();
            long checkStartTime = Calendar.getInstance().getTimeInMillis();
            int i2 = 1;
            while (i2 < 10) {
                List accountList = (List)priorityAccountMap.get(String.valueOf(i2));
                if (accountList != null && accountList.size() > 0) {
                    int j = 0;
                    while (j < accountList.size()) {
                        account = ConfigManager.accountMap.get(accountList.get(j));
                        String availableAddress = checkAccount.checkAddress(account);
                        long checkEndTime = Calendar.getInstance().getTimeInMillis();
                        if (availableAddress != null) {
                            Logger.getSingleton().info("\u77ed\u8fde\u63a5,\u4e0d\u6307\u5b9a\u8d26\u53f7\uff0c\u68c0\u6d4b\u5230\u8d26\u53f7[" + account.getUserid() + "]\u53ef\u7528\u7684\u5907IP\u4fe1\u606f\u4e3a:" + availableAddress + "\u3002" + "\u68c0\u6d4b\u8017\u65f6:" + (checkEndTime - checkStartTime) + "\u6beb\u79d2\u3002");
                            availIpMap.put(availableAddress, "");
                            returnAccount.setUserid(account.getUserid());
                            returnAccount.setPassword(account.getPassword());
                            return availableAddress;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            return null;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u6309\u7167\u8d26\u53f7\u4f18\u5148\u7ea7\u83b7\u53d6\u8be5\u8d26\u53f7\u53ef\u7528\u7684\u5730\u5740\u4fe1\u606f\u5931\u8d25\uff01");
            return null;
        }
    }

    public void handleShortConnFail(String userId, String address, Map<String, String> availIpMap) {
        try {
            availIpMap.remove(address);
            Account account = ConfigManager.accountMap.get(userId);
            if (address.equals(account.getIpAndPort())) {
                account.setMasterIPState(1);
                ConfigManager.exceptionAccountMap.put(userId, account);
                this.logMasterIPError("\u77ed\u8fde\u63a5", userId, address, account.getIpAndPortBak());
            } else {
                Logger.getSingleton().info("\u77ed\u8fde\u63a5,\u8d26\u53f7[" + userId + "]\u7684\u5907IP[" + address.split(":")[0] + "],\u7aef\u53e3\uff1a" + address.split(":")[1] + "\u5f02\u5e38\u3002");
            }
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u5904\u7406\u77ed\u8fde\u63a5\u5931\u8d25\u7684\u60c5\u51b5\u5931\u8d25,userId\uff1a" + userId + ",address:" + address);
        }
    }

    public void handleLongConnFail(ConnObject connObject, String userId, String address, Map<String, ConnObject> connMap) {
        try {
            connMap.remove(connObject.getIpAndPort());
            Account account = ConfigManager.accountMap.get(userId);
            if (address.equals(account.getIpAndPort())) {
                account.setMasterIPState(1);
                ConfigManager.exceptionAccountMap.put(userId, account);
                this.logMasterIPError("\u957f\u8fde\u63a5", userId, address, account.getIpAndPortBak());
            } else {
                Logger.getSingleton().info("\u957f\u8fde\u63a5,\u8d26\u53f7[" + userId + "]\u7684\u5907IP[" + address.split(":")[0] + "],\u7aef\u53e3\uff1a" + address.split(":")[1] + "\u5f02\u5e38\u3002");
            }
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u5904\u7406\u957f\u8fde\u63a5\u5931\u8d25\u7684\u60c5\u51b5\u5931\u8d25,userId:" + userId + ",address:" + connObject.getIpAndPort());
        }
    }

    private void logMasterIPError(String connTypeStr, String userid, String address, List<String> ipAndPortBak) {
        try {
            String info = "";
            if (ipAndPortBak != null && ipAndPortBak.size() > 0) {
                String ipAndPortBakStr = "";
                int i = 0;
                while (i < ipAndPortBak.size()) {
                    ipAndPortBakStr = String.valueOf(ipAndPortBakStr) + ipAndPortBak.get(i) + ",";
                    ++i;
                }
                info = "\u8be5\u8d26\u53f7\u6709\u5907IP,\u5907IP\u4fe1\u606f\u4e3a" + ipAndPortBakStr + "\u5c06\u5207\u6362\u5230\u5907IP\u3002\u5f85\u4e3bIP\u6062\u590d\u6b63\u5e38\u540e\uff0c\u518d\u5207\u6362\u56de\u4e3bIP\u3002";
            } else {
                info = "\u8be5\u8d26\u53f7\u6ca1\u6709\u5907IP,\u4e3bIP\u6062\u590d\u53ef\u7ee7\u7eed\u53d1\u9001\u548c\u83b7\u53d6\u3002";
            }
            Logger.getSingleton().info(String.valueOf(connTypeStr) + ",\u8d26\u53f7[" + userid + "]\u7684\u4e3bIP[" + address.split(":")[0] + "],\u7aef\u53e3\uff1a" + address.split(":")[1] + "\u5f02\u5e38,\u5c06\u6dfb\u52a0\u5230\u5f02\u5e38\u4e3bIP\u96c6\u5408\u4e2d\u68c0\u6d4b\u3002" + info);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ConnObject reconnection(ConnObject connObject, Map<String, ConnObject> connMap) {
        ConnObject newConnObject = null;
        try {
            if (connObject.getHttpClient() != null && connObject.getHttpClient().getConnectionManager() != null) {
                connObject.getHttpClient().getConnectionManager().closeExpiredConnections();
                connObject.getHttpClient().getConnectionManager().shutdown();
            }
            String[] ipAndPort = connObject.getIpAndPort().split(":");
            newConnObject = this.createConn(ipAndPort[0], Integer.parseInt(ipAndPort[1]), connMap);
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u63d0\u4ea4\u5931\u8d25\u540e\uff0c\u957f\u8fde\u63a5\u91cd\u65b0\u8fde\u63a5\u5931\u8d25,address:" + connObject.getIpAndPort());
            newConnObject = null;
        }
        return newConnObject;
    }

    private boolean isConnTimeOut(ConnObject connObject) {
        try {
            return Calendar.getInstance().getTimeInMillis() - connObject.getLastSendTime() > StaticValue.SPARE_TIMEOUT;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u68c0\u67e5\u957f\u8fde\u63a5\u662f\u5426\u8d85\u65f6\u5931\u8d25,address:" + connObject.getIpAndPort());
            return true;
        }
    }

    private ConnObject getConnByConnMap(Account account, Map<String, ConnObject> connMap) {
        ConnObject connObject = null;
        try {
            if (account.getMasterIPState() == 0) {
                connObject = connMap.get(account.getIpAndPort());
                if (connObject == null) {
                    Logger.getSingleton().info("\u957f\u8fde\u63a5,\u4f7f\u7528\u8d26\u53f7[" + account.getUserid() + "]\u7684\u4e3bIP\u4fe1\u606f[" + account.getIpAndPort() + "]\u7b2c\u4e00\u6b21\u8bf7\u6c42\u7f51\u5173\u6216\u8005\u4e3bIP\u6062\u590d\u6b63\u5e38\uff0c\u4f7f\u7528\u4e3bIP\u8bf7\u6c42\u7f51\u5173\u3002");
                    String[] ipAndPort = account.getIpAndPort().split(":");
                    connObject = this.createConn(ipAndPort[0], Integer.parseInt(ipAndPort[1]), connMap);
                    return connObject;
                }
                if (this.isConnTimeOut(connObject)) {
                    connObject = this.reconnection(connObject, connMap);
                }
                return connObject;
            }
            List<String> ipAndPortBakList = account.getIpAndPortBak();
            connObject = null;
            int i = 0;
            while (i < ipAndPortBakList.size()) {
                connObject = connMap.get(ipAndPortBakList.get(i));
                if (connObject != null) {
                    if (this.isConnTimeOut(connObject)) {
                        connObject = this.reconnection(connObject, connMap);
                    }
                    return connObject;
                }
                ++i;
            }
            return connObject;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u6839\u636e\u8d26\u53f7\u4ece\u8fde\u63a5\u5bf9\u8c61\u96c6\u5408\u83b7\u53d6\u8fde\u63a5\u5931\u8d25,\u53d1\u9001\u8d26\u53f7:" + account.getUserid());
            return connObject;
        }
    }

    private ConnObject createConn(String ip, int port, Map<String, ConnObject> connMap) {
        ConnObject connObject = null;
        try {
            connObject = new ConnObject();
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpHost httpHost = new HttpHost(ip, port);
            httpClient.getParams().setParameter("http.connection.timeout", (Object)StaticValue.HTTP_REQUEST_TIMEOUT);
            httpClient.getParams().setParameter("http.socket.timeout", (Object)StaticValue.HTTP_RESPONSE_TIMEOUT);
            connObject.setHttpClient((HttpClient)httpClient);
            connObject.setHttpHost(httpHost);
            connObject.setIpAndPort(String.valueOf(ip) + ":" + port);
            connObject.setLastSendTime(Calendar.getInstance().getTimeInMillis());
            connMap.put(String.valueOf(ip) + ":" + port, connObject);
        }
        catch (Exception e) {
            connObject = null;
            Logger.getSingleton().error(e, "\u521b\u5efa\u957f\u8fde\u63a5\u5931\u8d25,IP:" + ip + ",\u7aef\u53e3:" + port);
        }
        return connObject;
    }

    public String getIpByDomain(String domain) {
        String ip = null;
        try {
            ip = InetAddress.getByName(domain).getHostAddress();
        }
        catch (Exception e) {
            ip = null;
        }
        return ip;
    }

    public ConnObject newconnection(ConnObject connObject, Map<String, ConnObject> connMap, String newIpAndPort) {
        ConnObject newConnObject = null;
        try {
            if (connObject.getHttpClient() != null && connObject.getHttpClient().getConnectionManager() != null) {
                connObject.getHttpClient().getConnectionManager().closeExpiredConnections();
                connObject.getHttpClient().getConnectionManager().shutdown();
            }
            connMap.remove(connObject.getIpAndPort());
            String[] ipAndPort = newIpAndPort.split(":");
            newConnObject = this.createConn(ipAndPort[0], Integer.parseInt(ipAndPort[1]), connMap);
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u63d0\u4ea4\u5931\u8d25\u540e\uff0c\u5173\u95ed\u5931\u8d25\u7684\u957f\u8fde\u63a5\uff0c\u7528\u65b0\u7684IP\uff0c\u521b\u5efa\u65b0\u7684\u8fde\u63a5\u5931\u8d25,\u8001\u7684\u5730\u5740\u4fe1\u606f:" + connObject.getIpAndPort() + ",\u65b0\u5730\u5740\u4fe1\u606f:" + newIpAndPort);
            newConnObject = null;
        }
        return newConnObject;
    }
}

