/*
 * Decompiled with CFR 0.152.
 */
package com.montnets.mwgate.smsutil;

import com.montnets.mwgate.common.Account;
import com.montnets.mwgate.common.GlobalParams;
import com.montnets.mwgate.common.Logger;
import com.montnets.mwgate.common.StaticValue;
import com.montnets.mwgate.common.ValidateParamTool;
import com.montnets.mwgate.smsutil.CheckAccountThread;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class ConfigManager {
    public static Map<String, Account> accountMap = new ConcurrentHashMap<String, Account>();
    public static Map<String, Account> exceptionAccountMap = new ConcurrentHashMap<String, Account>();
    private static CheckAccountThread checkAccountThread = new CheckAccountThread();
    public static Map<String, List<String>> priorityAccountMap = new ConcurrentHashMap<String, List<String>>();
    public static String REQUEST_PATH = "/sms/v2/std/";
    public static int NEED_LOG = 1;

    public static int setGlobalParams(GlobalParams globalParams) {
        try {
            if (globalParams.getRequestPath() == null || "".equals(globalParams.getRequestPath().trim())) {
                Logger.getSingleton().info("\u8bf7\u6c42\u8def\u5f84\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300021 + ",\u8bf7\u6c42\u8def\u5f84\u4e3a\u7a7a\u3002");
                return StaticValue.ERROR_300021;
            }
            REQUEST_PATH = globalParams.getRequestPath();
            if (globalParams.getNeedLog() != 0 && globalParams.getNeedLog() != 1) {
                Logger.getSingleton().info("\u662f\u5426\u9700\u8981\u65e5\u5fd7\u8bbe\u7f6e\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300023 + ",needLog:" + globalParams.getNeedLog());
                return StaticValue.ERROR_300023;
            }
            NEED_LOG = globalParams.getNeedLog();
            if (NEED_LOG == StaticValue.STATIC_NEED_LOG) {
                Logger.getSingleton().init("./SmsSdkLog/", 2024);
            }
            return 0;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u8bbe\u7f6e\u5168\u5c40\u53c2\u6570\u5931\u8d25,\u8bf7\u6c42\u8def\u5f84:" + globalParams.getRequestPath() + ",\u662f\u5426\u9700\u8981\u65e5\u5fd7:" + globalParams.getNeedLog());
            return StaticValue.ERROR_310012;
        }
    }

    public static int setAccountInfo(String userid, String pwd, int priority, String ipAddress1, String ipAddress2, String ipAddress3, String ipAddress4) {
        try {
            Account account = new Account();
            if (!ValidateParamTool.validateUserId(userid)) {
                return StaticValue.ERROR_300001;
            }
            userid = userid.trim().toUpperCase();
            account.setUserid(userid);
            if (!ValidateParamTool.validatePwd(pwd)) {
                return StaticValue.ERROR_300002;
            }
            account.setPassword(pwd);
            if (priority < 1 || priority > 9) {
                Logger.getSingleton().info("\u9a8c\u8bc1\u53d1\u9001\u4f18\u5148\u7ea7\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300013 + ",\u53d1\u9001\u4f18\u5148\u7ea7:" + priority);
                return StaticValue.ERROR_300013;
            }
            account.setPriority(priority);
            ipAddress1 = ConfigManager.addPortForAddress(ipAddress1);
            int errorCode = ValidateParamTool.validateIpAndPort(ipAddress1);
            if (errorCode != 0) {
                return errorCode;
            }
            boolean ipAddressIsDomain = ConfigManager.isDomain(ipAddress1.split(":")[0]);
            if (ipAddressIsDomain) {
                String ip = ConfigManager.getIpByDomain(ipAddress1.split(":")[0]);
                if (ip != null && !"".equals(ip.trim())) {
                    Logger.getSingleton().info("\u8bbe\u7f6e\u53d1\u9001\u8d26\u53f7[" + userid + "]\u4fe1\u606f\u65f6,\u901a\u8fc7\u4e3b\u57df\u540d[" + ipAddress1.split(":")[0] + "]\u83b7\u53d6\u5230\u4e3bIP[" + ip + "],\u7aef\u53e3:" + ipAddress1.split(":")[1]);
                    account.setIpAndPort(String.valueOf(ip) + ":" + ipAddress1.split(":")[1]);
                    account.setMasterDomainAndPort(ipAddress1);
                } else {
                    Logger.getSingleton().info("\u8bbe\u7f6e\u53d1\u9001\u8d26\u53f7[" + userid + "]\u4fe1\u606f\u65f6,\u901a\u8fc7\u4e3b\u57df\u540d[" + ipAddress1.split(":")[0] + "]\u83b7\u53d6\u4e3bIP\u5931\u8d25,\u7aef\u53e3:" + ipAddress1.split(":")[1]);
                    account.setIpAndPort(ipAddress1);
                    account.setMasterDomainAndPort(ipAddress1);
                }
            } else {
                account.setIpAndPort(ipAddress1);
            }
            List<String> ipAndPortBak = account.getIpAndPortBak();
            Map<String, String> ipAndDomainBakMap = account.getIpAndDomainBakMap();
            errorCode = ConfigManager.validateIpAndPortBak(ipAndPortBak, ipAndDomainBakMap, ipAddress2, ipAddress3, ipAddress4, userid);
            if (errorCode != 0) {
                return errorCode;
            }
            account.setIpAndPortBak(ipAndPortBak);
            account.setIpAndDomainBakMap(ipAndDomainBakMap);
            account.setMasterIPState(0);
            if (exceptionAccountMap.containsKey(account.getUserid())) {
                exceptionAccountMap.remove(account.getUserid());
                Logger.getSingleton().info("\u8981\u65b0\u6dfb\u52a0\u7684\u8d26\u53f7\u5728\u5f02\u5e38\u8d26\u53f7\u96c6\u5408\u4e2d\u5b58\u5728,\u5c06\u6b64\u8d26\u53f7\u4ece\u5f02\u5e38\u96c6\u5408\u4e2d\u79fb\u9664,\u8d26\u53f7:" + userid);
            }
            accountMap.put(userid, account);
            priorityAccountMap = ConfigManager.getPriorityAccountMap();
            errorCode = ConfigManager.start();
            return errorCode;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u8bbe\u7f6e\u53d1\u9001\u8d26\u53f7\u4fe1\u606f\u5931\u8d25\uff01userid:" + userid + ",priority:" + priority + "," + "ipAddress1:" + ipAddress1 + ",ipAddress2:" + ipAddress2 + ",ipAddress3:" + ipAddress3 + ",ipAddress4:" + ipAddress4);
            return StaticValue.ERROR_310007;
        }
    }

    public static int removeAccount(String userid) {
        block6: {
            try {
                if (!ValidateParamTool.validateUserId(userid)) {
                    return StaticValue.ERROR_300001;
                }
                if (!accountMap.containsKey(userid = userid.trim().toUpperCase())) break block6;
                accountMap.remove(userid);
                if (exceptionAccountMap.containsKey(userid)) {
                    exceptionAccountMap.remove(userid);
                }
                priorityAccountMap = ConfigManager.getPriorityAccountMap();
                return 0;
            }
            catch (Exception e) {
                Logger.getSingleton().error(e, "\u6839\u636e\u8d26\u53f7\u540d\u79fb\u9664\u8d26\u53f7\u5931\u8d25,userid:" + userid);
                return StaticValue.ERROR_310013;
            }
        }
        if (exceptionAccountMap.containsKey(userid)) {
            exceptionAccountMap.remove(userid);
        }
        Logger.getSingleton().info("\u8be5\u8d26\u53f7\u5728\u8d26\u53f7\u5217\u8868\u4e0d\u5b58\u5728,\u65e0\u9700\u79fb\u9664,\u9519\u8bef\u7801:" + StaticValue.ERROR_310014 + ",\u8d26\u53f7:" + userid);
        return StaticValue.ERROR_310014;
    }

    public static int start() {
        try {
            if (checkAccountThread != null) {
                return checkAccountThread.startThread();
            }
            return StaticValue.ERROR_310010;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u542f\u52a8\u68c0\u67e5\u8d26\u53f7\u7ebf\u7a0b\u65b9\u6cd5\u5931\u8d25\uff01");
            return StaticValue.ERROR_310010;
        }
    }

    public static int stop() {
        try {
            return checkAccountThread.stopThread();
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u505c\u6b62\u68c0\u67e5\u8d26\u53f7\u7ebf\u7a0b\u65b9\u6cd5\u5931\u8d25\uff01");
            return StaticValue.ERROR_310011;
        }
    }

    private static int validateIpAndPortBak(List<String> ipAndPortBak, Map<String, String> ipAndDomainBakMap, String ipAddress2, String ipAddress3, String ipAddress4, String userid) {
        try {
            if (ipAddress2 != null && !"".equals(ipAddress2.trim())) {
                int errorCode2 = ValidateParamTool.validateIpAndPort(ipAddress2 = ConfigManager.addPortForAddress(ipAddress2));
                if (errorCode2 != 0) {
                    return errorCode2;
                }
                ConfigManager.setBakAddress(ipAndPortBak, ipAndDomainBakMap, ipAddress2, userid);
            }
            if (ipAddress3 != null && !"".equals(ipAddress3.trim())) {
                int errorCode3 = ValidateParamTool.validateIpAndPort(ipAddress3 = ConfigManager.addPortForAddress(ipAddress3));
                if (errorCode3 != 0) {
                    return errorCode3;
                }
                ConfigManager.setBakAddress(ipAndPortBak, ipAndDomainBakMap, ipAddress3, userid);
            }
            if (ipAddress4 != null && !"".equals(ipAddress4.trim())) {
                int errorCode4 = ValidateParamTool.validateIpAndPort(ipAddress4 = ConfigManager.addPortForAddress(ipAddress4));
                if (errorCode4 != 0) {
                    return errorCode4;
                }
                ConfigManager.setBakAddress(ipAndPortBak, ipAndDomainBakMap, ipAddress4, userid);
            }
            return 0;
        }
        catch (Exception e) {
            ipAndPortBak.clear();
            Logger.getSingleton().error(e, "\u9a8c\u8bc1\u5907\u7528IP\u548c\u7aef\u53e3\u4fe1\u606f\u7684\u65b9\u6cd5\u5931\u8d25,ipAddress2:" + ipAddress2 + ",ipAddress3:" + ipAddress3 + ",ipAddress4:" + ipAddress4);
            return StaticValue.ERROR_300003;
        }
    }

    private static Map<String, List<String>> getPriorityAccountMap() {
        ConcurrentHashMap<String, ArrayList<String>> priorityAccountMap = null;
        try {
            ConcurrentHashMap<String, Account> tempAccountMap = new ConcurrentHashMap<String, Account>();
            tempAccountMap.putAll(accountMap);
            priorityAccountMap = new ConcurrentHashMap<String, ArrayList<String>>();
            Account mapValue = null;
            ArrayList<String> accountList = null;
            Iterator iter = tempAccountMap.entrySet().iterator();
            while (iter.hasNext()) {
                mapValue = (Account)iter.next().getValue();
                int priority = mapValue.getPriority();
                accountList = (ArrayList<String>)priorityAccountMap.get(String.valueOf(priority));
                if (accountList == null) {
                    accountList = new ArrayList<String>();
                }
                accountList.add(mapValue.getUserid());
                priorityAccountMap.put(String.valueOf(priority), accountList);
            }
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u83b7\u53d6\u6309\u7167\u4f18\u5148\u7ea7\u6392\u5e8f\u7684MAP\u7684\u65b9\u6cd5\u5931\u8d25\uff01");
        }
        return priorityAccountMap;
    }

    private static void setBakAddress(List<String> ipAndPortBak, Map<String, String> ipAndDomainBakMap, String ipAddress, String userid) throws Exception {
        boolean ipAddressIsDomain = ConfigManager.isDomain(ipAddress.split(":")[0]);
        if (ipAddressIsDomain) {
            String ip = ConfigManager.getIpByDomain(ipAddress.split(":")[0]);
            if (ip != null && !"".equals(ip.trim())) {
                Logger.getSingleton().info("\u8bbe\u7f6e\u53d1\u9001\u8d26\u53f7[" + userid + "]\u4fe1\u606f\u65f6,\u901a\u8fc7\u5907\u57df\u540d[" + ipAddress.split(":")[0] + "]\u83b7\u53d6\u5230\u5907IP[" + ip + "],\u7aef\u53e3:" + ipAddress.split(":")[1]);
                ipAndPortBak.add(String.valueOf(ip) + ":" + ipAddress.split(":")[1]);
                ipAndDomainBakMap.put(String.valueOf(ip) + ":" + ipAddress.split(":")[1], ipAddress);
            } else {
                Logger.getSingleton().info("\u8bbe\u7f6e\u53d1\u9001\u8d26\u53f7[" + userid + "]\u4fe1\u606f\u65f6,\u901a\u8fc7\u5907\u57df\u540d[" + ipAddress.split(":")[0] + "]\u83b7\u53d6\u5907IP\u5931\u8d25,\u7aef\u53e3:" + ipAddress.split(":")[1]);
                ipAndPortBak.add(ipAddress);
                ipAndDomainBakMap.put(ipAddress, ipAddress);
            }
        } else {
            ipAndPortBak.add(ipAddress);
        }
    }

    private static String getIpByDomain(String domain) {
        String ip = null;
        try {
            ip = InetAddress.getByName(domain).getHostAddress();
        }
        catch (Exception e) {
            ip = null;
            Logger.getSingleton().error(e, "\u901a\u8fc7\u57df\u540d\u83b7\u53d6IP\u5931\u8d25,\u57df\u540d:" + domain);
        }
        return ip;
    }

    private static String addPortForAddress(String address) {
        try {
            if (address != null && !"".equals(address.trim()) && !address.contains(":")) {
                address = String.valueOf(address) + ":" + StaticValue.HTTP_DEFAULT_PORT;
            }
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u5730\u5740\u6ca1\u6709\u7aef\u53e3\uff0c\u6dfb\u52a0\u9ed8\u8ba4\u7aef\u53e3\u5931\u8d25\uff01\u5730\u5740:" + address);
        }
        return address;
    }

    private static boolean isDomain(String address) {
        boolean isDomain = false;
        try {
            isDomain = Pattern.compile("[a-zA-Z]").matcher(address).find();
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u5224\u65ad\u662f\u5426\u662f\u57df\u540d\u5931\u8d25,address:" + address);
        }
        return isDomain;
    }
}

