/*
 * Decompiled with CFR 0.152.
 */
package com.montnets.mwgate.common;

import com.montnets.mwgate.common.Logger;
import com.montnets.mwgate.common.StaticValue;
import java.util.regex.Pattern;

public class ValidateParamTool {
    public static boolean validateUserId(String userid) {
        block3: {
            try {
                if (userid == null || userid.trim().length() <= 0 || userid.trim().length() > 16) break block3;
                return true;
            }
            catch (Exception e) {
                Logger.getSingleton().error(e, "\u9a8c\u8bc1\u8d26\u53f7\u662f\u5426\u5408\u6cd5\u5931\u8d25,\u8d26\u53f7:" + userid);
                return false;
            }
        }
        Logger.getSingleton().info("\u9a8c\u8bc1\u8d26\u53f7\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300001 + ",\u8d26\u53f7:" + userid);
        return false;
    }

    public static boolean validatePwd(String pwd) {
        block3: {
            try {
                if (pwd == null || pwd.length() <= 0 || pwd.length() > 32) break block3;
                return true;
            }
            catch (Exception e) {
                Logger.getSingleton().error(e, "\u9a8c\u8bc1\u5bc6\u7801\u662f\u5426\u5408\u6cd5\u5931\u8d25\u3002");
                return false;
            }
        }
        String pwdStr = "";
        pwdStr = pwd == null ? "\u5bc6\u7801\u4e3a\u7a7a\u3002" : "\u5bc6\u7801\u957f\u5ea6\u4e3a" + pwd.length() + "\u3002";
        Logger.getSingleton().info("\u9a8c\u8bc1\u5bc6\u7801\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300002 + "\u3002" + pwdStr);
        return false;
    }

    public static boolean validateCustId(String custId) {
        block6: {
            block7: {
                block5: {
                    try {
                        if (custId != null && !"".equals(custId)) break block5;
                        return true;
                    }
                    catch (Exception e) {
                        Logger.getSingleton().error(e, "\u9a8c\u8bc1\u6d41\u6c34\u53f7\u662f\u5426\u5408\u6cd5\u5931\u8d25,\u6d41\u6c34\u53f7:" + custId);
                        return false;
                    }
                }
                if (custId.length() <= 0 || custId.length() > 64) break block6;
                if (!Pattern.compile("^[0-9a-zA-Z-_]+$").matcher(custId).find()) break block7;
                return true;
            }
            Logger.getSingleton().info("\u9a8c\u8bc1\u6d41\u6c34\u53f7\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300009 + ",\u6d41\u6c34\u53f7:" + custId);
            return false;
        }
        Logger.getSingleton().info("\u9a8c\u8bc1\u6d41\u6c34\u53f7\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300009 + ",\u6d41\u6c34\u53f7:" + custId);
        return false;
    }

    public static boolean validateSvrType(String svrType) {
        block6: {
            block7: {
                block5: {
                    try {
                        if (svrType != null && !"".equals(svrType)) break block5;
                        return true;
                    }
                    catch (Exception e) {
                        Logger.getSingleton().error(e, "\u9a8c\u8bc1\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u5408\u6cd5\u5931\u8d25,\u4e1a\u52a1\u7c7b\u578b:" + svrType);
                        return false;
                    }
                }
                if (svrType.length() <= 0 || svrType.length() > 32) break block6;
                if (!Pattern.compile("^[0-9a-zA-Z]+$").matcher(svrType).find()) break block7;
                return true;
            }
            Logger.getSingleton().info("\u9a8c\u8bc1\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300011 + ",\u4e1a\u52a1\u7c7b\u578b:" + svrType);
            return false;
        }
        Logger.getSingleton().info("\u9a8c\u8bc1\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300011 + ",\u4e1a\u52a1\u7c7b\u578b:" + svrType);
        return false;
    }

    public static boolean validateExData(String exData) {
        block6: {
            block7: {
                block5: {
                    try {
                        if (exData != null && !"".equals(exData)) break block5;
                        return true;
                    }
                    catch (Exception e) {
                        Logger.getSingleton().error(e, "\u9a8c\u8bc1\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e\u662f\u5426\u5408\u6cd5\u5931\u8d25,\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e:" + exData);
                        return false;
                    }
                }
                if (exData.length() <= 0 || exData.length() > 64) break block6;
                if (!Pattern.compile("^[0-9a-zA-Z-_]+$").matcher(exData).find()) break block7;
                return true;
            }
            Logger.getSingleton().info("\u9a8c\u8bc1\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300012 + ",\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e:" + exData);
            return false;
        }
        Logger.getSingleton().info("\u9a8c\u8bc1\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300012 + ",\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e:" + exData);
        return false;
    }

    public static boolean validateMessage(String content) {
        block8: {
            block9: {
                block10: {
                    try {
                        if (content == null || "".equals(content.trim())) break block8;
                        boolean isChinese = false;
                        if ((content = content.trim()) == null || content.length() <= 0) break block9;
                        int msgLen = content.length();
                        int i = 0;
                        while (i < msgLen) {
                            char msgChar = content.charAt(i);
                            if (msgChar > '\u007f') {
                                isChinese = true;
                                break;
                            }
                            ++i;
                        }
                        if (!isChinese) break block10;
                        if (content.length() <= 990) {
                            return true;
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        Logger.getSingleton().error(e, "\u9a8c\u8bc1\u4fe1\u606f\u5185\u5bb9\u662f\u5426\u5408\u6cd5\u5931\u8d25,\u77ed\u4fe1\u5185\u5bb9:" + content);
                        return false;
                    }
                }
                if (content.length() > 1980) break block9;
                return true;
            }
            Logger.getSingleton().info("\u9a8c\u8bc1\u4fe1\u606f\u5185\u5bb9\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300007 + ",\u77ed\u4fe1\u5185\u5bb9\u8fc7\u957f,\u77ed\u4fe1\u5185\u5bb9:" + content);
            return false;
        }
        Logger.getSingleton().info("\u9a8c\u8bc1\u4fe1\u606f\u5185\u5bb9\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300007 + ",\u77ed\u4fe1\u5185\u5bb9\u4e3a\u7a7a\u3002");
        return false;
    }

    public static boolean validateSubPort(String strSubPort) {
        block5: {
            block4: {
                try {
                    if (strSubPort != null && !"".equals(strSubPort.trim())) break block4;
                    return true;
                }
                catch (Exception e) {
                    Logger.getSingleton().error(e, "\u9a8c\u8bc1\u6269\u5c55\u5b50\u53f7\u662f\u5426\u5408\u6cd5\u5931\u8d25,\u6269\u5c55\u5b50\u53f7:" + strSubPort);
                    return false;
                }
            }
            if (strSubPort == null || "".equals(strSubPort.trim()) || !ValidateParamTool.isUnSignDigit(strSubPort) || strSubPort.length() >= 7) break block5;
            return true;
        }
        Logger.getSingleton().info("\u9a8c\u8bc1\u6269\u5c55\u5b50\u53f7\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300008 + ",\u6269\u5c55\u5b50\u53f7:" + strSubPort);
        return false;
    }

    public static boolean validateMobile(String mobile) {
        block3: {
            try {
                if (mobile == null || "".equals(mobile) || !ValidateParamTool.isUnSignDigit(mobile) || mobile.length() > 21) break block3;
                return true;
            }
            catch (Exception e) {
                Logger.getSingleton().error(e, "\u9a8c\u8bc1\u624b\u673a\u5355\u4e2a\u53f7\u7801\u662f\u5426\u5408\u6cd5\u5931\u8d25,\u624b\u673a\u53f7\u7801:" + mobile);
                return false;
            }
        }
        Logger.getSingleton().info("\u9a8c\u8bc1\u624b\u673a\u5355\u4e2a\u53f7\u7801\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300006 + ",\u624b\u673a\u53f7\u7801:" + mobile);
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String validateMobiles(String strMobiles) {
        block7: {
            try {
                if (strMobiles != null && !"".equals(strMobiles.trim())) {
                    String[] arrMobiles = strMobiles.split(",");
                    if (arrMobiles.length > 0 && arrMobiles.length <= 1000) {
                        int i = 0;
                        while (i < arrMobiles.length) {
                            if (arrMobiles[i] == null || "".equals(arrMobiles[i]) || !ValidateParamTool.isUnSignDigit(arrMobiles[i]) || arrMobiles[i].length() > 21) {
                                Logger.getSingleton().info("\u9a8c\u8bc1\u624b\u673a\u53f7\u7801\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300006 + ",\u9519\u8bef\u624b\u673a\u53f7\u7801:" + arrMobiles[i] + ",\u6240\u6709\u624b\u673a\u53f7\u7801:" + strMobiles);
                                return "illegalFormat";
                            }
                            ++i;
                        }
                        break block7;
                    }
                    if (arrMobiles.length > 1000) {
                        Logger.getSingleton().info("\u9a8c\u8bc1\u624b\u673a\u53f7\u7801\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300006 + ",\u624b\u673a\u53f7\u7801\u6ca1\u6709\u6216\u8005\u8d85\u8fc71000,\u6240\u6709\u624b\u673a\u53f7\u7801:" + strMobiles);
                        return "overNum";
                    }
                    Logger.getSingleton().info("\u9a8c\u8bc1\u624b\u673a\u53f7\u7801\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300006 + ",\u624b\u673a\u53f7\u7801 \u4e3a\u7a7a\u3002");
                    return "illegalFormat";
                }
                Logger.getSingleton().info("\u9a8c\u8bc1\u624b\u673a\u53f7\u7801\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300006 + ",\u624b\u673a\u53f7\u7801 \u4e3a\u7a7a\u3002");
                return "illegalFormat";
            }
            catch (Exception e) {
                Logger.getSingleton().error(e, "\u9a8c\u8bc1\u591a\u4e2a\u624b\u673a\u53f7\u7801\u662f\u5426\u5408\u6cd5\u5931\u8d25,\u591a\u4e2a\u624b\u673a\u53f7\u7801:" + strMobiles);
                return "fail";
            }
        }
        return "success";
    }

    public static int validateIpAndPort(String ipAddress) {
        try {
            if (ipAddress == null || "".equals(ipAddress.trim()) || !ipAddress.contains(":")) {
                Logger.getSingleton().info("\u9a8c\u8bc1IP\u548c\u7aef\u53e3\u4fe1\u606f\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300003 + ",IP\u548c\u7aef\u53e3\u4fe1\u606f:" + ipAddress);
                return StaticValue.ERROR_300003;
            }
            if (!ValidateParamTool.validateIP(ipAddress.split(":")[0])) {
                return StaticValue.ERROR_300004;
            }
            if (!ValidateParamTool.validatePort(ipAddress.split(":")[1])) {
                return StaticValue.ERROR_300005;
            }
            return 0;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u9a8c\u8bc1IP\u548c\u7aef\u53e3\u4fe1\u606f\u662f\u5426\u5408\u6cd5\u5931\u8d25,IP\u548c\u7aef\u53e3:" + ipAddress);
            return StaticValue.ERROR_300003;
        }
    }

    public static boolean validateIP(String ip) {
        block3: {
            try {
                if (ip == null || "".equals(ip.trim())) break block3;
                return true;
            }
            catch (Exception e) {
                Logger.getSingleton().error(e, "\u9a8c\u8bc1IP\u5730\u5740\u662f\u5426\u5408\u6cd5\u5931\u8d25,IP\u5730\u5740:" + ip);
                return false;
            }
        }
        Logger.getSingleton().info("\u9a8c\u8bc1IP\u5730\u5740\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300004 + ",IP\u5730\u5740:" + ip);
        return false;
    }

    public static boolean validatePort(String portStr) {
        try {
            Integer.parseInt(portStr);
            return true;
        }
        catch (Exception e) {
            Logger.getSingleton().error(e, "\u9a8c\u8bc1\u7aef\u53e3\u4e0d\u5408\u6cd5,\u9519\u8bef\u7801:" + StaticValue.ERROR_300005 + ",\u7aef\u53e3:" + portStr);
            return false;
        }
    }

    private static boolean isUnSignDigit(String str) {
        char[] num = str.toCharArray();
        int i = 0;
        while (i < num.length) {
            if (!Character.isDigit(num[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

